/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.file.nativeimpl;

import io.ballerina.runtime.api.Module;
import io.ballerina.runtime.api.creators.ErrorCreator;
import io.ballerina.runtime.api.creators.TypeCreator;
import io.ballerina.runtime.api.creators.ValueCreator;
import io.ballerina.runtime.api.types.ArrayType;
import io.ballerina.runtime.api.types.PredefinedTypes;
import io.ballerina.runtime.api.types.RecordType;
import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.api.utils.StringUtils;
import io.ballerina.runtime.api.values.BArray;
import io.ballerina.runtime.api.values.BError;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.stdlib.file.utils.FileUtils;
import io.ballerina.stdlib.file.utils.ModuleUtils;
import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Utils {
    private static final Logger log = LoggerFactory.getLogger(Utils.class);
    private static final String CURRENT_DIR_PROPERTY_KEY = "user.dir";
    private static final String TEMP_DIR_PROPERTY_KEY = "java.io.tmpdir";
    private static final String ERROR_MSG = "Error while deleting the file/directory: ";
    private static final List<RecordField> METADATA_RECORD_FIELDS = List.of(new RecordField("absPath", (Type)PredefinedTypes.TYPE_STRING), new RecordField("size", (Type)PredefinedTypes.TYPE_INT), new RecordField("modifiedTime", (Type)TypeCreator.createTupleType(List.of(PredefinedTypes.TYPE_INT, PredefinedTypes.TYPE_DECIMAL), (Type)PredefinedTypes.TYPE_NEVER, (int)0, (boolean)true)), new RecordField("dir", (Type)PredefinedTypes.TYPE_BOOLEAN), new RecordField("readable", (Type)PredefinedTypes.TYPE_BOOLEAN), new RecordField("writable", (Type)PredefinedTypes.TYPE_BOOLEAN));
    private static final RecordType METADATA_TYPE = Utils.createMetaDataType();
    private static final ArrayType METADATA_ARRAY_TYPE = TypeCreator.createArrayType((Type)METADATA_TYPE);

    public static BString getCurrentDirectory() {
        return StringUtils.fromString((String)FileUtils.getSystemProperty(CURRENT_DIR_PROPERTY_KEY));
    }

    public static Object createDir(BString dir, BString dirOption) {
        String op = dirOption.getValue();
        try {
            if (op.equals("RECURSIVE")) {
                Files.createDirectories(Paths.get(dir.getValue(), new String[0]), new FileAttribute[0]);
            } else {
                Files.createDirectory(Paths.get(dir.getValue(), new String[0]), new FileAttribute[0]);
            }
            return null;
        }
        catch (FileAlreadyExistsException e) {
            String msg = "File already exists. Failed to create the file: " + String.valueOf(dir);
            log.error(msg, (Throwable)e);
            return FileUtils.getBallerinaError("InvalidOperationError", msg);
        }
        catch (SecurityException e) {
            String msg = "Permission denied. Failed to create the file: " + String.valueOf(dir);
            log.error(msg, (Throwable)e);
            return FileUtils.getBallerinaError("PermissionError", msg);
        }
        catch (IOException e) {
            String msg = "IO error while creating the file " + String.valueOf(dir);
            log.error(msg, (Throwable)e);
            return FileUtils.getBallerinaError("FileSystemError", msg);
        }
        catch (Exception e) {
            String msg = "Error while creating the file " + String.valueOf(dir);
            log.error(msg, (Throwable)e);
            return FileUtils.getBallerinaError("FileSystemError", msg);
        }
    }

    public static Object rename(BString oldPath, BString newPath) {
        Path oldFilePath = Paths.get(oldPath.getValue(), new String[0]);
        Path newFilePath = Paths.get(newPath.getValue(), new String[0]);
        if (Files.notExists(oldFilePath, new LinkOption[0])) {
            return FileUtils.getBallerinaError("FileNotFoundError", "File not found: " + String.valueOf(oldFilePath.toAbsolutePath()));
        }
        try {
            Files.move(oldFilePath.toAbsolutePath(), newFilePath.toAbsolutePath(), new CopyOption[0]);
            return null;
        }
        catch (FileAlreadyExistsException e) {
            return FileUtils.getBallerinaError("InvalidOperationError", "File already exists in the new path " + String.valueOf(newFilePath));
        }
        catch (IOException e) {
            return FileUtils.getBallerinaError("FileSystemError", e);
        }
        catch (SecurityException e) {
            return FileUtils.getBallerinaError("PermissionError", e);
        }
    }

    public static Object createFile(BString path) {
        try {
            Files.createFile(Paths.get(path.getValue(), new String[0]), new FileAttribute[0]);
            return null;
        }
        catch (FileAlreadyExistsException e) {
            String msg = "File already exists. Failed to create the file: " + String.valueOf(path);
            log.error(msg, (Throwable)e);
            return FileUtils.getBallerinaError("InvalidOperationError", msg);
        }
        catch (SecurityException e) {
            String msg = "Permission denied. Failed to create the file: " + String.valueOf(path);
            log.error(msg, (Throwable)e);
            return FileUtils.getBallerinaError("PermissionError", msg);
        }
        catch (NoSuchFileException e) {
            String msg = "The file does not exist in path " + String.valueOf(path);
            return FileUtils.getBallerinaError("FileSystemError", msg);
        }
        catch (IOException e) {
            String msg = "IO error occurred while creating the file " + String.valueOf(path);
            log.error(msg, (Throwable)e);
            return FileUtils.getBallerinaError("FileSystemError", msg);
        }
        catch (Exception e) {
            String msg = "Error occurred while creating the file " + String.valueOf(path);
            log.error(msg, (Throwable)e);
            return FileUtils.getBallerinaError("FileSystemError", msg);
        }
    }

    public static Object getMetaData(BString path) {
        File inputFile = Paths.get(path.getValue(), new String[0]).toAbsolutePath().toFile();
        if (!inputFile.exists()) {
            return FileUtils.getBallerinaError("FileNotFoundError", "File not found: " + String.valueOf(path));
        }
        try {
            return FileUtils.getMetaData(inputFile);
        }
        catch (IOException e) {
            log.error("IO error while creating the file " + String.valueOf(path), (Throwable)e);
            return FileUtils.getBallerinaError("FileSystemError", e);
        }
    }

    public static Object remove(BString path, BString dirOption) {
        File removeFile = Paths.get(path.getValue(), new String[0]).toAbsolutePath().toFile();
        String wdBValue = FileUtils.getSystemProperty(CURRENT_DIR_PROPERTY_KEY);
        File wd = Paths.get(wdBValue, new String[0]).toAbsolutePath().toFile();
        String op = dirOption.getValue();
        try {
            if (wd.getCanonicalPath().equals(removeFile.getCanonicalPath())) {
                return FileUtils.getBallerinaError("InvalidOperationError", "Cannot delete the current working directory " + wd.getCanonicalPath());
            }
            if (!removeFile.exists()) {
                return FileUtils.getBallerinaError("FileNotFoundError", "File not found: " + removeFile.getCanonicalPath());
            }
            if (op.equals("RECURSIVE")) {
                Path directory = Paths.get(removeFile.getCanonicalPath(), new String[0]);
                Files.walkFileTree(directory, new RecursiveFileVisitor());
            } else {
                Files.delete(removeFile.toPath());
            }
            return null;
        }
        catch (IOException ex) {
            return FileUtils.getBallerinaError("FileSystemError", ERROR_MSG + ex.getMessage());
        }
        catch (SecurityException ex) {
            return FileUtils.getBallerinaError("PermissionError", ERROR_MSG + ex.getMessage());
        }
    }

    public static Object readDir(BString path) {
        File inputFile = Paths.get(path.getValue(), new String[0]).toAbsolutePath().toFile();
        if (!inputFile.exists()) {
            return FileUtils.getBallerinaError("FileNotFoundError", "File not found: " + String.valueOf(path));
        }
        if (!inputFile.isDirectory()) {
            return FileUtils.getBallerinaError("InvalidOperationError", "File in path " + String.valueOf(path) + " is not a directory");
        }
        return Utils.readFileTree(inputFile);
    }

    private static Object readFileTree(File inputFile) {
        BArray bArray;
        block9: {
            Stream<Path> walk = Files.walk(inputFile.toPath(), 1, new FileVisitOption[0]);
            try {
                Object[] results = walk.map(x -> {
                    try {
                        return FileUtils.getMetaData(x.toFile());
                    }
                    catch (IOException e) {
                        throw ErrorCreator.createError((BString)StringUtils.fromString((String)"Error while accessing file info"), (Throwable)e);
                    }
                }).skip(1L).toArray(Object[]::new);
                bArray = ValueCreator.createArrayValue((Object[])results, (ArrayType)METADATA_ARRAY_TYPE);
                if (walk == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (walk != null) {
                        try {
                            walk.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (BError | IOException ex) {
                    return FileUtils.getBallerinaError("FileSystemError", ex);
                }
                catch (SecurityException ex) {
                    return FileUtils.getBallerinaError("PermissionError", ex);
                }
            }
            walk.close();
        }
        return bArray;
    }

    private static RecordType createMetaDataType() {
        Map fields = METADATA_RECORD_FIELDS.stream().collect(HashMap::new, (m, v) -> m.put(v.name(), TypeCreator.createField((Type)v.type(), (String)v.name(), (long)0L)), Map::putAll);
        return TypeCreator.createRecordType((String)"MetaData", (Module)ModuleUtils.getModule(), (long)0L, (Map)fields, (Type)PredefinedTypes.TYPE_NEVER, (boolean)true, (int)0);
    }

    public static Object copy(BString sourcePath, BString destinationPath, BString ... copyOptions) {
        Path srcPath = Paths.get(sourcePath.getValue(), new String[0]);
        Path destPath = Paths.get(destinationPath.getValue(), new String[0]);
        ArrayList<Enum> options = new ArrayList<Enum>();
        if (copyOptions.length > 0) {
            for (BString op : copyOptions) {
                if ("REPLACE_EXISTING".equals(op.getValue())) {
                    options.add(StandardCopyOption.REPLACE_EXISTING);
                    continue;
                }
                if ("COPY_ATTRIBUTES".equals(op.getValue())) {
                    options.add(StandardCopyOption.COPY_ATTRIBUTES);
                    continue;
                }
                if ("NO_FOLLOW_LINKS".equals(op.getValue())) {
                    options.add(LinkOption.NOFOLLOW_LINKS);
                    continue;
                }
                return FileUtils.getBallerinaError("InvalidOperationError", "Invalid copy option.");
            }
        }
        CopyOption[] ops = new CopyOption[options.size()];
        ops = options.toArray(ops);
        if (Files.notExists(srcPath, new LinkOption[0])) {
            return FileUtils.getBallerinaError("FileNotFoundError", "File not found: " + String.valueOf(sourcePath));
        }
        try {
            if (srcPath.toFile().isDirectory()) {
                Files.walkFileTree(srcPath, new RecursiveDirCopyVisitor(srcPath, destPath, ops));
            } else {
                Files.walkFileTree(srcPath, new RecursiveFileCopyVisitor(srcPath, destPath, ops));
            }
        }
        catch (NoSuchFileException ex) {
            return FileUtils.getBallerinaError("FileNotFoundError", "The target directory does not exist: " + ex.getMessage());
        }
        catch (IOException ex) {
            return FileUtils.getBallerinaError("FileSystemError", "An error occurred when copying the file/s: " + ex.getMessage());
        }
        return null;
    }

    public static Object createTemp(Object suffix, Object prefix, Object dir) {
        String s = "";
        String p = "";
        String d = "";
        if (suffix != null) {
            s = ((BString)suffix).getValue().trim();
        }
        if (prefix != null) {
            p = ((BString)prefix).getValue().trim();
        }
        if (dir != null) {
            d = ((BString)dir).getValue().trim();
        }
        String filename = p + UUID.randomUUID().toString() + s;
        try {
            Path path;
            if (d.equals("")) {
                String tmpDir = System.getProperty(TEMP_DIR_PROPERTY_KEY);
                path = Files.createFile(Paths.get(tmpDir, filename), new FileAttribute[0]);
            } else {
                path = Files.createFile(Paths.get(d, filename), new FileAttribute[0]);
                Runtime.getRuntime().addShutdownHook(new Thread(() -> {
                    File rmFile = path.toAbsolutePath().toFile();
                    boolean result = rmFile.delete();
                    if (!result) {
                        log.error("Error deleting temporary file.");
                    }
                }));
            }
            return StringUtils.fromString((String)path.toString());
        }
        catch (Exception e) {
            String msg = "Error occurred while creating temporary file. ";
            log.error(msg, (Throwable)e);
            return FileUtils.getBallerinaError("FileSystemError", msg + e.getMessage());
        }
    }

    public static Object createTempDir(Object suffix, Object prefix, Object dir) {
        String s = "";
        String p = "";
        String d = "";
        if (suffix != null) {
            s = ((BString)suffix).getValue().trim();
        }
        if (prefix != null) {
            p = ((BString)prefix).getValue().trim();
        }
        if (dir != null) {
            d = ((BString)dir).getValue().trim();
        }
        String filename = p + UUID.randomUUID().toString() + s;
        try {
            Path path;
            if (d.equals("")) {
                String tmpDir = System.getProperty(TEMP_DIR_PROPERTY_KEY);
                path = Files.createDirectory(Paths.get(tmpDir, filename), new FileAttribute[0]);
            } else {
                path = Files.createDirectory(Paths.get(d, filename), new FileAttribute[0]);
                Runtime.getRuntime().addShutdownHook(new Thread(() -> {
                    File rmFile = path.toAbsolutePath().toFile();
                    boolean result = rmFile.delete();
                    if (!result) {
                        log.error("Error deleting temporary directory.");
                    }
                }));
            }
            return StringUtils.fromString((String)path.toString());
        }
        catch (Exception e) {
            String msg = "Error occurred while creating temporary directory. ";
            log.error(msg, (Throwable)e);
            return FileUtils.getBallerinaError("FileSystemError", msg + e.getMessage());
        }
    }

    public static Object test(BString path, BString testOption) {
        String op = testOption.getValue();
        Path strPath = Paths.get(path.getValue(), new String[0]);
        try {
            switch (op) {
                case "EXISTS": {
                    return Files.exists(strPath, new LinkOption[0]);
                }
                case "IS_DIR": {
                    return Files.isDirectory(strPath, new LinkOption[0]);
                }
                case "IS_SYMLINK": {
                    return Files.isSymbolicLink(strPath);
                }
                case "READABLE": {
                    return Files.isReadable(strPath);
                }
                case "WRITABLE": {
                    return Files.isWritable(strPath);
                }
            }
            return FileUtils.getBallerinaError("InvalidOperationError", "Unsupported test option.");
        }
        catch (Exception e) {
            String msg = "Error occurred while testing file path. ";
            log.error(msg, (Throwable)e);
            return FileUtils.getBallerinaError("PermissionError", msg + e.getMessage());
        }
    }

    private Utils() {
    }

    static class RecursiveFileVisitor
    extends SimpleFileVisitor<Path> {
        RecursiveFileVisitor() {
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
            Files.delete(file);
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
            Files.delete(dir);
            return FileVisitResult.CONTINUE;
        }
    }

    static class RecursiveDirCopyVisitor
    extends SimpleFileVisitor<Path> {
        final Path source;
        final Path target;
        final CopyOption[] copyOptions;

        RecursiveDirCopyVisitor(Path source, Path target, CopyOption ... copyOptions) {
            this.source = source;
            this.target = target;
            this.copyOptions = copyOptions;
        }

        @Override
        public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
            Path targetPath = this.target.resolve(this.source.relativize(dir));
            if (!Files.exists(targetPath, new LinkOption[0])) {
                Files.createDirectory(targetPath, new FileAttribute[0]);
            }
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
            Files.copy(file, this.target.resolve(this.source.relativize(file)), this.copyOptions);
            return FileVisitResult.CONTINUE;
        }
    }

    static class RecursiveFileCopyVisitor
    extends SimpleFileVisitor<Path> {
        final Path source;
        final Path target;
        final CopyOption[] copyOptions;

        RecursiveFileCopyVisitor(Path source, Path target, CopyOption ... copyOptions) {
            this.source = source;
            this.target = target;
            this.copyOptions = copyOptions;
        }

        @Override
        public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
            Path newDirectory = this.target.resolve(this.source.relativize(dir));
            try {
                Files.copy(dir, newDirectory, this.copyOptions);
            }
            catch (Exception e) {
                log.debug(e.getMessage());
                return FileVisitResult.SKIP_SUBTREE;
            }
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
            Path newFile = this.target.resolve(this.source.relativize(file));
            try {
                Files.copy(file, newFile, this.copyOptions);
            }
            catch (Exception e) {
                log.debug(e.getMessage());
                return FileVisitResult.SKIP_SUBTREE;
            }
            return FileVisitResult.CONTINUE;
        }
    }

    private record RecordField(String name, Type type) {
    }
}

