/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.file.service.endpoint;

import io.ballerina.runtime.api.Environment;
import io.ballerina.runtime.api.utils.TypeUtils;
import io.ballerina.runtime.api.values.BMap;
import io.ballerina.runtime.api.values.BObject;
import io.ballerina.stdlib.file.service.DirectoryListenerConstants;
import io.ballerina.stdlib.file.service.FSListener;
import io.ballerina.stdlib.file.transport.contract.FileSystemServerConnector;
import io.ballerina.stdlib.file.transport.contractimpl.FileSystemConnectorFactoryImpl;
import io.ballerina.stdlib.file.utils.FileUtils;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import org.wso2.transport.localfilesystem.server.exception.LocalFileSystemServerConnectorException;

public class InitEndpoint {
    public static Object initEndpoint(Environment env, BObject listener) {
        BMap serviceEndpointConfig = listener.getMapValue(DirectoryListenerConstants.SERVICE_ENDPOINT_CONFIG);
        String path = serviceEndpointConfig.getStringValue(DirectoryListenerConstants.ANNOTATION_PATH).getValue();
        if (path.isEmpty()) {
            return FileUtils.getBallerinaError("FileSystemError", "'path' field is empty");
        }
        Path dirPath = Paths.get(path, new String[0]);
        if (Files.notExists(dirPath, new LinkOption[0])) {
            return FileUtils.getBallerinaError("FileSystemError", "Folder does not exist: " + path);
        }
        if (!Files.isDirectory(dirPath, new LinkOption[0])) {
            return FileUtils.getBallerinaError("FileSystemError", "Unable to find a directory: " + path);
        }
        FileSystemConnectorFactoryImpl connectorFactory = new FileSystemConnectorFactoryImpl();
        Map<String, String> configMap = InitEndpoint.readConfiguration(serviceEndpointConfig);
        FileSystemServerConnector serverConnector = null;
        try {
            serverConnector = connectorFactory.createServerConnector(TypeUtils.getType((Object)listener).getName(), configMap, new FSListener(env.getRuntime()));
            listener.addNativeData("serverConnector", (Object)serverConnector);
        }
        catch (LocalFileSystemServerConnectorException e) {
            return FileUtils.getBallerinaError("FileSystemError", "Unable to initialize server connector: " + e.getMessage());
        }
        return null;
    }

    private static Map<String, String> readConfiguration(BMap serviceEndpointConfig) {
        String path = serviceEndpointConfig.getStringValue(DirectoryListenerConstants.ANNOTATION_PATH).getValue();
        boolean recursive = serviceEndpointConfig.getBooleanValue(DirectoryListenerConstants.ANNOTATION_DIRECTORY_RECURSIVE);
        HashMap<String, String> paramMap = new HashMap<String, String>(3);
        paramMap.put("dirURI", path);
        String event = String.join((CharSequence)",", "create", "modify", "delete");
        paramMap.put("events", event);
        paramMap.put("recursive", String.valueOf(recursive));
        return paramMap;
    }

    private InitEndpoint() {
    }
}

