/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.file.service.endpoint;

import io.ballerina.runtime.api.creators.ErrorCreator;
import io.ballerina.runtime.api.types.MethodType;
import io.ballerina.runtime.api.types.ObjectType;
import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.api.utils.StringUtils;
import io.ballerina.runtime.api.utils.TypeUtils;
import io.ballerina.runtime.api.values.BObject;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.stdlib.file.service.FSListener;
import io.ballerina.stdlib.file.transport.contract.FileSystemServerConnector;
import java.util.HashMap;
import java.util.Map;

public class Register {
    public static Object register(BObject listener, BObject service) {
        Object fsServerConnector = listener.getNativeData("serverConnector");
        if (fsServerConnector instanceof FileSystemServerConnector) {
            FileSystemServerConnector serverConnector = (FileSystemServerConnector)fsServerConnector;
            FSListener fsListener = serverConnector.getDirectoryListener();
            fsListener.addService(service, Register.getResourceRegistry(service));
        }
        return null;
    }

    private static Map<String, MethodType> getResourceRegistry(BObject service) {
        MethodType[] attachedFunctions;
        HashMap<String, MethodType> registry = new HashMap<String, MethodType>(5);
        block10: for (MethodType resource : attachedFunctions = ((ObjectType)TypeUtils.getReferredType((Type)TypeUtils.getType((Object)service))).getMethods()) {
            switch (resource.getName()) {
                case "onCreate": {
                    registry.put("create", resource);
                    continue block10;
                }
                case "onDelete": {
                    registry.put("delete", resource);
                    continue block10;
                }
                case "onModify": {
                    registry.put("modify", resource);
                    continue block10;
                }
            }
        }
        if (registry.size() == 0) {
            String msg = "At least a single resource required from following: onCreate ,onDelete ,onModify. Parameter should be of type - file:FileEvent";
            throw ErrorCreator.createError((BString)StringUtils.fromString((String)msg));
        }
        return registry;
    }

    public static Object deregister(BObject listener, BObject service) {
        Object fsServerConnector = listener.getNativeData("serverConnector");
        if (fsServerConnector instanceof FileSystemServerConnector) {
            FileSystemServerConnector serverConnector = (FileSystemServerConnector)fsServerConnector;
            FSListener fsListener = serverConnector.getDirectoryListener();
            fsListener.removeService(service);
        }
        return null;
    }

    private Register() {
    }
}

