/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.http.compiler;

import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.projects.plugins.CodeAnalyzer;
import io.ballerina.projects.plugins.CodeModifier;
import io.ballerina.projects.plugins.CompilerPlugin;
import io.ballerina.projects.plugins.CompilerPluginContext;
import io.ballerina.projects.plugins.codeaction.CodeAction;
import io.ballerina.projects.plugins.completion.CompletionProvider;
import io.ballerina.scan.ScannerContext;
import io.ballerina.stdlib.http.compiler.HttpServiceAnalyzer;
import io.ballerina.stdlib.http.compiler.codeaction.AddHeaderParameterCodeAction;
import io.ballerina.stdlib.http.compiler.codeaction.AddInterceptorRemoteMethodCodeAction;
import io.ballerina.stdlib.http.compiler.codeaction.AddInterceptorResourceMethodCodeAction;
import io.ballerina.stdlib.http.compiler.codeaction.AddPayloadParameterCodeAction;
import io.ballerina.stdlib.http.compiler.codeaction.AddResponseCacheConfigCodeAction;
import io.ballerina.stdlib.http.compiler.codeaction.AddResponseContentTypeCodeAction;
import io.ballerina.stdlib.http.compiler.codeaction.ChangeHeaderParamTypeToStringArrayCodeAction;
import io.ballerina.stdlib.http.compiler.codeaction.ChangeHeaderParamTypeToStringCodeAction;
import io.ballerina.stdlib.http.compiler.codeaction.ChangeReturnTypeWithCallerCodeAction;
import io.ballerina.stdlib.http.compiler.codeaction.ImplementServiceContract;
import io.ballerina.stdlib.http.compiler.codemodifier.HttpServiceModifier;
import io.ballerina.stdlib.http.compiler.completion.HttpServiceBodyContextProvider;
import io.ballerina.stdlib.http.compiler.staticcodeanalyzer.HttpStaticCodeAnalyzer;
import java.util.List;
import java.util.Map;

public class HttpCompilerPlugin
extends CompilerPlugin {
    public void init(CompilerPluginContext context) {
        Map ctxData = context.userData();
        ctxData.put("HTTP_CODE_MODIFIER_EXECUTED", false);
        context.addCodeModifier((CodeModifier)new HttpServiceModifier(ctxData));
        context.addCodeAnalyzer((CodeAnalyzer)new HttpServiceAnalyzer(ctxData));
        this.getCodeActions().forEach(arg_0 -> ((CompilerPluginContext)context).addCodeAction(arg_0));
        this.getCompletionProviders().forEach(arg_0 -> ((CompilerPluginContext)context).addCompletionProvider(arg_0));
        Object object = context.userData().get("ScannerContext");
        if (object instanceof ScannerContext) {
            ScannerContext scannerContext = (ScannerContext)object;
            context.addCodeAnalyzer((CodeAnalyzer)new HttpStaticCodeAnalyzer(scannerContext.getReporter()));
        }
    }

    private List<CodeAction> getCodeActions() {
        return List.of(new ChangeHeaderParamTypeToStringCodeAction(), new ChangeHeaderParamTypeToStringArrayCodeAction(), new ChangeReturnTypeWithCallerCodeAction(), new AddPayloadParameterCodeAction(), new AddHeaderParameterCodeAction(), new AddResponseContentTypeCodeAction(), new AddResponseCacheConfigCodeAction(), new AddInterceptorResourceMethodCodeAction(), new AddInterceptorRemoteMethodCodeAction(), new ImplementServiceContract());
    }

    private List<CompletionProvider<? extends Node>> getCompletionProviders() {
        return List.of(new HttpServiceBodyContextProvider());
    }
}

