/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.http.compiler;

import io.ballerina.compiler.api.SemanticModel;
import io.ballerina.compiler.api.symbols.MethodSymbol;
import io.ballerina.compiler.api.symbols.ParameterSymbol;
import io.ballerina.compiler.api.symbols.Qualifier;
import io.ballerina.compiler.api.symbols.TypeDescKind;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import io.ballerina.compiler.syntax.tree.ClassDefinitionNode;
import io.ballerina.compiler.syntax.tree.FunctionDefinitionNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeList;
import io.ballerina.compiler.syntax.tree.NodeLocation;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.TypeReferenceNode;
import io.ballerina.projects.plugins.AnalysisTask;
import io.ballerina.projects.plugins.SyntaxNodeAnalysisContext;
import io.ballerina.stdlib.http.compiler.HttpCompilerPluginUtil;
import io.ballerina.stdlib.http.compiler.HttpDiagnostic;
import io.ballerina.stdlib.http.compiler.HttpInterceptorResourceValidator;
import io.ballerina.tools.diagnostics.DiagnosticFactory;
import io.ballerina.tools.diagnostics.DiagnosticInfo;
import io.ballerina.tools.diagnostics.DiagnosticSeverity;
import io.ballerina.tools.diagnostics.Location;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class HttpInterceptorServiceValidator
implements AnalysisTask<SyntaxNodeAnalysisContext> {
    public void perform(SyntaxNodeAnalysisContext syntaxNodeAnalysisContext) {
        List diagnostics = syntaxNodeAnalysisContext.semanticModel().diagnostics();
        boolean erroneousCompilation = diagnostics.stream().anyMatch(d -> DiagnosticSeverity.ERROR.equals((Object)d.diagnosticInfo().severity()));
        if (erroneousCompilation) {
            return;
        }
        ClassDefinitionNode classDefinitionNode = (ClassDefinitionNode)syntaxNodeAnalysisContext.node();
        NodeList tokens = classDefinitionNode.classTypeQualifiers();
        if (tokens.isEmpty()) {
            return;
        }
        if (!tokens.stream().allMatch(token -> token.text().equals("service"))) {
            return;
        }
        NodeList members = classDefinitionNode.members();
        HttpInterceptorServiceValidator.validateInterceptorTypeAndProceed(syntaxNodeAnalysisContext, (NodeList<Node>)members, HttpCompilerPluginUtil.getCtxTypes(syntaxNodeAnalysisContext));
    }

    private static void validateInterceptorTypeAndProceed(SyntaxNodeAnalysisContext ctx, NodeList<Node> members, Map<String, TypeSymbol> typeSymbols) {
        String interceptorType = null;
        for (Node member : members) {
            String typeReference;
            if (member.kind() != SyntaxKind.TYPE_REFERENCE) continue;
            switch (typeReference = ((TypeReferenceNode)member).typeName().toString()) {
                case "http:RequestInterceptor": {
                    if (interceptorType == null) {
                        interceptorType = "RequestInterceptor";
                        break;
                    }
                    HttpInterceptorServiceValidator.reportMultipleReferencesFound(ctx, (TypeReferenceNode)member);
                    return;
                }
                case "http:RequestErrorInterceptor": {
                    if (interceptorType == null) {
                        interceptorType = "RequestErrorInterceptor";
                        break;
                    }
                    HttpInterceptorServiceValidator.reportMultipleReferencesFound(ctx, (TypeReferenceNode)member);
                    return;
                }
                case "http:ResponseInterceptor": {
                    if (interceptorType == null) {
                        interceptorType = "ResponseInterceptor";
                        break;
                    }
                    HttpInterceptorServiceValidator.reportMultipleReferencesFound(ctx, (TypeReferenceNode)member);
                    return;
                }
                case "http:ResponseErrorInterceptor": {
                    if (interceptorType == null) {
                        interceptorType = "ResponseErrorInterceptor";
                        break;
                    }
                    HttpInterceptorServiceValidator.reportMultipleReferencesFound(ctx, (TypeReferenceNode)member);
                    return;
                }
            }
        }
        if (interceptorType != null) {
            HttpInterceptorServiceValidator.validateInterceptorMethod(ctx, members, interceptorType, typeSymbols);
        }
    }

    private static void validateInterceptorMethod(SyntaxNodeAnalysisContext ctx, NodeList<Node> members, String type, Map<String, TypeSymbol> typeSymbols) {
        FunctionDefinitionNode resourceFunctionNode = null;
        FunctionDefinitionNode remoteFunctionNode = null;
        for (Node member : members) {
            if (member.kind() == SyntaxKind.RESOURCE_ACCESSOR_DEFINITION) {
                if (!HttpInterceptorServiceValidator.isResourceSupported(type)) {
                    HttpInterceptorServiceValidator.reportResourceFunctionNotAllowed(ctx, member, type);
                }
                if (resourceFunctionNode == null) {
                    resourceFunctionNode = (FunctionDefinitionNode)member;
                    continue;
                }
                HttpInterceptorServiceValidator.reportMultipleResourceFunctionsFound(ctx, (FunctionDefinitionNode)member);
                continue;
            }
            if (!(member instanceof FunctionDefinitionNode) || !HttpInterceptorServiceValidator.isRemoteFunction(ctx, (FunctionDefinitionNode)member) || !HttpInterceptorServiceValidator.isValidRemoteFunctionName(ctx, type, member) || remoteFunctionNode != null) continue;
            remoteFunctionNode = (FunctionDefinitionNode)member;
        }
        if (HttpInterceptorServiceValidator.isResourceSupported(type)) {
            if (resourceFunctionNode != null) {
                HttpInterceptorResourceValidator.validateResource(ctx, resourceFunctionNode, type, typeSymbols);
            } else {
                HttpInterceptorServiceValidator.reportResourceFunctionNotFound(ctx, type);
            }
        } else if (remoteFunctionNode != null) {
            HttpInterceptorServiceValidator.validateRemoteMethod(ctx, remoteFunctionNode, type, typeSymbols);
        } else {
            HttpInterceptorServiceValidator.reportRemoteFunctionNotFound(ctx, type);
        }
    }

    private static boolean isValidRemoteFunctionName(SyntaxNodeAnalysisContext ctx, String type, Node member) {
        if (HttpInterceptorServiceValidator.isResourceSupported(type)) {
            HttpInterceptorServiceValidator.reportRemoteFunctionNotAllowed(ctx, member, type);
            return false;
        }
        String remoteFunctionName = String.valueOf(((FunctionDefinitionNode)member).functionName()).trim();
        if (HttpInterceptorServiceValidator.isResponseErrorInterceptor(type)) {
            if (!remoteFunctionName.equals("interceptResponseError")) {
                HttpInterceptorServiceValidator.reportInvalidRemoteFunction(ctx, member, remoteFunctionName, type, "interceptResponseError");
                return false;
            }
            return true;
        }
        if (!remoteFunctionName.equals("interceptResponse")) {
            HttpInterceptorServiceValidator.reportInvalidRemoteFunction(ctx, member, remoteFunctionName, type, "interceptResponse");
            return false;
        }
        return true;
    }

    public static MethodSymbol getMethodSymbol(SyntaxNodeAnalysisContext context, FunctionDefinitionNode functionDefinitionNode) {
        MethodSymbol methodSymbol = null;
        SemanticModel semanticModel = context.semanticModel();
        Optional symbol = semanticModel.symbol((Node)functionDefinitionNode);
        if (symbol.isPresent()) {
            methodSymbol = (MethodSymbol)symbol.get();
        }
        return methodSymbol;
    }

    public static boolean isRemoteFunction(SyntaxNodeAnalysisContext context, FunctionDefinitionNode functionDefinitionNode) {
        return HttpInterceptorServiceValidator.isRemoteFunction(HttpInterceptorServiceValidator.getMethodSymbol(context, functionDefinitionNode));
    }

    private static boolean isResponseErrorInterceptor(String type) {
        return type.equals("ResponseErrorInterceptor");
    }

    public static boolean isRemoteFunction(MethodSymbol methodSymbol) {
        return methodSymbol.qualifiers().contains(Qualifier.REMOTE);
    }

    private static boolean isResourceSupported(String type) {
        return type.equals("RequestInterceptor") || type.equals("RequestErrorInterceptor");
    }

    private static void validateRemoteMethod(SyntaxNodeAnalysisContext ctx, FunctionDefinitionNode member, String type, Map<String, TypeSymbol> typeSymbols) {
        HttpInterceptorServiceValidator.validateInputParamType(ctx, member, type, typeSymbols);
        HttpCompilerPluginUtil.extractInterceptorReturnTypeAndValidate(ctx, typeSymbols, member, HttpDiagnostic.HTTP_141);
    }

    private static void validateInputParamType(SyntaxNodeAnalysisContext ctx, FunctionDefinitionNode member, String type, Map<String, TypeSymbol> typeSymbols) {
        boolean callerPresent = false;
        boolean requestPresent = false;
        boolean responsePresent = false;
        boolean requestCtxPresent = false;
        boolean errorPresent = false;
        Optional remoteMethodSymbolOptional = ctx.semanticModel().symbol((Node)member);
        NodeLocation paramLocation = member.location();
        if (remoteMethodSymbolOptional.isEmpty()) {
            return;
        }
        Optional parametersOptional = ((MethodSymbol)remoteMethodSymbolOptional.get()).typeDescriptor().params();
        if (parametersOptional.isEmpty()) {
            return;
        }
        for (ParameterSymbol param : (List)parametersOptional.get()) {
            String paramType = param.typeDescriptor().signature();
            Optional paramLocationOptional = param.getLocation();
            if (paramLocationOptional.isPresent()) {
                paramLocation = (Location)paramLocationOptional.get();
            }
            Optional nameOptional = param.getName();
            String paramName = nameOptional.orElse("");
            TypeDescKind kind = param.typeDescriptor().typeKind();
            TypeSymbol typeSymbol = param.typeDescriptor();
            if (HttpCompilerPluginUtil.subtypeOf(typeSymbols, typeSymbol, "Caller")) {
                callerPresent = HttpInterceptorServiceValidator.isObjectPresent(ctx, (Location)paramLocation, callerPresent, paramName, HttpDiagnostic.HTTP_115);
                continue;
            }
            if (HttpCompilerPluginUtil.subtypeOf(typeSymbols, typeSymbol, "Request")) {
                requestPresent = HttpInterceptorServiceValidator.isObjectPresent(ctx, (Location)paramLocation, requestPresent, paramName, HttpDiagnostic.HTTP_116);
                continue;
            }
            if (HttpCompilerPluginUtil.subtypeOf(typeSymbols, typeSymbol, "Response")) {
                responsePresent = HttpInterceptorServiceValidator.isObjectPresent(ctx, (Location)paramLocation, responsePresent, paramName, HttpDiagnostic.HTTP_139);
                continue;
            }
            if (HttpCompilerPluginUtil.subtypeOf(typeSymbols, typeSymbol, "RequestContext")) {
                requestCtxPresent = HttpInterceptorServiceValidator.isObjectPresent(ctx, (Location)paramLocation, requestCtxPresent, paramName, HttpDiagnostic.HTTP_121);
                continue;
            }
            if (HttpInterceptorServiceValidator.isResponseErrorInterceptor(type) && kind == TypeDescKind.ERROR) {
                errorPresent = HttpInterceptorServiceValidator.isObjectPresent(ctx, (Location)paramLocation, errorPresent, paramName, HttpDiagnostic.HTTP_122);
                continue;
            }
            HttpInterceptorServiceValidator.reportInvalidParameterType(ctx, (Location)paramLocation, paramType, HttpInterceptorServiceValidator.isResponseErrorInterceptor(type));
        }
        if (HttpInterceptorServiceValidator.isResponseErrorInterceptor(type) && !errorPresent) {
            HttpCompilerPluginUtil.reportMissingParameterError(ctx, (Location)member.location(), "remote");
        }
    }

    private static boolean isObjectPresent(SyntaxNodeAnalysisContext ctx, Location location, boolean objectPresent, String paramName, HttpDiagnostic code) {
        if (objectPresent) {
            HttpCompilerPluginUtil.updateDiagnostic(ctx, location, code, paramName);
        }
        return true;
    }

    private static void reportInvalidParameterType(SyntaxNodeAnalysisContext ctx, Location location, String typeName, boolean isResponseErrorInterceptor) {
        String functionName = isResponseErrorInterceptor ? "interceptResponseError" : "interceptResponse";
        HttpCompilerPluginUtil.updateDiagnostic(ctx, location, HttpDiagnostic.HTTP_140, typeName, functionName);
    }

    private static void reportMultipleReferencesFound(SyntaxNodeAnalysisContext ctx, TypeReferenceNode node) {
        HttpCompilerPluginUtil.updateDiagnostic(ctx, (Location)node.location(), HttpDiagnostic.HTTP_123, node.typeName().toString());
    }

    private static void reportMultipleResourceFunctionsFound(SyntaxNodeAnalysisContext ctx, FunctionDefinitionNode node) {
        DiagnosticInfo diagnosticInfo = new DiagnosticInfo(HttpDiagnostic.HTTP_124.getCode(), HttpDiagnostic.HTTP_124.getMessage(), HttpDiagnostic.HTTP_124.getSeverity());
        ctx.reportDiagnostic(DiagnosticFactory.createDiagnostic((DiagnosticInfo)diagnosticInfo, (Location)node.location(), (Object[])new Object[0]));
    }

    private static void reportResourceFunctionNotFound(SyntaxNodeAnalysisContext ctx, String type) {
        HttpCompilerPluginUtil.updateDiagnostic(ctx, (Location)ctx.node().location(), HttpDiagnostic.HTTP_132, type);
    }

    private static void reportRemoteFunctionNotFound(SyntaxNodeAnalysisContext ctx, String type) {
        String requiredFunctionName = HttpInterceptorServiceValidator.isResponseErrorInterceptor(type) ? "interceptResponseError" : "interceptResponse";
        DiagnosticInfo diagnosticInfo = HttpCompilerPluginUtil.getDiagnosticInfo(HttpDiagnostic.HTTP_135, type, requiredFunctionName);
        ctx.reportDiagnostic(DiagnosticFactory.createDiagnostic((DiagnosticInfo)diagnosticInfo, (Location)ctx.node().location(), (Object[])new Object[0]));
    }

    private static void reportResourceFunctionNotAllowed(SyntaxNodeAnalysisContext ctx, Node node, String type) {
        HttpCompilerPluginUtil.updateDiagnostic(ctx, (Location)node.location(), HttpDiagnostic.HTTP_136, type);
    }

    private static void reportRemoteFunctionNotAllowed(SyntaxNodeAnalysisContext ctx, Node node, String type) {
        HttpCompilerPluginUtil.updateDiagnostic(ctx, (Location)node.location(), HttpDiagnostic.HTTP_137, type);
    }

    private static void reportInvalidRemoteFunction(SyntaxNodeAnalysisContext ctx, Node node, String functionName, String interceptorType, String requiredFunctionName) {
        DiagnosticInfo diagnosticInfo = HttpCompilerPluginUtil.getDiagnosticInfo(HttpDiagnostic.HTTP_138, functionName, interceptorType, requiredFunctionName);
        ctx.reportDiagnostic(DiagnosticFactory.createDiagnostic((DiagnosticInfo)diagnosticInfo, (Location)node.location(), (Object[])new Object[0]));
    }
}

