/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.http.compiler;

import io.ballerina.compiler.api.symbols.ResourceMethodSymbol;
import io.ballerina.compiler.api.symbols.resourcepath.PathSegmentList;
import io.ballerina.compiler.api.symbols.resourcepath.ResourcePath;
import io.ballerina.compiler.api.symbols.resourcepath.util.PathSegment;
import io.ballerina.compiler.syntax.tree.AbstractNodeFactory;
import io.ballerina.compiler.syntax.tree.AnnotationNode;
import io.ballerina.compiler.syntax.tree.DefaultableParameterNode;
import io.ballerina.compiler.syntax.tree.FunctionDefinitionNode;
import io.ballerina.compiler.syntax.tree.IncludedRecordParameterNode;
import io.ballerina.compiler.syntax.tree.MetadataNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeList;
import io.ballerina.compiler.syntax.tree.ParameterNode;
import io.ballerina.compiler.syntax.tree.RequiredParameterNode;
import io.ballerina.compiler.syntax.tree.RestParameterNode;
import io.ballerina.compiler.syntax.tree.ReturnTypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.SeparatedNodeList;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.projects.plugins.SyntaxNodeAnalysisContext;
import io.ballerina.stdlib.http.compiler.HttpCompilerPluginUtil;
import io.ballerina.stdlib.http.compiler.HttpDiagnostic;
import io.ballerina.tools.diagnostics.Location;
import java.util.ArrayList;
import java.util.Optional;
import java.util.Set;

public final class HttpServiceContractResourceValidator {
    private HttpServiceContractResourceValidator() {
    }

    public static void validateResource(SyntaxNodeAnalysisContext ctx, FunctionDefinitionNode member, Set<String> resourcesFromServiceType, String serviceTypeName) {
        Object t;
        Optional functionDefinitionSymbol = ctx.semanticModel().symbol((Node)member);
        if (functionDefinitionSymbol.isEmpty() || !((t = functionDefinitionSymbol.get()) instanceof ResourceMethodSymbol)) {
            return;
        }
        ResourceMethodSymbol resourceMethodSymbol = (ResourceMethodSymbol)t;
        ResourcePath resourcePath = resourceMethodSymbol.resourcePath();
        String resourceName = resourceMethodSymbol.getName().orElse("") + " " + HttpServiceContractResourceValidator.constructResourcePathName(resourcePath);
        if (!resourcesFromServiceType.contains(resourceName)) {
            HttpServiceContractResourceValidator.reportResourceFunctionNotAllowed(ctx, serviceTypeName, (Location)member.location());
        }
        HttpServiceContractResourceValidator.validateAnnotationUsages(ctx, member);
    }

    public static void validateAnnotationUsages(SyntaxNodeAnalysisContext ctx, FunctionDefinitionNode resourceFunction) {
        HttpServiceContractResourceValidator.validateAnnotationUsagesOnResourceFunction(ctx, resourceFunction);
        HttpServiceContractResourceValidator.validateAnnotationUsagesOnInputParams(ctx, resourceFunction);
        HttpServiceContractResourceValidator.validateAnnotationUsagesOnReturnType(ctx, resourceFunction);
    }

    public static void validateAnnotationUsagesOnResourceFunction(SyntaxNodeAnalysisContext ctx, FunctionDefinitionNode resourceFunction) {
        Optional metadataNodeOptional = resourceFunction.metadata();
        if (metadataNodeOptional.isEmpty()) {
            return;
        }
        NodeList annotations = ((MetadataNode)metadataNodeOptional.get()).annotations();
        for (AnnotationNode annotation : annotations) {
            String[] annotStrings;
            Node annotReference = annotation.annotReference();
            String annotName = annotReference.toString();
            if (annotReference.kind() != SyntaxKind.QUALIFIED_NAME_REFERENCE || !"ResourceConfig".equals((annotStrings = annotName.split(":"))[annotStrings.length - 1].trim()) || !"http".equals(annotStrings[0].trim())) continue;
            HttpServiceContractResourceValidator.reportResourceConfigAnnotationNotAllowed(ctx, (Location)annotation.location());
        }
    }

    public static void validateAnnotationUsagesOnInputParams(SyntaxNodeAnalysisContext ctx, FunctionDefinitionNode resourceFunction) {
        SeparatedNodeList parameters = resourceFunction.functionSignature().parameters();
        for (ParameterNode parameter : parameters) {
            NodeList<AnnotationNode> annotations = HttpServiceContractResourceValidator.getAnnotationsFromParameter(parameter);
            for (AnnotationNode annotation : annotations) {
                Node annotReference = annotation.annotReference();
                String annotName = annotReference.toString();
                if (annotReference.kind() != SyntaxKind.QUALIFIED_NAME_REFERENCE) continue;
                String[] annotationStrings = annotName.split(":");
                String annotationName = annotationStrings[annotationStrings.length - 1].trim();
                if (!"http".equals(annotationStrings[0].trim()) || !annotationName.equals("Payload") && !annotationName.equals("Header") && !annotationName.equals("Query") && !annotationName.equals("Caller")) continue;
                HttpServiceContractResourceValidator.reportAnnotationNotAllowed(ctx, (Location)annotation.location(), "http:" + annotationName);
            }
        }
    }

    public static NodeList<AnnotationNode> getAnnotationsFromParameter(ParameterNode parameter) {
        if (parameter instanceof RequiredParameterNode) {
            RequiredParameterNode parameterNode = (RequiredParameterNode)parameter;
            return parameterNode.annotations();
        }
        if (parameter instanceof DefaultableParameterNode) {
            DefaultableParameterNode parameterNode = (DefaultableParameterNode)parameter;
            return parameterNode.annotations();
        }
        if (parameter instanceof IncludedRecordParameterNode) {
            IncludedRecordParameterNode parameterNode = (IncludedRecordParameterNode)parameter;
            return parameterNode.annotations();
        }
        if (parameter instanceof RestParameterNode) {
            RestParameterNode parameterNode = (RestParameterNode)parameter;
            return parameterNode.annotations();
        }
        return AbstractNodeFactory.createEmptyNodeList();
    }

    public static void validateAnnotationUsagesOnReturnType(SyntaxNodeAnalysisContext ctx, FunctionDefinitionNode resourceFunction) {
        Optional returnTypeDescriptorNode = resourceFunction.functionSignature().returnTypeDesc();
        if (returnTypeDescriptorNode.isEmpty()) {
            return;
        }
        NodeList annotations = ((ReturnTypeDescriptorNode)returnTypeDescriptorNode.get()).annotations();
        for (AnnotationNode annotation : annotations) {
            Node annotReference = annotation.annotReference();
            String annotName = annotReference.toString();
            if (annotReference.kind() != SyntaxKind.QUALIFIED_NAME_REFERENCE) continue;
            String[] annotationStrings = annotName.split(":");
            String annotationName = annotationStrings[annotationStrings.length - 1].trim();
            if (!"http".equals(annotationStrings[0].trim()) || !annotationName.equals("Payload") && !annotationName.equals("Cache")) continue;
            HttpServiceContractResourceValidator.reportAnnotationNotAllowed(ctx, (Location)annotation.location(), "http:" + annotationName);
        }
    }

    public static String constructResourcePathName(ResourcePath resourcePath) {
        return switch (resourcePath.kind()) {
            case ResourcePath.Kind.DOT_RESOURCE_PATH -> ".";
            case ResourcePath.Kind.PATH_SEGMENT_LIST -> HttpServiceContractResourceValidator.constructResourcePathNameFromSegList((PathSegmentList)resourcePath);
            default -> "^^";
        };
    }

    public static String constructResourcePathNameFromSegList(PathSegmentList pathSegmentList) {
        ArrayList<String> resourcePaths = new ArrayList<String>();
        block4: for (PathSegment pathSegment : pathSegmentList.list()) {
            switch (pathSegment.pathSegmentKind()) {
                case NAMED_SEGMENT: {
                    resourcePaths.add(pathSegment.getName().orElse(""));
                    continue block4;
                }
                case PATH_PARAMETER: {
                    resourcePaths.add("^");
                    continue block4;
                }
            }
            resourcePaths.add("^^");
        }
        return resourcePaths.isEmpty() ? "" : String.join((CharSequence)"/", resourcePaths);
    }

    private static void reportResourceFunctionNotAllowed(SyntaxNodeAnalysisContext ctx, String serviceContractType, Location location) {
        HttpCompilerPluginUtil.updateDiagnostic(ctx, location, HttpDiagnostic.HTTP_158, serviceContractType);
    }

    private static void reportResourceConfigAnnotationNotAllowed(SyntaxNodeAnalysisContext ctx, Location location) {
        HttpCompilerPluginUtil.updateDiagnostic(ctx, location, HttpDiagnostic.HTTP_159);
    }

    private static void reportAnnotationNotAllowed(SyntaxNodeAnalysisContext ctx, Location location, String annotationName) {
        HttpCompilerPluginUtil.updateDiagnostic(ctx, location, HttpDiagnostic.HTTP_160, annotationName);
    }
}

