/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.http.compiler;

import io.ballerina.compiler.api.SemanticModel;
import io.ballerina.compiler.api.symbols.TypeDefinitionSymbol;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeList;
import io.ballerina.compiler.syntax.tree.ObjectTypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.TypeDefinitionNode;
import io.ballerina.projects.plugins.SyntaxNodeAnalysisContext;
import io.ballerina.stdlib.http.compiler.HttpCompilerPluginUtil;
import io.ballerina.stdlib.http.compiler.HttpServiceValidator;
import java.util.Optional;

public class HttpServiceObjTypeAnalyzer
extends HttpServiceValidator {
    @Override
    public void perform(SyntaxNodeAnalysisContext context) {
        if (HttpCompilerPluginUtil.diagnosticContainsErrors(context)) {
            return;
        }
        Node typeNode = context.node();
        if (!HttpCompilerPluginUtil.isHttpServiceType(context.semanticModel(), typeNode)) {
            return;
        }
        ObjectTypeDescriptorNode serviceObjectType = (ObjectTypeDescriptorNode)typeNode;
        Optional metadataNodeOptional = ((TypeDefinitionNode)serviceObjectType.parent()).metadata();
        metadataNodeOptional.ifPresent(metadataNode -> HttpServiceObjTypeAnalyzer.validateServiceAnnotation(context, metadataNode, null, HttpServiceObjTypeAnalyzer.isServiceContractType(context.semanticModel(), serviceObjectType)));
        NodeList members = serviceObjectType.members();
        HttpServiceObjTypeAnalyzer.validateResources(context, (NodeList<Node>)members);
    }

    private static boolean isServiceContractType(SemanticModel semanticModel, ObjectTypeDescriptorNode serviceObjType) {
        Object t;
        Object t2;
        Optional serviceObjSymbol = semanticModel.symbol((Node)serviceObjType.parent());
        if (serviceObjSymbol.isEmpty() || !((t2 = serviceObjSymbol.get()) instanceof TypeDefinitionSymbol)) {
            return false;
        }
        TypeDefinitionSymbol serviceObjTypeDef = (TypeDefinitionSymbol)t2;
        Optional serviceContractType = semanticModel.types().getTypeByName("ballerina", "http", "", "ServiceContract");
        if (serviceContractType.isEmpty() || !((t = serviceContractType.get()) instanceof TypeDefinitionSymbol)) {
            return false;
        }
        TypeDefinitionSymbol serviceContractTypeDef = (TypeDefinitionSymbol)t;
        return serviceObjTypeDef.typeDescriptor().subtypeOf(serviceContractTypeDef.typeDescriptor());
    }
}

