/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.http.compiler;

import io.ballerina.compiler.api.ModuleID;
import io.ballerina.compiler.api.symbols.ModuleSymbol;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeVisitor;
import io.ballerina.compiler.syntax.tree.PositionalArgumentNode;
import io.ballerina.compiler.syntax.tree.RemoteMethodCallActionNode;
import io.ballerina.compiler.syntax.tree.SimpleNameReferenceNode;
import io.ballerina.projects.plugins.SyntaxNodeAnalysisContext;
import java.util.ArrayList;
import java.util.List;

public class RespondExpressionVisitor
extends NodeVisitor {
    private final SyntaxNodeAnalysisContext ctx;
    private final String callerToken;
    private List<PositionalArgumentNode> respondStatementNodes = new ArrayList<PositionalArgumentNode>();

    RespondExpressionVisitor(SyntaxNodeAnalysisContext ctx, String callerToken) {
        this.ctx = ctx;
        this.callerToken = callerToken;
    }

    public void visit(RemoteMethodCallActionNode node) {
        SimpleNameReferenceNode simpleNameReferenceNode = node.methodName();
        if (!simpleNameReferenceNode.name().text().equals("respond")) {
            return;
        }
        TypeSymbol typeSymbol = (TypeSymbol)this.ctx.semanticModel().type((Node)node.expression()).get();
        ModuleID moduleID = ((ModuleSymbol)typeSymbol.getModule().get()).id();
        if (!"ballerina".equals(moduleID.orgName())) {
            return;
        }
        if (!"http".equals(moduleID.moduleName())) {
            return;
        }
        if (!"Caller".equals(typeSymbol.getName().get())) {
            return;
        }
        if (!this.callerToken.equals(node.expression().toString())) {
            return;
        }
        if (node.arguments().size() > 0) {
            this.respondStatementNodes.add((PositionalArgumentNode)node.arguments().get(0));
        }
    }

    List<PositionalArgumentNode> getRespondStatementNodes() {
        return this.respondStatementNodes;
    }
}

