/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.http.compiler.codeaction;

import io.ballerina.compiler.syntax.tree.ClassDefinitionNode;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.SyntaxTree;
import io.ballerina.projects.plugins.codeaction.CodeAction;
import io.ballerina.projects.plugins.codeaction.CodeActionArgument;
import io.ballerina.projects.plugins.codeaction.CodeActionContext;
import io.ballerina.projects.plugins.codeaction.CodeActionExecutionContext;
import io.ballerina.projects.plugins.codeaction.CodeActionInfo;
import io.ballerina.projects.plugins.codeaction.DocumentEdit;
import io.ballerina.stdlib.http.compiler.codeaction.CodeActionUtil;
import io.ballerina.tools.diagnostics.Diagnostic;
import io.ballerina.tools.text.LineRange;
import io.ballerina.tools.text.TextDocument;
import io.ballerina.tools.text.TextDocumentChange;
import io.ballerina.tools.text.TextEdit;
import io.ballerina.tools.text.TextRange;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

public abstract class AddInterceptorMethodCodeAction
implements CodeAction {
    public List<String> supportedDiagnosticCodes() {
        return List.of(this.diagnosticCode());
    }

    public Optional<CodeActionInfo> codeActionInfo(CodeActionContext context) {
        Diagnostic diagnostic = context.diagnostic();
        SyntaxTree syntaxTree = context.currentDocument().syntaxTree();
        NonTerminalNode node = CodeActionUtil.findNode(syntaxTree, diagnostic.location().lineRange());
        CodeActionArgument location = CodeActionArgument.from((String)"node.location", (Object)node.lineRange());
        CodeActionArgument isError = CodeActionArgument.from((String)"node.errorInterceptor", (Object)diagnostic.message().contains("Error"));
        CodeActionInfo info = CodeActionInfo.from((String)String.format("Add interceptor %s method", this.methodKind()), List.of(location, isError));
        return Optional.of(info);
    }

    public List<DocumentEdit> execute(CodeActionExecutionContext context) {
        LineRange lineRange = null;
        boolean isErrorInterceptor = false;
        for (CodeActionArgument arg : context.arguments()) {
            if ("node.location".equals(arg.key())) {
                lineRange = (LineRange)arg.valueAs(LineRange.class);
            }
            if (!"node.errorInterceptor".equals(arg.key())) continue;
            isErrorInterceptor = (Boolean)arg.valueAs(Boolean.TYPE);
        }
        if (lineRange == null) {
            return Collections.emptyList();
        }
        SyntaxTree syntaxTree = context.currentDocument().syntaxTree();
        NonTerminalNode node = CodeActionUtil.findNode(syntaxTree, lineRange);
        if (!node.kind().equals((Object)SyntaxKind.CLASS_DEFINITION)) {
            return Collections.emptyList();
        }
        TextRange textRange = TextRange.from((int)((ClassDefinitionNode)node).closeBrace().textRange().startOffset(), (int)0);
        String method = this.methodSignature(isErrorInterceptor);
        ArrayList<TextEdit> textEdits = new ArrayList<TextEdit>();
        textEdits.add(TextEdit.from((TextRange)textRange, (String)method));
        TextDocumentChange change = TextDocumentChange.from((TextEdit[])textEdits.toArray(new TextEdit[0]));
        TextDocument modifiedTextDocument = syntaxTree.textDocument().apply(change);
        return Collections.singletonList(new DocumentEdit(context.fileUri(), SyntaxTree.from((TextDocument)modifiedTextDocument)));
    }

    protected abstract String diagnosticCode();

    protected abstract String methodKind();

    protected abstract String methodSignature(boolean var1);
}

