/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.http.compiler.codeaction;

import io.ballerina.compiler.syntax.tree.FunctionSignatureNode;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.ReturnTypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.SyntaxTree;
import io.ballerina.projects.plugins.codeaction.CodeAction;
import io.ballerina.projects.plugins.codeaction.CodeActionContext;
import io.ballerina.projects.plugins.codeaction.CodeActionExecutionContext;
import io.ballerina.projects.plugins.codeaction.CodeActionInfo;
import io.ballerina.projects.plugins.codeaction.DocumentEdit;
import io.ballerina.stdlib.http.compiler.codeaction.CodeActionUtil;
import io.ballerina.tools.diagnostics.Diagnostic;
import io.ballerina.tools.text.LinePosition;
import io.ballerina.tools.text.LineRange;
import io.ballerina.tools.text.TextDocument;
import io.ballerina.tools.text.TextDocumentChange;
import io.ballerina.tools.text.TextEdit;
import io.ballerina.tools.text.TextRange;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

public abstract class AddResourceParameterCodeAction
implements CodeAction {
    public List<String> supportedDiagnosticCodes() {
        return List.of(this.diagnosticCode());
    }

    public Optional<CodeActionInfo> codeActionInfo(CodeActionContext context) {
        Diagnostic diagnostic = context.diagnostic();
        SyntaxTree syntaxTree = context.currentDocument().syntaxTree();
        NonTerminalNode node = CodeActionUtil.findNode(syntaxTree, diagnostic.location().lineRange());
        if (!node.kind().equals((Object)SyntaxKind.FUNCTION_SIGNATURE)) {
            return Optional.empty();
        }
        Optional cursorPosition = context.cursorPosition();
        if (cursorPosition.isEmpty()) {
            return Optional.empty();
        }
        Optional returnNode = ((FunctionSignatureNode)node).returnTypeDesc();
        if (returnNode.isPresent() && CodeActionUtil.isWithinRange(((ReturnTypeDescriptorNode)returnNode.get()).lineRange(), (LinePosition)cursorPosition.get())) {
            return Optional.empty();
        }
        return CodeActionUtil.getCodeActionInfoWithLocation(node, String.format("Add %s parameter", this.paramKind()));
    }

    public List<DocumentEdit> execute(CodeActionExecutionContext context) {
        Optional<LineRange> lineRange = CodeActionUtil.getLineRangeFromLocationKey(context);
        if (lineRange.isEmpty()) {
            return Collections.emptyList();
        }
        SyntaxTree syntaxTree = context.currentDocument().syntaxTree();
        NonTerminalNode node = CodeActionUtil.findNode(syntaxTree, lineRange.get());
        if (!node.kind().equals((Object)SyntaxKind.FUNCTION_SIGNATURE)) {
            return Collections.emptyList();
        }
        Object payloadParam = this.paramSignature();
        int start = ((FunctionSignatureNode)node).openParenToken().position() + 1;
        int end = ((FunctionSignatureNode)node).closeParenToken().position();
        if (end - start != 0) {
            payloadParam = ", " + (String)payloadParam;
        }
        TextRange textRange = TextRange.from((int)end, (int)0);
        ArrayList<TextEdit> textEdits = new ArrayList<TextEdit>();
        textEdits.add(TextEdit.from((TextRange)textRange, (String)payloadParam));
        TextDocumentChange change = TextDocumentChange.from((TextEdit[])textEdits.toArray(new TextEdit[0]));
        TextDocument modifiedTextDocument = syntaxTree.textDocument().apply(change);
        return Collections.singletonList(new DocumentEdit(context.fileUri(), SyntaxTree.from((TextDocument)modifiedTextDocument)));
    }

    protected abstract String diagnosticCode();

    protected abstract String paramKind();

    protected abstract String paramSignature();
}

