/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.http.compiler.codeaction;

import io.ballerina.compiler.api.SemanticModel;
import io.ballerina.compiler.api.symbols.MethodSymbol;
import io.ballerina.compiler.api.symbols.ObjectTypeSymbol;
import io.ballerina.compiler.api.symbols.ResourceMethodSymbol;
import io.ballerina.compiler.api.symbols.Symbol;
import io.ballerina.compiler.api.symbols.TypeReferenceTypeSymbol;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import io.ballerina.compiler.api.symbols.resourcepath.ResourcePath;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeList;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.ServiceDeclarationNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.SyntaxTree;
import io.ballerina.compiler.syntax.tree.TypeDescriptorNode;
import io.ballerina.projects.plugins.codeaction.CodeAction;
import io.ballerina.projects.plugins.codeaction.CodeActionContext;
import io.ballerina.projects.plugins.codeaction.CodeActionExecutionContext;
import io.ballerina.projects.plugins.codeaction.CodeActionInfo;
import io.ballerina.projects.plugins.codeaction.DocumentEdit;
import io.ballerina.stdlib.http.compiler.HttpDiagnostic;
import io.ballerina.stdlib.http.compiler.HttpServiceContractResourceValidator;
import io.ballerina.stdlib.http.compiler.HttpServiceValidator;
import io.ballerina.stdlib.http.compiler.codeaction.CodeActionUtil;
import io.ballerina.stdlib.http.compiler.codeaction.Constants;
import io.ballerina.tools.text.LineRange;
import io.ballerina.tools.text.TextDocument;
import io.ballerina.tools.text.TextDocumentChange;
import io.ballerina.tools.text.TextEdit;
import io.ballerina.tools.text.TextRange;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ImplementServiceContract
implements CodeAction {
    public List<String> supportedDiagnosticCodes() {
        return List.of(HttpDiagnostic.HTTP_HINT_105.getCode());
    }

    public Optional<CodeActionInfo> codeActionInfo(CodeActionContext context) {
        NonTerminalNode node = CodeActionUtil.findNode(context.currentDocument().syntaxTree(), context.diagnostic().location().lineRange());
        if (!node.kind().equals((Object)SyntaxKind.SERVICE_DECLARATION)) {
            return Optional.empty();
        }
        return CodeActionUtil.getCodeActionInfoWithLocation(node, "Implement service contract resources");
    }

    public List<DocumentEdit> execute(CodeActionExecutionContext context) {
        Object t;
        Optional<LineRange> lineRange = CodeActionUtil.getLineRangeFromLocationKey(context);
        if (lineRange.isEmpty()) {
            return Collections.emptyList();
        }
        SyntaxTree syntaxTree = context.currentDocument().syntaxTree();
        SemanticModel semanticModel = context.currentSemanticModel();
        NonTerminalNode node = CodeActionUtil.findNode(syntaxTree, lineRange.get());
        if (!node.kind().equals((Object)SyntaxKind.SERVICE_DECLARATION)) {
            return Collections.emptyList();
        }
        Optional<TypeDescriptorNode> serviceTypeDesc = HttpServiceValidator.getServiceContractTypeDesc(semanticModel, (ServiceDeclarationNode)node);
        if (serviceTypeDesc.isEmpty()) {
            return Collections.emptyList();
        }
        Optional serviceTypeSymbol = semanticModel.symbol((Node)serviceTypeDesc.get());
        if (serviceTypeSymbol.isEmpty() || !((t = serviceTypeSymbol.get()) instanceof TypeReferenceTypeSymbol)) {
            return Collections.emptyList();
        }
        TypeReferenceTypeSymbol serviceTypeRef = (TypeReferenceTypeSymbol)t;
        TypeSymbol serviceTypeRefSymbol = serviceTypeRef.typeDescriptor();
        if (!(serviceTypeRefSymbol instanceof ObjectTypeSymbol)) {
            return Collections.emptyList();
        }
        ObjectTypeSymbol serviceObjTypeSymbol = (ObjectTypeSymbol)serviceTypeRefSymbol;
        NodeList members = ((ServiceDeclarationNode)node).members();
        ArrayList<CallSite> existingMethods = new ArrayList<CallSite>();
        for (Node member : members) {
            Object t2;
            Optional functionDefinitionSymbol;
            if (member.kind() != SyntaxKind.RESOURCE_ACCESSOR_DEFINITION || (functionDefinitionSymbol = semanticModel.symbol(member)).isEmpty() || !((t2 = functionDefinitionSymbol.get()) instanceof ResourceMethodSymbol)) continue;
            ResourceMethodSymbol resourceMethodSymbol = (ResourceMethodSymbol)t2;
            ResourcePath resourcePath = resourceMethodSymbol.resourcePath();
            existingMethods.add((CallSite)((Object)(resourceMethodSymbol.getName().orElse("") + " " + HttpServiceContractResourceValidator.constructResourcePathName(resourcePath))));
        }
        Map methodSymbolMap = serviceObjTypeSymbol.methods();
        String parentModuleName = this.getParentModuleName(semanticModel, (ServiceDeclarationNode)node);
        StringBuilder methods = new StringBuilder();
        for (Map.Entry entry : methodSymbolMap.entrySet()) {
            MethodSymbol methodSymbol;
            if (existingMethods.contains(entry.getKey()) || !((methodSymbol = (MethodSymbol)entry.getValue()) instanceof ResourceMethodSymbol)) continue;
            ResourceMethodSymbol resourceMethodSymbol = (ResourceMethodSymbol)methodSymbol;
            methods.append(this.getMethodSignature(resourceMethodSymbol, parentModuleName));
        }
        TextRange textRange = TextRange.from((int)((ServiceDeclarationNode)node).closeBraceToken().textRange().startOffset(), (int)0);
        ArrayList<TextEdit> textEdits = new ArrayList<TextEdit>();
        textEdits.add(TextEdit.from((TextRange)textRange, (String)methods.toString()));
        TextDocumentChange change = TextDocumentChange.from((TextEdit[])textEdits.toArray(new TextEdit[0]));
        TextDocument modifiedTextDocument = syntaxTree.textDocument().apply(change);
        return Collections.singletonList(new DocumentEdit(context.fileUri(), SyntaxTree.from((TextDocument)modifiedTextDocument)));
    }

    private String getMethodSignature(ResourceMethodSymbol resourceMethodSymbol, String parentModuleName) {
        String resourceSignature = resourceMethodSymbol.signature();
        if (Objects.nonNull(parentModuleName)) {
            resourceSignature = resourceSignature.replace(parentModuleName + ":", "");
        }
        return Constants.LS + "\t" + this.sanitizePackageNames(resourceSignature) + " {" + Constants.LS + Constants.LS + "\t}" + Constants.LS;
    }

    private String sanitizePackageNames(String input) {
        Pattern pattern = Pattern.compile("(\\w+)/(\\w+:)(\\d+\\.\\d+\\.\\d+):");
        Matcher matcher = pattern.matcher(input);
        return matcher.replaceAll("$2");
    }

    private String getParentModuleName(SemanticModel semanticModel, ServiceDeclarationNode serviceDeclarationNode) {
        Optional serviceDeclarationSymbol = semanticModel.symbol((Node)serviceDeclarationNode);
        if (serviceDeclarationSymbol.isEmpty()) {
            return null;
        }
        Optional module = ((Symbol)serviceDeclarationSymbol.get()).getModule();
        return module.map(moduleSymbol -> moduleSymbol.id().toString()).orElse(null);
    }

    public String name() {
        return "IMPLEMENT_SERVICE_CONTRACT";
    }
}

