/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.http.compiler.codemodifier.payload;

import io.ballerina.compiler.api.ModuleID;
import io.ballerina.compiler.api.symbols.AnnotationSymbol;
import io.ballerina.compiler.api.symbols.ModuleSymbol;
import io.ballerina.compiler.api.symbols.ParameterSymbol;
import io.ballerina.compiler.api.symbols.ResourceMethodSymbol;
import io.ballerina.compiler.api.symbols.Symbol;
import io.ballerina.compiler.api.symbols.TypeDescKind;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import io.ballerina.compiler.api.symbols.UnionTypeSymbol;
import io.ballerina.compiler.syntax.tree.ClassDefinitionNode;
import io.ballerina.compiler.syntax.tree.FunctionDefinitionNode;
import io.ballerina.compiler.syntax.tree.MethodDeclarationNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeList;
import io.ballerina.compiler.syntax.tree.ObjectTypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.ServiceDeclarationNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.TypeReferenceNode;
import io.ballerina.projects.DocumentId;
import io.ballerina.projects.plugins.SyntaxNodeAnalysisContext;
import io.ballerina.stdlib.http.compiler.HttpCompilerPluginUtil;
import io.ballerina.stdlib.http.compiler.HttpDiagnostic;
import io.ballerina.stdlib.http.compiler.HttpResourceValidator;
import io.ballerina.stdlib.http.compiler.HttpServiceValidator;
import io.ballerina.stdlib.http.compiler.ResourceFunction;
import io.ballerina.stdlib.http.compiler.ResourceFunctionDeclaration;
import io.ballerina.stdlib.http.compiler.ResourceFunctionDefinition;
import io.ballerina.stdlib.http.compiler.codemodifier.payload.context.PayloadParamAvailability;
import io.ballerina.stdlib.http.compiler.codemodifier.payload.context.PayloadParamContext;
import io.ballerina.stdlib.http.compiler.codemodifier.payload.context.PayloadParamData;
import io.ballerina.stdlib.http.compiler.codemodifier.payload.context.ResourcePayloadParamContext;
import io.ballerina.stdlib.http.compiler.codemodifier.payload.context.ServicePayloadParamContext;
import io.ballerina.tools.diagnostics.Location;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

public class HttpPayloadParamIdentifier
extends HttpServiceValidator {
    private final Map<DocumentId, PayloadParamContext> documentContextMap;

    public HttpPayloadParamIdentifier(Map<DocumentId, PayloadParamContext> documentContextMap) {
        this.documentContextMap = documentContextMap;
    }

    @Override
    public void perform(SyntaxNodeAnalysisContext syntaxNodeAnalysisContext) {
        if (HttpCompilerPluginUtil.diagnosticContainsErrors(syntaxNodeAnalysisContext)) {
            return;
        }
        Map<String, TypeSymbol> typeSymbols = HttpCompilerPluginUtil.getCtxTypes(syntaxNodeAnalysisContext);
        SyntaxKind kind = syntaxNodeAnalysisContext.node().kind();
        if (kind == SyntaxKind.SERVICE_DECLARATION) {
            this.validateServiceDeclaration(syntaxNodeAnalysisContext, typeSymbols);
        } else if (kind == SyntaxKind.CLASS_DEFINITION) {
            this.validateClassDefinition(syntaxNodeAnalysisContext, typeSymbols);
        } else if (kind == SyntaxKind.OBJECT_TYPE_DESC && HttpCompilerPluginUtil.isHttpServiceType(syntaxNodeAnalysisContext.semanticModel(), syntaxNodeAnalysisContext.node())) {
            this.validateServiceObjDefinition(syntaxNodeAnalysisContext, typeSymbols);
        }
    }

    private void validateServiceDeclaration(SyntaxNodeAnalysisContext syntaxNodeAnalysisContext, Map<String, TypeSymbol> typeSymbols) {
        ServiceDeclarationNode serviceDeclarationNode = HttpCompilerPluginUtil.getServiceDeclarationNode(syntaxNodeAnalysisContext);
        if (serviceDeclarationNode == null) {
            return;
        }
        NodeList members = serviceDeclarationNode.members();
        ServicePayloadParamContext serviceContext = new ServicePayloadParamContext(serviceDeclarationNode.hashCode());
        this.validateResources(syntaxNodeAnalysisContext, typeSymbols, (NodeList<Node>)members, serviceContext);
    }

    private void validateServiceObjDefinition(SyntaxNodeAnalysisContext context, Map<String, TypeSymbol> typeSymbols) {
        ObjectTypeDescriptorNode serviceObjType = (ObjectTypeDescriptorNode)context.node();
        NodeList members = serviceObjType.members();
        ServicePayloadParamContext serviceContext = new ServicePayloadParamContext(serviceObjType.hashCode());
        this.validateResources(context, typeSymbols, (NodeList<Node>)members, serviceContext);
    }

    private void validateResources(SyntaxNodeAnalysisContext syntaxNodeAnalysisContext, Map<String, TypeSymbol> typeSymbols, NodeList<Node> members, ServicePayloadParamContext serviceContext) {
        for (Node member : members) {
            if (member.kind() == SyntaxKind.RESOURCE_ACCESSOR_DEFINITION) {
                this.validateResource(syntaxNodeAnalysisContext, new ResourceFunctionDefinition((FunctionDefinitionNode)member), serviceContext, typeSymbols);
                continue;
            }
            if (member.kind() != SyntaxKind.RESOURCE_ACCESSOR_DECLARATION) continue;
            this.validateResource(syntaxNodeAnalysisContext, new ResourceFunctionDeclaration((MethodDeclarationNode)member), serviceContext, typeSymbols);
        }
    }

    private void validateClassDefinition(SyntaxNodeAnalysisContext syntaxNodeAnalysisContext, Map<String, TypeSymbol> typeSymbols) {
        ClassDefinitionNode classDefinitionNode = (ClassDefinitionNode)syntaxNodeAnalysisContext.node();
        NodeList tokens = classDefinitionNode.classTypeQualifiers();
        if (tokens.isEmpty()) {
            return;
        }
        if (!tokens.stream().allMatch(token -> token.text().equals("service"))) {
            return;
        }
        NodeList members = classDefinitionNode.members();
        ServicePayloadParamContext serviceContext = new ServicePayloadParamContext(classDefinitionNode.hashCode());
        boolean proceed = false;
        for (Node member : members) {
            String typeReference;
            if (member.kind() != SyntaxKind.TYPE_REFERENCE) continue;
            switch (typeReference = ((TypeReferenceNode)member).typeName().toString()) {
                case "http:Service": 
                case "http:RequestInterceptor": 
                case "http:RequestErrorInterceptor": {
                    proceed = true;
                    break;
                }
            }
        }
        if (proceed) {
            this.validateResources(syntaxNodeAnalysisContext, typeSymbols, (NodeList<Node>)members, serviceContext);
        }
    }

    void validateResource(SyntaxNodeAnalysisContext ctx, ResourceFunction member, ServicePayloadParamContext serviceContext, Map<String, TypeSymbol> typeSymbols) {
        this.extractInputParamTypeAndValidate(ctx, member, serviceContext, typeSymbols);
    }

    void extractInputParamTypeAndValidate(SyntaxNodeAnalysisContext ctx, ResourceFunction member, ServicePayloadParamContext serviceContext, Map<String, TypeSymbol> typeSymbols) {
        Optional<Symbol> resourceMethodSymbolOptional = member.getSymbol(ctx.semanticModel());
        if (resourceMethodSymbolOptional.isEmpty()) {
            return;
        }
        int resourceId = member.getResourceIdentifierCode();
        Optional resourceMethodOptional = resourceMethodSymbolOptional.get().getName();
        if (resourceMethodOptional.isPresent()) {
            String accessor = (String)resourceMethodOptional.get();
            if (accessor.equals("get") || accessor.equals("head") || accessor.equals("options")) {
                return;
            }
        } else {
            return;
        }
        Optional parametersOptional = ((ResourceMethodSymbol)resourceMethodSymbolOptional.get()).typeDescriptor().params();
        if (parametersOptional.isEmpty()) {
            return;
        }
        ArrayList<PayloadParamData> nonAnnotatedParams = new ArrayList<PayloadParamData>();
        ArrayList<PayloadParamData> annotatedParams = new ArrayList<PayloadParamData>();
        PayloadParamAvailability paramAvailability = new PayloadParamAvailability();
        paramAvailability.setErrorDiagnostic(false);
        int index = 0;
        for (ParameterSymbol param : (List)parametersOptional.get()) {
            List annotations = param.annotations().stream().filter(annotationSymbol -> annotationSymbol.typeDescriptor().isPresent() && this.isHttpPackageAnnotationTypeDesc((TypeSymbol)annotationSymbol.typeDescriptor().get())).collect(Collectors.toList());
            if (annotations.isEmpty()) {
                nonAnnotatedParams.add(new PayloadParamData(param, index++));
                continue;
            }
            annotatedParams.add(new PayloadParamData(param, index++));
        }
        for (PayloadParamData annotatedParam : annotatedParams) {
            HttpPayloadParamIdentifier.validateAnnotatedParams(annotatedParam.getParameterSymbol(), paramAvailability);
            if (!paramAvailability.isAnnotatedPayloadParam()) continue;
            return;
        }
        for (PayloadParamData nonAnnotatedParam : nonAnnotatedParams) {
            ParameterSymbol parameterSymbol = nonAnnotatedParam.getParameterSymbol();
            if (HttpPayloadParamIdentifier.validateNonAnnotatedParams(ctx, parameterSymbol.typeDescriptor(), paramAvailability, parameterSymbol, typeSymbols)) {
                ResourcePayloadParamContext resourceContext = new ResourcePayloadParamContext(parameterSymbol, nonAnnotatedParam.getIndex());
                PayloadParamContext documentContext = this.documentContextMap.get(ctx.documentId());
                if (documentContext == null) {
                    documentContext = new PayloadParamContext(ctx);
                    this.documentContextMap.put(ctx.documentId(), documentContext);
                }
                serviceContext.setResourceContext(resourceId, resourceContext);
                documentContext.setServiceContext(serviceContext);
            }
            if (!paramAvailability.isErrorOccurred()) continue;
            serviceContext.removeResourceContext(resourceId);
            return;
        }
    }

    private boolean isHttpPackageAnnotationTypeDesc(TypeSymbol typeSymbol) {
        Optional module = typeSymbol.getModule();
        if (module.isEmpty()) {
            return false;
        }
        ModuleID id = ((ModuleSymbol)module.get()).id();
        return id.orgName().equals("ballerina") && id.moduleName().startsWith("http");
    }

    public static void validateAnnotatedParams(ParameterSymbol parameterSymbol, PayloadParamAvailability paramAvailability) {
        List annotations = parameterSymbol.annotations().stream().filter(annotationSymbol -> annotationSymbol.typeDescriptor().isPresent()).collect(Collectors.toList());
        for (AnnotationSymbol annotation : annotations) {
            Optional annotationTypeSymbol = annotation.typeDescriptor();
            if (annotationTypeSymbol.isEmpty()) {
                return;
            }
            Optional annotationTypeNameOptional = ((TypeSymbol)annotationTypeSymbol.get()).getName();
            if (annotationTypeNameOptional.isEmpty()) {
                return;
            }
            String typeName = (String)annotationTypeNameOptional.get();
            if (!typeName.equals("HttpPayload")) continue;
            paramAvailability.setAnnotatedPayloadParam(true);
        }
    }

    public static boolean validateNonAnnotatedParams(SyntaxNodeAnalysisContext analysisContext, TypeSymbol typeSymbol, PayloadParamAvailability paramAvailability, ParameterSymbol parameterSymbol, Map<String, TypeSymbol> typeSymbols) {
        if ((typeSymbol = HttpResourceValidator.getEffectiveType(typeSymbol)).typeKind() == TypeDescKind.UNION && HttpPayloadParamIdentifier.isUnionStructuredType(analysisContext, (UnionTypeSymbol)typeSymbol, parameterSymbol, paramAvailability, typeSymbols)) {
            if (!HttpCompilerPluginUtil.subtypeOf(typeSymbols, typeSymbol, "anydata")) {
                HttpResourceValidator.reportInvalidPayloadParameterType(analysisContext, (Location)parameterSymbol.getLocation().get(), parameterSymbol.typeDescriptor().signature());
                paramAvailability.setErrorOccurred(true);
                return false;
            }
            return HttpPayloadParamIdentifier.checkErrorsAndReturn(analysisContext, paramAvailability, parameterSymbol);
        }
        if (HttpPayloadParamIdentifier.isStructuredType(typeSymbols, typeSymbol)) {
            if (!HttpCompilerPluginUtil.subtypeOf(typeSymbols, typeSymbol, "anydata")) {
                HttpResourceValidator.reportInvalidPayloadParameterType(analysisContext, (Location)parameterSymbol.getLocation().get(), parameterSymbol.typeDescriptor().signature());
                paramAvailability.setErrorOccurred(true);
                return false;
            }
            return HttpPayloadParamIdentifier.checkErrorsAndReturn(analysisContext, paramAvailability, parameterSymbol);
        }
        return false;
    }

    private static boolean isUnionStructuredType(SyntaxNodeAnalysisContext ctx, UnionTypeSymbol unionTypeSymbol, ParameterSymbol parameterSymbol, PayloadParamAvailability paramAvailability, Map<String, TypeSymbol> typeSymbols) {
        List typeDescriptors = unionTypeSymbol.memberTypeDescriptors();
        boolean foundNonStructuredType = false;
        boolean foundStructuredType = false;
        for (TypeSymbol symbol : typeDescriptors) {
            if (HttpPayloadParamIdentifier.isNilableType(typeSymbols, symbol)) continue;
            if (HttpPayloadParamIdentifier.isStructuredType(typeSymbols, symbol)) {
                foundStructuredType = true;
                if (!foundNonStructuredType) continue;
                HttpPayloadParamIdentifier.reportInvalidUnionPayloadParam(ctx, parameterSymbol, paramAvailability);
                return false;
            }
            foundNonStructuredType = true;
            if (!foundStructuredType) continue;
            HttpPayloadParamIdentifier.reportInvalidUnionPayloadParam(ctx, parameterSymbol, paramAvailability);
            return false;
        }
        return foundStructuredType;
    }

    private static boolean isNilableType(Map<String, TypeSymbol> typeSymbols, TypeSymbol typeSymbol) {
        return HttpCompilerPluginUtil.subtypeOf(typeSymbols, typeSymbol, "nil");
    }

    private static boolean isStructuredType(Map<String, TypeSymbol> typeSymbols, TypeSymbol typeSymbol) {
        if (HttpCompilerPluginUtil.subtypeOf(typeSymbols, typeSymbol, "byte[]")) {
            return true;
        }
        if (HttpResourceValidator.isValidBasicParamType(typeSymbol, typeSymbols) || HttpResourceValidator.isValidNilableBasicParamType(typeSymbol, typeSymbols)) {
            return false;
        }
        return HttpCompilerPluginUtil.subtypeOf(typeSymbols, typeSymbol, "map<anydata>") || HttpCompilerPluginUtil.subtypeOf(typeSymbols, typeSymbol, "table<anydata>") || HttpCompilerPluginUtil.subtypeOf(typeSymbols, typeSymbol, "[anydata...]") || HttpCompilerPluginUtil.subtypeOf(typeSymbols, typeSymbol, "(map<anydata>|table<map<anydata>>|[anydata...])[]") || HttpCompilerPluginUtil.subtypeOf(typeSymbols, typeSymbol, "xml");
    }

    private static boolean checkErrorsAndReturn(SyntaxNodeAnalysisContext analysisContext, PayloadParamAvailability availability, ParameterSymbol pSymbol) {
        if (availability.isDefaultPayloadParam() && HttpPayloadParamIdentifier.isDistinctVariable(availability, pSymbol)) {
            HttpPayloadParamIdentifier.reportAmbiguousPayloadParam(analysisContext, pSymbol, availability);
            availability.setErrorOccurred(true);
            return false;
        }
        availability.setPayloadParamSymbol(pSymbol);
        return true;
    }

    private static boolean isDistinctVariable(PayloadParamAvailability availability, ParameterSymbol pSymbol) {
        return !((String)pSymbol.getName().get()).equals(availability.getPayloadParamSymbol().getName().get());
    }

    private static void reportAmbiguousPayloadParam(SyntaxNodeAnalysisContext analysisContext, ParameterSymbol parameterSymbol, PayloadParamAvailability paramAvailability) {
        if (paramAvailability.isEnableErrorDiagnostic()) {
            HttpCompilerPluginUtil.updateDiagnostic(analysisContext, (Location)parameterSymbol.getLocation().get(), HttpDiagnostic.HTTP_151, paramAvailability.getPayloadParamSymbol().getName().get(), parameterSymbol.getName().get());
        }
    }

    private static void reportInvalidUnionPayloadParam(SyntaxNodeAnalysisContext analysisContext, ParameterSymbol parameterSymbol, PayloadParamAvailability paramAvailability) {
        if (paramAvailability.isErrorOccurred()) {
            return;
        }
        if (!paramAvailability.isDefaultPayloadParam()) {
            if (paramAvailability.isEnableErrorDiagnostic()) {
                HttpCompilerPluginUtil.updateDiagnostic(analysisContext, (Location)parameterSymbol.getLocation().get(), HttpDiagnostic.HTTP_152, parameterSymbol.getName().get());
            }
            paramAvailability.setErrorOccurred(true);
        }
    }
}

