/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.http.compiler.oas;

import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.ObjectTypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.TypeDefinitionNode;
import io.ballerina.openapi.service.mapper.model.ServiceContractType;
import io.ballerina.openapi.service.mapper.model.ServiceNode;
import io.ballerina.projects.ProjectKind;
import io.ballerina.projects.plugins.SyntaxNodeAnalysisContext;
import io.ballerina.stdlib.http.compiler.HttpCompilerPluginUtil;
import io.ballerina.stdlib.http.compiler.oas.ServiceOasGenerator;
import java.util.Optional;

public class ServiceContractOasGenerator
extends ServiceOasGenerator {
    @Override
    public void perform(SyntaxNodeAnalysisContext context) {
        if (HttpCompilerPluginUtil.diagnosticContainsErrors(context) || !context.currentPackage().project().kind().equals((Object)ProjectKind.BUILD_PROJECT)) {
            return;
        }
        Node typeNode = context.node();
        if (!HttpCompilerPluginUtil.isHttpServiceType(context.semanticModel(), typeNode)) {
            return;
        }
        ObjectTypeDescriptorNode serviceObjectType = (ObjectTypeDescriptorNode)typeNode;
        TypeDefinitionNode serviceTypeNode = (TypeDefinitionNode)serviceObjectType.parent();
        if (!serviceTypeNode.visibilityQualifier().map(qualifier -> qualifier.text().equals("public")).orElse(false).booleanValue()) {
            return;
        }
        String fileName = String.format("%s.json", serviceTypeNode.typeName().text());
        ServiceContractType serviceNode = new ServiceContractType(serviceTypeNode);
        Optional<String> openApi = this.generateOpenApi(fileName, context.currentPackage().project(), context.semanticModel(), (ServiceNode)serviceNode);
        if (openApi.isEmpty()) {
            return;
        }
        ServiceContractOasGenerator.writeOpenApiAsTargetResource(context.currentPackage().project(), fileName, openApi.get());
    }
}

