/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.http.compiler.oas;

import io.ballerina.compiler.api.SemanticModel;
import io.ballerina.compiler.api.symbols.Symbol;
import io.ballerina.compiler.syntax.tree.AnnotationNode;
import io.ballerina.compiler.syntax.tree.MappingConstructorExpressionNode;
import io.ballerina.compiler.syntax.tree.MetadataNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeList;
import io.ballerina.compiler.syntax.tree.ServiceDeclarationNode;
import io.ballerina.compiler.syntax.tree.SpecificFieldNode;
import io.ballerina.openapi.service.mapper.ServiceToOpenAPIMapper;
import io.ballerina.openapi.service.mapper.model.OASGenerationMetaInfo;
import io.ballerina.openapi.service.mapper.model.OASResult;
import io.ballerina.openapi.service.mapper.model.ServiceDeclaration;
import io.ballerina.openapi.service.mapper.model.ServiceNode;
import io.ballerina.openapi.service.mapper.utils.MapperCommonUtils;
import io.ballerina.projects.Project;
import io.ballerina.projects.plugins.AnalysisTask;
import io.ballerina.projects.plugins.SyntaxNodeAnalysisContext;
import io.ballerina.stdlib.http.compiler.HttpCompilerPluginUtil;
import io.ballerina.tools.diagnostics.DiagnosticSeverity;
import io.swagger.v3.core.util.Json;
import io.swagger.v3.oas.models.OpenAPI;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.Optional;

public class ServiceOasGenerator
implements AnalysisTask<SyntaxNodeAnalysisContext> {
    public void perform(SyntaxNodeAnalysisContext context) {
        if (HttpCompilerPluginUtil.diagnosticContainsErrors(context)) {
            return;
        }
        ServiceDeclarationNode serviceDeclarationNode = HttpCompilerPluginUtil.getServiceDeclarationNode(context);
        if (serviceDeclarationNode == null) {
            return;
        }
        Optional<AnnotationNode> serviceInfoAnnotation = this.getServiceInfoAnnotation(serviceDeclarationNode);
        if (serviceInfoAnnotation.isEmpty()) {
            return;
        }
        boolean embedOpenAPI = this.retrieveValueFromAnnotation(serviceInfoAnnotation.get(), "embed").map(Boolean::parseBoolean).orElse(false);
        if (!embedOpenAPI) {
            return;
        }
        Optional<String> contractPath = this.retrieveValueFromAnnotation(serviceInfoAnnotation.get(), "contract");
        if (contractPath.isPresent()) {
            return;
        }
        Optional symbol = context.semanticModel().symbol((Node)serviceDeclarationNode);
        if (symbol.isEmpty()) {
            return;
        }
        String fileName = ServiceOasGenerator.getFileName(((Symbol)symbol.get()).hashCode());
        ServiceDeclaration serviceNode = new ServiceDeclaration(serviceDeclarationNode, context.semanticModel());
        Optional<String> openApi = this.generateOpenApi(fileName, context.currentPackage().project(), context.semanticModel(), (ServiceNode)serviceNode);
        if (openApi.isEmpty()) {
            return;
        }
        ServiceOasGenerator.writeOpenApiAsTargetResource(context.currentPackage().project(), fileName, openApi.get());
    }

    protected static String getFileName(int hashCode) {
        String hashString = Integer.toString(hashCode);
        return String.format("openapi_%s.json", hashString.startsWith("-") ? "0" + hashString.substring(1) : hashString);
    }

    protected static void writeOpenApiAsTargetResource(Project project, String fileName, String openApi) {
        Path resourcesPath = project.generatedResourcesDir();
        ServiceOasGenerator.writeFile(fileName, openApi, resourcesPath);
    }

    protected static void writeFile(String fileName, String content, Path dirPath) {
        Path openApiPath = dirPath.resolve(fileName);
        try (FileWriter writer = new FileWriter(openApiPath.toString(), StandardCharsets.UTF_8);){
            writer.write(content);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private Optional<AnnotationNode> getServiceInfoAnnotation(ServiceDeclarationNode serviceDeclarationNode) {
        Optional metadata = serviceDeclarationNode.metadata();
        if (metadata.isEmpty()) {
            return Optional.empty();
        }
        MetadataNode metaData = (MetadataNode)metadata.get();
        NodeList annotations = metaData.annotations();
        String serviceInfoAnnotation = String.format("%s:%s", "openapi", "ServiceInfo");
        return annotations.stream().filter(ann -> serviceInfoAnnotation.equals(ann.annotReference().toString().trim())).findFirst();
    }

    private Optional<String> retrieveValueFromAnnotation(AnnotationNode annotation, String fieldName) {
        return annotation.annotValue().map(MappingConstructorExpressionNode::fields).flatMap(fields -> fields.stream().filter(fld -> fld instanceof SpecificFieldNode).map(fld -> (SpecificFieldNode)fld).filter(fld -> fieldName.equals(fld.fieldName().toString().trim())).findFirst()).flatMap(SpecificFieldNode::valueExpr).map(en -> en.toString().trim());
    }

    protected Optional<String> generateOpenApi(String fileName, Project project, SemanticModel semanticModel, ServiceNode serviceNode) {
        OASGenerationMetaInfo.OASGenerationMetaInfoBuilder builder = new OASGenerationMetaInfo.OASGenerationMetaInfoBuilder();
        builder.setServiceNode(serviceNode).setSemanticModel(semanticModel).setOpenApiFileName(fileName).setBallerinaFilePath(null).setProject(project);
        OASResult oasResult = ServiceToOpenAPIMapper.generateOAS((OASGenerationMetaInfo)builder.build());
        Optional openApiOpt = oasResult.getOpenAPI();
        if (oasResult.getDiagnostics().stream().anyMatch(diagnostic -> diagnostic.getDiagnosticSeverity().equals((Object)DiagnosticSeverity.ERROR)) || openApiOpt.isEmpty()) {
            return Optional.empty();
        }
        OpenAPI openApi = (OpenAPI)openApiOpt.get();
        if (openApi.getInfo().getTitle() == null || openApi.getInfo().getTitle().equals("/")) {
            openApi.getInfo().setTitle(MapperCommonUtils.normalizeTitle((String)fileName));
        }
        return Optional.of(Json.pretty((Object)openApi));
    }
}

