/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.http.compiler.staticcodeanalyzer;

import io.ballerina.compiler.syntax.tree.ClassDefinitionNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeList;
import io.ballerina.compiler.syntax.tree.NodeLocation;
import io.ballerina.compiler.syntax.tree.ObjectTypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.ServiceDeclarationNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.projects.Document;
import io.ballerina.projects.plugins.AnalysisTask;
import io.ballerina.projects.plugins.SyntaxNodeAnalysisContext;
import io.ballerina.scan.Reporter;
import io.ballerina.stdlib.http.compiler.HttpCompilerPluginUtil;
import io.ballerina.stdlib.http.compiler.staticcodeanalyzer.HttpHttpServiceClass;
import io.ballerina.stdlib.http.compiler.staticcodeanalyzer.HttpHttpServiceDeclaration;
import io.ballerina.stdlib.http.compiler.staticcodeanalyzer.HttpHttpServiceObjectType;
import io.ballerina.stdlib.http.compiler.staticcodeanalyzer.HttpRule;
import io.ballerina.stdlib.http.compiler.staticcodeanalyzer.HttpService;
import io.ballerina.tools.diagnostics.Location;

class HttpServiceAnalyzer
implements AnalysisTask<SyntaxNodeAnalysisContext> {
    private final Reporter reporter;

    public HttpServiceAnalyzer(Reporter reporter) {
        this.reporter = reporter;
    }

    public void perform(SyntaxNodeAnalysisContext context) {
        HttpService service = this.getService(context);
        if (service == null) {
            return;
        }
        Document document = HttpCompilerPluginUtil.getDocument(context);
        this.validateServiceMembers(service.members(), document);
    }

    private HttpService getService(SyntaxNodeAnalysisContext context) {
        return switch (context.node().kind()) {
            case SyntaxKind.SERVICE_DECLARATION -> {
                ServiceDeclarationNode serviceDeclarationNode = HttpCompilerPluginUtil.getServiceDeclarationNode(context);
                if (serviceDeclarationNode == null) {
                    yield null;
                }
                yield new HttpHttpServiceDeclaration(serviceDeclarationNode);
            }
            case SyntaxKind.OBJECT_TYPE_DESC -> {
                if (HttpCompilerPluginUtil.isHttpServiceType(context.semanticModel(), context.node())) {
                    yield new HttpHttpServiceObjectType((ObjectTypeDescriptorNode)context.node());
                }
                yield null;
            }
            case SyntaxKind.CLASS_DEFINITION -> {
                ClassDefinitionNode serviceClassDefinitionNode = HttpCompilerPluginUtil.getServiceClassDefinitionNode(context);
                if (serviceClassDefinitionNode == null) {
                    yield null;
                }
                yield new HttpHttpServiceClass(serviceClassDefinitionNode);
            }
            default -> null;
        };
    }

    private void validateServiceMembers(NodeList<Node> members, Document document) {
        HttpCompilerPluginUtil.getResourceMethodWithDefaultAccessor(members).forEach(definition -> {
            NodeLocation accessorLocation = definition.functionName().location();
            this.reporter.reportIssue(document, (Location)accessorLocation, HttpRule.AVOID_DEFAULT_RESOURCE_ACCESSOR.getId());
        });
    }
}

