/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.openapi.cmd;

import io.ballerina.openapi.cmd.CmdConstants;
import java.util.List;

public class CmdOptions {
    private final String input;
    private final String outputModule;
    private final String id;
    private final String packagePath;
    private final List<String> tags;
    private final List<String> operations;
    private final CmdConstants.Mode mode;
    private final String clientMethod;
    private final boolean nullable;
    private final String licensePath;
    private boolean statusCodeBinding;
    private boolean mock;
    private boolean singleFile;

    private CmdOptions(CmdOptionsBuilder builder) {
        this.input = builder.input;
        this.outputModule = builder.outputModule;
        this.id = builder.id;
        this.packagePath = builder.packagePath;
        this.operations = builder.operations;
        this.tags = builder.tags;
        this.mode = builder.mode;
        this.clientMethod = builder.clientMethod;
        this.nullable = builder.nullable;
        this.licensePath = builder.licensePath;
        this.statusCodeBinding = builder.statusCodeBinding;
        this.mock = builder.mock;
        this.singleFile = builder.singleFile;
    }

    public String getInput() {
        return this.input;
    }

    public String getOutputModule() {
        return this.outputModule;
    }

    public String getId() {
        return this.id;
    }

    public String getPackagePath() {
        return this.packagePath;
    }

    public List<String> getTags() {
        return this.tags;
    }

    public List<String> getOperations() {
        return this.operations;
    }

    public boolean isNullable() {
        return this.nullable;
    }

    public CmdConstants.Mode getMode() {
        return this.mode;
    }

    public String getClientMethod() {
        return this.clientMethod;
    }

    public String getLicensePath() {
        return this.licensePath;
    }

    public boolean getStatusCodeBinding() {
        return this.statusCodeBinding;
    }

    public boolean getMock() {
        return this.mock;
    }

    public boolean getSingleFile() {
        return this.singleFile;
    }

    public static class CmdOptionsBuilder {
        private String outputModule;
        private String id;
        private String packagePath;
        private List<String> tags;
        private List<String> operations;
        private CmdConstants.Mode mode;
        private String clientMethod;
        private boolean nullable;
        private String input;
        private String licensePath;
        private boolean statusCodeBinding;
        private boolean mock;
        private boolean singleFile;

        public CmdOptionsBuilder withOutputModule(String outputModule) {
            this.outputModule = outputModule;
            return this;
        }

        public CmdOptionsBuilder withId(String id) {
            this.id = id;
            return this;
        }

        public CmdOptionsBuilder withPackagePath(String packagePath) {
            this.packagePath = packagePath;
            return this;
        }

        public CmdOptionsBuilder withTags(List<String> tags) {
            this.tags = tags;
            return this;
        }

        public CmdOptionsBuilder withOperations(List<String> operations) {
            this.operations = operations;
            return this;
        }

        public CmdOptionsBuilder withMode(CmdConstants.Mode mode) {
            this.mode = mode;
            return this;
        }

        public CmdOptionsBuilder withClientMethod(String clientMethod) {
            this.clientMethod = clientMethod;
            return this;
        }

        public CmdOptionsBuilder withNullable(boolean nullable) {
            this.nullable = nullable;
            return this;
        }

        public CmdOptionsBuilder withInput(String input) {
            this.input = input;
            return this;
        }

        public CmdOptionsBuilder withLicensePath(String licensePath) {
            this.licensePath = licensePath;
            return this;
        }

        public CmdOptionsBuilder withStatusCodeBinding(boolean statusCodeBinding) {
            this.statusCodeBinding = statusCodeBinding;
            return this;
        }

        public CmdOptionsBuilder withMock(boolean mock) {
            this.mock = mock;
            return this;
        }

        public CmdOptionsBuilder withSingleFile(boolean singleFile) {
            this.singleFile = singleFile;
            return this;
        }

        public CmdOptions build() {
            return new CmdOptions(this);
        }
    }
}

