/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.openapi.cmd;

import io.ballerina.cli.cmd.CommandUtil;
import io.ballerina.openapi.cmd.OpenAPIDiagnostic;
import io.ballerina.openapi.core.generators.common.ErrorMessages;
import io.ballerina.openapi.core.generators.common.GeneratorConstants;
import io.ballerina.openapi.core.generators.common.exception.BallerinaOpenApiException;
import io.ballerina.openapi.core.generators.common.model.GenSrcFile;
import io.ballerina.openapi.service.mapper.utils.MapperCommonUtils;
import io.ballerina.toml.syntax.tree.AbstractNodeFactory;
import io.ballerina.toml.syntax.tree.DocumentMemberDeclarationNode;
import io.ballerina.toml.syntax.tree.Node;
import io.ballerina.toml.syntax.tree.NodeList;
import io.ballerina.tools.diagnostics.DiagnosticInfo;
import io.ballerina.tools.diagnostics.DiagnosticSeverity;
import io.ballerina.tools.diagnostics.Location;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.parser.OpenAPIV3Parser;
import io.swagger.v3.parser.core.models.ParseOptions;
import io.swagger.v3.parser.core.models.SwaggerParseResult;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;

public class CmdUtils {
    public static OpenAPIDiagnostic constructOpenAPIDiagnostic(String code, String message, DiagnosticSeverity severity, Location location, Object ... args) {
        DiagnosticInfo diagnosticInfo = new DiagnosticInfo(code, message, severity);
        if (location == null) {
            location = new MapperCommonUtils.NullLocation();
        }
        return new OpenAPIDiagnostic(diagnosticInfo, location, Collections.emptyList(), args);
    }

    public static OpenAPI getOpenAPIFromOpenAPIV3Parser(Path definitionPath) throws IOException, BallerinaOpenApiException {
        Path contractPath = Paths.get(definitionPath.toString(), new String[0]);
        if (!Files.exists(contractPath, new LinkOption[0])) {
            throw new BallerinaOpenApiException(ErrorMessages.invalidFilePath((String)definitionPath.toString()));
        }
        if (!(definitionPath.toString().endsWith(".yaml") || definitionPath.toString().endsWith(".json") || definitionPath.toString().endsWith(".yml"))) {
            throw new BallerinaOpenApiException(ErrorMessages.invalidFileType());
        }
        String openAPIFileContent = Files.readString(definitionPath);
        ParseOptions parseOptions = new ParseOptions();
        parseOptions.setResolve(true);
        parseOptions.setFlatten(true);
        SwaggerParseResult parseResult = new OpenAPIV3Parser().readContents(openAPIFileContent, null, parseOptions);
        if (!parseResult.getMessages().isEmpty()) {
            StringBuilder errorMessage = new StringBuilder("OpenAPI definition has errors: \n");
            for (String message : parseResult.getMessages()) {
                errorMessage.append(message).append(GeneratorConstants.LINE_SEPARATOR);
            }
            throw new BallerinaOpenApiException(errorMessage.toString());
        }
        return parseResult.getOpenAPI();
    }

    public static void setGeneratedFileName(List<File> listFiles, GenSrcFile gFile, int duplicateCount) {
        for (File listFile : listFiles) {
            String listFileName = listFile.getName();
            if (!listFileName.contains(".") || listFileName.split("\\.").length < 2 || !listFileName.split("\\.")[0].equals(gFile.getFileName().split("\\.")[0])) continue;
            duplicateCount = 1 + duplicateCount;
        }
        gFile.setFileName(gFile.getFileName().split("\\.")[0] + "." + duplicateCount + "." + gFile.getFileName().split("\\.")[1]);
    }

    public static Optional<Path> validateBallerinaProject(Path projectPath, PrintStream outStream, String diagnostic, boolean exitOnException) {
        Optional<Path> ballerinaToml;
        try (Stream<Path> stream = Files.list(projectPath);){
            ballerinaToml = stream.filter(file -> !Files.isDirectory(file, new LinkOption[0])).map(Path::getFileName).filter(Objects::nonNull).filter(file -> "Ballerina.toml".equals(file.toString())).findFirst();
        }
        catch (IOException e) {
            outStream.printf(diagnostic, projectPath.toAbsolutePath());
            CommandUtil.exitError((boolean)exitOnException);
            return Optional.empty();
        }
        return ballerinaToml;
    }

    public static NodeList<DocumentMemberDeclarationNode> addNewLine(NodeList moduleMembers, int n) {
        for (int i = 0; i < n; ++i) {
            moduleMembers = moduleMembers.add((Node)AbstractNodeFactory.createIdentifierToken((String)System.lineSeparator()));
        }
        return moduleMembers;
    }

    public static <T extends Enum<?>> T searchEnum(Class<T> enumeration, String search) {
        for (Enum each : (Enum[])enumeration.getEnumConstants()) {
            if (each.name().compareToIgnoreCase(search) != 0) continue;
            return (T)each;
        }
        return null;
    }
}

