/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.openapi.cmd;

import io.ballerina.tools.diagnostics.Diagnostic;
import io.ballerina.tools.diagnostics.DiagnosticInfo;
import io.ballerina.tools.diagnostics.DiagnosticProperty;
import io.ballerina.tools.diagnostics.Location;
import io.ballerina.tools.text.LinePosition;
import io.ballerina.tools.text.LineRange;
import java.text.MessageFormat;
import java.util.List;

public class OpenAPIDiagnostic
extends Diagnostic {
    private final DiagnosticInfo diagnosticInfo;
    private final Location location;
    private final List<DiagnosticProperty<?>> properties;
    private String message = null;

    public OpenAPIDiagnostic(DiagnosticInfo diagnosticInfo, Location location, List<DiagnosticProperty<?>> properties, Object[] args) {
        this.diagnosticInfo = diagnosticInfo;
        this.location = location;
        this.properties = properties;
        try {
            this.message = MessageFormat.format(diagnosticInfo.messageFormat(), args);
        }
        catch (IllegalArgumentException e) {
            this.message = diagnosticInfo.messageFormat();
        }
    }

    public Location location() {
        return this.location;
    }

    public DiagnosticInfo diagnosticInfo() {
        return this.diagnosticInfo;
    }

    public String message() {
        return this.message;
    }

    public List<DiagnosticProperty<?>> properties() {
        return this.properties;
    }

    public String toString() {
        LineRange lineRange = OpenAPIDiagnostic.getOneBasedLineRange(this.location().lineRange());
        String var10000 = this.diagnosticInfo().severity().toString();
        return var10000 + " [" + lineRange.filePath() + ":" + String.valueOf(lineRange) + "] " + this.message();
    }

    static LineRange getOneBasedLineRange(LineRange lineRange) {
        return LineRange.from((String)lineRange.filePath(), (LinePosition)LinePosition.from((int)(lineRange.startLine().line() + 1), (int)(lineRange.startLine().offset() + 1)), (LinePosition)LinePosition.from((int)(lineRange.endLine().line() + 1), (int)(lineRange.endLine().offset() + 1)));
    }
}

