/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.modelgenerator.commons;

import io.ballerina.compiler.api.symbols.ClassSymbol;
import io.ballerina.compiler.api.symbols.ErrorTypeSymbol;
import io.ballerina.compiler.api.symbols.IntersectionTypeSymbol;
import io.ballerina.compiler.api.symbols.MethodSymbol;
import io.ballerina.compiler.api.symbols.ObjectTypeSymbol;
import io.ballerina.compiler.api.symbols.RecordFieldSymbol;
import io.ballerina.compiler.api.symbols.RecordTypeSymbol;
import io.ballerina.compiler.api.symbols.SymbolKind;
import io.ballerina.compiler.api.symbols.TupleTypeSymbol;
import io.ballerina.compiler.api.symbols.TypeDescKind;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import io.ballerina.compiler.api.symbols.UnionTypeSymbol;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.ballerinalang.langserver.common.utils.CommonUtil;
import org.ballerinalang.langserver.common.utils.RecordUtil;

public class DefaultValueGeneratorUtil {
    private DefaultValueGeneratorUtil() {
    }

    public static String getDefaultValueForType(TypeSymbol bType) {
        return DefaultValueGeneratorUtil.getDefaultValueForType(bType, new StringBuilder()).toString();
    }

    private static StringBuilder getDefaultValueForType(TypeSymbol bType, StringBuilder valueBuilder) {
        if (bType == null) {
            return valueBuilder;
        }
        TypeSymbol rawType = CommonUtil.getRawType((TypeSymbol)bType);
        TypeDescKind typeKind = rawType.typeKind();
        switch (typeKind) {
            case TYPE_REFERENCE: {
                return DefaultValueGeneratorUtil.getDefaultValueForType(CommonUtil.getRawType((TypeSymbol)bType), valueBuilder);
            }
            case FLOAT: {
                valueBuilder.append(0.0f);
                break;
            }
            case BOOLEAN: {
                valueBuilder.append("false");
                break;
            }
            case ANYDATA: 
            case MAP: {
                valueBuilder.append("{}");
                break;
            }
            case STREAM: {
                valueBuilder.append("new ()");
                break;
            }
            case XML: {
                valueBuilder.append("xml ``");
                break;
            }
            case DECIMAL: {
                valueBuilder.append("0.0d");
                break;
            }
            case REGEXP: {
                valueBuilder.append("re ` `");
                break;
            }
            case TABLE: {
                valueBuilder.append("table []");
                break;
            }
            case JSON: 
            case NIL: 
            case ANY: {
                valueBuilder.append("()");
                break;
            }
            case SINGLETON: {
                valueBuilder.append(rawType.signature());
                break;
            }
            case RECORD: {
                RecordTypeSymbol recordTypeSymbol = (RecordTypeSymbol)rawType;
                valueBuilder.append("{");
                List<RecordFieldSymbol> mandatoryFieldSymbols = RecordUtil.getMandatoryRecordFields((RecordTypeSymbol)recordTypeSymbol).stream().filter(recordFieldSymbol -> recordFieldSymbol.getName().isPresent()).toList();
                ArrayList<CallSite> fieldValueList = new ArrayList<CallSite>();
                for (RecordFieldSymbol mandatoryField : mandatoryFieldSymbols) {
                    String fieldName = CommonUtil.escapeReservedKeyword((String)((String)mandatoryField.getName().get()));
                    String value = DefaultValueGeneratorUtil.getDefaultValueForType(mandatoryField.typeDescriptor());
                    fieldValueList.add((CallSite)((Object)(fieldName + ": " + value)));
                }
                valueBuilder.append(String.join((CharSequence)", ", fieldValueList));
                valueBuilder.append("}");
                break;
            }
            case ARRAY: {
                valueBuilder.append("[]");
                break;
            }
            case TUPLE: {
                TupleTypeSymbol tupleType = (TupleTypeSymbol)rawType;
                List<String> memberDefaultValues = tupleType.memberTypeDescriptors().stream().map(member -> DefaultValueGeneratorUtil.getDefaultValueForType(member, new StringBuilder()).toString()).toList();
                if (memberDefaultValues.isEmpty()) {
                    valueBuilder.append("[]");
                    break;
                }
                valueBuilder.append("[");
                valueBuilder.append(String.join((CharSequence)", ", memberDefaultValues));
                valueBuilder.append("]");
                break;
            }
            case ERROR: {
                List mandatoryFields;
                TypeSymbol errorType = CommonUtil.getRawType((TypeSymbol)((ErrorTypeSymbol)rawType).detailTypeDescriptor());
                StringBuilder errorString = new StringBuilder("error(\"\"");
                if (errorType.typeKind() == TypeDescKind.RECORD && !(mandatoryFields = RecordUtil.getMandatoryRecordFields((RecordTypeSymbol)((RecordTypeSymbol)errorType))).isEmpty()) {
                    errorString.append(", ");
                    ArrayList<CallSite> detailFieldSnippets = new ArrayList<CallSite>();
                    for (RecordFieldSymbol field : mandatoryFields) {
                        String defValue = DefaultValueGeneratorUtil.getDefaultValueForType(field.typeDescriptor());
                        String key = (String)field.getName().get();
                        detailFieldSnippets.add((CallSite)((Object)(key + ": " + defValue)));
                    }
                    errorString.append(String.join((CharSequence)", ", detailFieldSnippets));
                }
                errorString.append(")");
                valueBuilder.append((CharSequence)errorString);
                break;
            }
            case OBJECT: {
                ObjectTypeSymbol objectTypeSymbol = (ObjectTypeSymbol)rawType;
                if (objectTypeSymbol.kind() == SymbolKind.CLASS) {
                    ClassSymbol classSymbol = (ClassSymbol)objectTypeSymbol;
                    if (classSymbol.initMethod().isPresent()) {
                        ArrayList values = new ArrayList();
                        ((MethodSymbol)classSymbol.initMethod().get()).typeDescriptor().params().ifPresent(params -> params.forEach(param -> values.add(DefaultValueGeneratorUtil.getDefaultValueForType(param.typeDescriptor()))));
                        valueBuilder.append("new (").append(String.join((CharSequence)", ", values)).append(")");
                        break;
                    }
                    valueBuilder.append("new ()");
                    break;
                }
                valueBuilder.append("object {}");
                break;
            }
            case UNION: {
                ArrayList members = new ArrayList(((UnionTypeSymbol)rawType).memberTypeDescriptors());
                boolean hasNilType = members.stream().anyMatch(mem -> CommonUtil.getRawType((TypeSymbol)mem).typeKind() == TypeDescKind.NIL);
                if (!hasNilType && !members.isEmpty()) {
                    valueBuilder.append(DefaultValueGeneratorUtil.getDefaultValueForType((TypeSymbol)members.get(0)));
                    break;
                }
                valueBuilder.append("()");
                break;
            }
            case INTERSECTION: {
                TypeSymbol effectiveType = ((IntersectionTypeSymbol)rawType).effectiveTypeDescriptor();
                effectiveType = CommonUtil.getRawType((TypeSymbol)effectiveType);
                if (effectiveType.typeKind() == TypeDescKind.INTERSECTION) {
                    Optional<TypeSymbol> memberType = ((IntersectionTypeSymbol)effectiveType).memberTypeDescriptors().stream().filter(typeSymbol -> typeSymbol.typeKind() != TypeDescKind.READONLY).findAny();
                    if (memberType.isPresent()) {
                        valueBuilder.append(DefaultValueGeneratorUtil.getDefaultValueForType(memberType.get()));
                        break;
                    }
                    valueBuilder.append("()");
                    break;
                }
                valueBuilder.append(DefaultValueGeneratorUtil.getDefaultValueForType(effectiveType));
                break;
            }
            default: {
                if (typeKind.isIntegerType()) {
                    valueBuilder.append("0");
                    break;
                }
                if (!typeKind.isStringType()) break;
                valueBuilder.append("\"\"");
            }
        }
        return valueBuilder;
    }
}

