/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.testmanagerservice.extension;

import io.ballerina.compiler.syntax.tree.AnnotationNode;
import io.ballerina.compiler.syntax.tree.BasicLiteralNode;
import io.ballerina.compiler.syntax.tree.FunctionDefinitionNode;
import io.ballerina.compiler.syntax.tree.ListConstructorExpressionNode;
import io.ballerina.compiler.syntax.tree.MappingConstructorExpressionNode;
import io.ballerina.compiler.syntax.tree.MappingFieldNode;
import io.ballerina.compiler.syntax.tree.MetadataNode;
import io.ballerina.compiler.syntax.tree.ModuleMemberDeclarationNode;
import io.ballerina.compiler.syntax.tree.ModulePartNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeList;
import io.ballerina.compiler.syntax.tree.SeparatedNodeList;
import io.ballerina.compiler.syntax.tree.SpecificFieldNode;
import io.ballerina.projects.Document;
import io.ballerina.testmanagerservice.extension.ModuleTestDetailsHolder;
import io.ballerina.testmanagerservice.extension.model.FunctionTreeNode;
import io.ballerina.tools.text.LineRange;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

public class TestFunctionsFinder {
    private static final String TEST_CONFIG_ANNOTATION = "test:Config";
    private static final String FIELD_GROUPS = "groups";
    private static final String GROUP_NOT_SPECIFIED = "DEFAULT_GROUP";
    private final Document document;
    private final ModuleTestDetailsHolder moduleTestDetailsHolder;

    public TestFunctionsFinder(Document document, ModuleTestDetailsHolder moduleTestDetailsHolder) {
        this.document = document;
        this.moduleTestDetailsHolder = moduleTestDetailsHolder;
    }

    public void find() {
        ModulePartNode modulePartNode = (ModulePartNode)this.document.syntaxTree().rootNode();
        NodeList members = modulePartNode.members();
        for (ModuleMemberDeclarationNode member : members) {
            FunctionDefinitionNode functionDefinitionNode;
            Optional metadata;
            if (!(member instanceof FunctionDefinitionNode) || (metadata = (functionDefinitionNode = (FunctionDefinitionNode)member).metadata()).isEmpty()) continue;
            NodeList annotations = ((MetadataNode)metadata.get()).annotations();
            for (AnnotationNode annotation : annotations) {
                if (!annotation.annotReference().toSourceCode().trim().equals(TEST_CONFIG_ANNOTATION)) continue;
                List<String> groups = this.findSpecifiedGroups(annotation);
                String functionName = functionDefinitionNode.functionName().text().trim();
                LineRange lineRange = functionDefinitionNode.lineRange();
                FunctionTreeNode functionTreeNode = new FunctionTreeNode(functionName, lineRange, "Config", groups);
                this.moduleTestDetailsHolder.addTestFunctions(groups, functionTreeNode);
            }
        }
    }

    private List<String> findSpecifiedGroups(AnnotationNode annotationNode) {
        if (annotationNode.annotValue().isEmpty()) {
            return List.of(GROUP_NOT_SPECIFIED);
        }
        MappingConstructorExpressionNode annotValue = (MappingConstructorExpressionNode)annotationNode.annotValue().get();
        SeparatedNodeList fields = annotValue.fields();
        ArrayList<String> groups = new ArrayList<String>();
        for (MappingFieldNode field : fields) {
            ListConstructorExpressionNode listConstructorExpressionNode;
            SeparatedNodeList expressions;
            Object t;
            SpecificFieldNode specificFieldNode;
            String fieldName;
            if (!(field instanceof SpecificFieldNode) || !(fieldName = (specificFieldNode = (SpecificFieldNode)field).fieldName().toSourceCode().trim()).equals(FIELD_GROUPS) || specificFieldNode.valueExpr().isEmpty() || !((t = specificFieldNode.valueExpr().get()) instanceof ListConstructorExpressionNode) || (expressions = (listConstructorExpressionNode = (ListConstructorExpressionNode)t).expressions()).isEmpty()) continue;
            for (Node expression : expressions) {
                if (!(expression instanceof BasicLiteralNode)) continue;
                BasicLiteralNode basicLiteralNode = (BasicLiteralNode)expression;
                groups.add(basicLiteralNode.toSourceCode().trim());
            }
        }
        if (groups.isEmpty()) {
            groups.add(GROUP_NOT_SPECIFIED);
        }
        return Collections.unmodifiableList(groups);
    }
}

