/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.testmanagerservice.extension.model;

import io.ballerina.testmanagerservice.extension.model.Property;

public record FunctionParameter(Property type, Property variable, Property defaultValue, boolean optional, boolean editable, boolean advanced) {

    public static class FunctionParameterBuilder {
        private Property type;
        private Property variable;
        private Property defaultValue;
        private boolean optional = false;
        private boolean editable = true;
        private boolean advanced = false;

        public FunctionParameterBuilder type(String type) {
            this.type = new Property.PropertyBuilder().valueType("TYPE").editable(true).value(type).build();
            return this;
        }

        public FunctionParameterBuilder variable(String variable) {
            this.variable = new Property.PropertyBuilder().valueType("IDENTIFIER").editable(true).value(variable).build();
            return this;
        }

        public FunctionParameterBuilder defaultValue(Object defaultValue) {
            this.defaultValue = new Property.PropertyBuilder().valueType("EXPRESSION").editable(true).value(defaultValue).build();
            return this;
        }

        public FunctionParameterBuilder optional(boolean optional) {
            this.optional = optional;
            return this;
        }

        public FunctionParameterBuilder editable(boolean editable) {
            this.editable = editable;
            return this;
        }

        public FunctionParameterBuilder advanced(boolean advanced) {
            this.advanced = advanced;
            return this;
        }

        public FunctionParameter build() {
            return new FunctionParameter(this.type, this.variable, this.defaultValue, this.optional, this.editable, this.advanced);
        }
    }
}

