/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.testmanagerservice.extension.model;

import io.ballerina.compiler.syntax.tree.DefaultableParameterNode;
import io.ballerina.compiler.syntax.tree.ParameterNode;
import io.ballerina.compiler.syntax.tree.RequiredParameterNode;
import io.ballerina.compiler.syntax.tree.ReturnTypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.SeparatedNodeList;
import io.ballerina.compiler.syntax.tree.Token;
import io.ballerina.testmanagerservice.extension.model.Annotation;
import io.ballerina.testmanagerservice.extension.model.Codedata;
import io.ballerina.testmanagerservice.extension.model.FunctionParameter;
import io.ballerina.testmanagerservice.extension.model.Metadata;
import io.ballerina.testmanagerservice.extension.model.Property;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public record TestFunction(Metadata metadata, Codedata codedata, Property functionName, Property returnType, List<FunctionParameter> parameters, List<Annotation> annotations, boolean editable) {
    public static List<FunctionParameter> parameters(SeparatedNodeList<ParameterNode> parameters) {
        ArrayList<FunctionParameter> functionParameters = new ArrayList<FunctionParameter>();
        for (ParameterNode parameter : parameters) {
            DefaultableParameterNode defaultableParameterNode;
            String paramType;
            String paramName;
            if (parameter instanceof RequiredParameterNode) {
                RequiredParameterNode requiredParameterNode = (RequiredParameterNode)parameter;
                if (requiredParameterNode.paramName().isEmpty()) continue;
                paramName = ((Token)requiredParameterNode.paramName().get()).text().trim();
                paramType = requiredParameterNode.typeName().toSourceCode().trim();
                FunctionParameter.FunctionParameterBuilder builder = new FunctionParameter.FunctionParameterBuilder();
                builder.type(paramType);
                builder.variable(paramName);
                functionParameters.add(builder.build());
                continue;
            }
            if (!(parameter instanceof DefaultableParameterNode) || (defaultableParameterNode = (DefaultableParameterNode)parameter).paramName().isEmpty()) continue;
            paramName = ((Token)defaultableParameterNode.paramName().get()).text().trim();
            paramType = defaultableParameterNode.typeName().toSourceCode().trim();
            String defaultValue = defaultableParameterNode.expression().toSourceCode().trim();
            FunctionParameter.FunctionParameterBuilder builder = new FunctionParameter.FunctionParameterBuilder();
            builder.type(paramType);
            builder.variable(paramName);
            builder.defaultValue(defaultValue);
            functionParameters.add(builder.build());
        }
        return functionParameters;
    }

    public static Property returnType(Optional<ReturnTypeDescriptorNode> returnTypeDescriptorNode) {
        Property.PropertyBuilder builder = new Property.PropertyBuilder();
        builder.metadata(new Metadata("Return Type", "Return type of the function"));
        builder.valueType("TYPE");
        builder.optional(true);
        builder.advanced(true);
        builder.editable(true);
        returnTypeDescriptorNode.ifPresent(typeDescriptorNode -> builder.value(typeDescriptorNode.type().toSourceCode().trim()));
        return builder.build();
    }

    public static Property functionName(String functionName) {
        Property.PropertyBuilder builder = new Property.PropertyBuilder();
        builder.metadata(new Metadata("Test Function", "Test function"));
        builder.valueType("IDENTIFIER");
        builder.value(functionName);
        builder.advanced(false);
        builder.editable(true);
        return builder.build();
    }

    public static class FunctionBuilder {
        private Metadata metadata;
        private Codedata codedata;
        private Property functionName;
        private Property returnType;
        private List<FunctionParameter> parameters;
        private List<Annotation> annotations;
        private boolean editable;

        public FunctionBuilder metadata(Metadata metadata) {
            this.metadata = metadata;
            return this;
        }

        public FunctionBuilder codedata(Codedata codedata) {
            this.codedata = codedata;
            return this;
        }

        public FunctionBuilder functionName(Property functionName) {
            this.functionName = functionName;
            return this;
        }

        public FunctionBuilder returnType(Property returnType) {
            this.returnType = returnType;
            return this;
        }

        public FunctionBuilder parameters(List<FunctionParameter> parameters) {
            this.parameters = parameters;
            return this;
        }

        public FunctionBuilder annotations(List<Annotation> annotations) {
            this.annotations = annotations;
            return this;
        }

        public FunctionBuilder editable(boolean editable) {
            this.editable = editable;
            return this;
        }

        public TestFunction build() {
            return new TestFunction(this.metadata, this.codedata, this.functionName, this.returnType, this.parameters, this.annotations, this.editable);
        }
    }
}

