/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.constraint.validators;

import io.ballerina.runtime.api.values.BDecimal;
import io.ballerina.runtime.api.values.BMap;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.stdlib.constraint.ConstraintErrorInfo;
import io.ballerina.stdlib.constraint.validators.interfaces.DigitsValidator;
import io.ballerina.stdlib.constraint.validators.interfaces.ValueValidator;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class NumberConstraintValidator
implements ValueValidator,
DigitsValidator {
    private final List<ConstraintErrorInfo> failedConstraintsInfo;
    private DigitsValidator.DigitParts digitParts;

    public NumberConstraintValidator(List<ConstraintErrorInfo> failedConstraintsInfo) {
        this.failedConstraintsInfo = failedConstraintsInfo;
    }

    public void validate(BMap<BString, Object> constraints, Number fieldValue, String path, boolean isMemberValue) {
        for (Map.Entry constraint : constraints.entrySet()) {
            DigitsValidator.super.checkDigitsConstraintValue(constraint, path);
            this.validate(constraint, fieldValue, isMemberValue, this.failedConstraintsInfo, path);
        }
    }

    @Override
    public void validate(Map.Entry<BString, Object> constraint, Object fieldValue, boolean isMemberValue, List<ConstraintErrorInfo> failedConstraintsInfo, String path) {
        DigitsValidator.super.validate(constraint, fieldValue, isMemberValue, failedConstraintsInfo, path);
        ValueValidator.super.validate(constraint, fieldValue, isMemberValue, failedConstraintsInfo, path);
    }

    @Override
    public boolean validateMinValue(Object fieldValue, Object constraintValue) {
        return ((Number)fieldValue).doubleValue() >= ((BDecimal)constraintValue).value().doubleValue();
    }

    @Override
    public boolean validateMaxValue(Object fieldValue, Object constraintValue) {
        return ((Number)fieldValue).doubleValue() <= ((BDecimal)constraintValue).value().doubleValue();
    }

    @Override
    public boolean validateMinValueExclusive(Object fieldValue, Object constraintValue) {
        return ((Number)fieldValue).doubleValue() > ((BDecimal)constraintValue).value().doubleValue();
    }

    @Override
    public boolean validateMaxValueExclusive(Object fieldValue, Object constraintValue) {
        return ((Number)fieldValue).doubleValue() < ((BDecimal)constraintValue).value().doubleValue();
    }

    @Override
    public boolean validateMaxDigits(Object fieldValue, Object constraintValue) {
        return true;
    }

    @Override
    public boolean validateMaxIntegerDigits(Object fieldValue, Object constraintValue) {
        double fieldNumericValue = ((Number)fieldValue).doubleValue();
        if (Objects.isNull(this.digitParts)) {
            this.digitParts = this.getDigitPartsFromDouble(fieldNumericValue);
        }
        return (long)this.digitParts.integerDigits() <= (Long)constraintValue;
    }

    @Override
    public boolean validateMaxFractionDigits(Object fieldValue, Object constraintValue) {
        double fieldNumericValue = ((Number)fieldValue).doubleValue();
        if (Objects.isNull(this.digitParts)) {
            this.digitParts = this.getDigitPartsFromDouble(fieldNumericValue);
        }
        return (long)this.digitParts.fractionDigits() <= (Long)constraintValue;
    }
}

