/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.time.util;

import io.ballerina.runtime.api.values.BArray;
import io.ballerina.runtime.api.values.BDecimal;
import io.ballerina.runtime.api.values.BMap;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.stdlib.time.nativeimpl.Civil;
import io.ballerina.stdlib.time.nativeimpl.Utc;
import io.ballerina.stdlib.time.util.Constants;
import io.ballerina.stdlib.time.util.Utils;
import java.time.ZonedDateTime;
import java.util.Date;
import java.util.Map;

public class TimeValueHandler {
    private TimeValueHandler() {
    }

    public static BMap<BString, Object> createCivilFromZoneDateTime(ZonedDateTime zonedDateTime) {
        return new Civil(zonedDateTime).build();
    }

    public static BMap<BString, Object> createCivilFromZoneDateTimeString(String zonedDateTimeString) {
        return new Civil(zonedDateTimeString, Constants.CivilInputStringTypes.RFC3339_STRING).buildWithZone();
    }

    public static BMap<BString, Object> createCivilFromEmailString(String zonedDateTimeString) {
        return new Civil(zonedDateTimeString, Constants.CivilInputStringTypes.EMAIL_STRING).buildWithZone();
    }

    public static ZonedDateTime createZoneDateTimeFromCivilValues(long year, long month, long day, long hour, long minute, BDecimal second, long zoneHour, long zoneMinute, BDecimal zoneSecond, BString zoneAbbr, String zoneHandling) {
        return Utils.createZoneDateTimeFromCivilValues(year, month, day, hour, minute, second, zoneHour, zoneMinute, zoneSecond, zoneAbbr, zoneHandling);
    }

    public static Map<String, Integer> zoneOffsetMapFromString(String dateTime) {
        return Utils.zoneOffsetMapFromString(dateTime);
    }

    public static BArray createUtcFromDate(Date date) {
        return new Utc(date).build();
    }

    public static BArray createUtcFromMilliSeconds(long millis) {
        return new Utc(millis).build();
    }

    public static ZonedDateTime createZonedDateTimeFromUtc(BArray utc) {
        return new Utc(utc).generateZonedDateAtZ();
    }
}

