/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.shell.cli.handlers;

import io.ballerina.shell.cli.BallerinaShell;
import io.ballerina.shell.cli.PropertiesLoader;
import io.ballerina.shell.cli.handlers.AbstractCommand;
import io.ballerina.shell.cli.handlers.help.BbeHelpProvider;
import io.ballerina.shell.cli.handlers.help.BbeTopicsProvider;
import io.ballerina.shell.cli.handlers.help.HelpProviderException;
import io.ballerina.shell.cli.utils.FileUtils;
import java.util.Arrays;
import java.util.List;

public class HelpCommand
extends AbstractCommand {
    private static final String URL = "https://ballerina.io/learn/by-example/";
    private static final String TAGS = "<br/>";
    private static final String TOPICS = "topics";
    private static final String EMPTY_STRING = "";
    private static final String NEW_LINE = "\n";
    private static final String DESCRIPTION_PREFIX = "\nTopic description :";
    private static final String URL_PREFIX = "\nFor examples, visit ";
    private final BbeHelpProvider bbeHelpProvider = new BbeHelpProvider();
    private final StringBuilder topics = new StringBuilder();

    public HelpCommand(BallerinaShell ballerinaShell) {
        super(ballerinaShell);
    }

    @Override
    public void run(String ... args) {
        if (args.length == 0) {
            String helpFile = PropertiesLoader.getProperty("resource.help.file");
            String helpContent = FileUtils.readResource(helpFile);
            this.ballerinaShell.outputInfo(helpContent);
        } else {
            String topic = String.join((CharSequence)" ", Arrays.copyOfRange(args, 0, args.length)).trim();
            if (topic.equals(TOPICS)) {
                BbeTopicsProvider bbeTopicsProvider = BbeTopicsProvider.getBbeTopicsProvider();
                List<String> topicsKeywords = bbeTopicsProvider.getTopicList();
                this.topics.append("\nFollowing are all available topics.\n\n");
                for (String keyword : topicsKeywords) {
                    this.topics.append(keyword).append(NEW_LINE);
                }
                this.ballerinaShell.outputInfo(this.topics.toString());
            } else {
                try {
                    this.ballerinaShell.outputInfo(NEW_LINE + this.bbeHelpProvider.getDescription(topic).replace(TAGS, EMPTY_STRING));
                    this.ballerinaShell.outputInfo("\nFor examples, visit https://ballerina.io/learn/by-example/" + topic.replace(" ", "-"));
                }
                catch (HelpProviderException e) {
                    this.ballerinaShell.outputError("\nCan not find the topic : " + topic + "\n\nPlease provide a valid topic value. Use \"/help topics\" command to see all available topics.");
                }
            }
        }
    }
}

