/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.shell.cli.handlers.help;

import com.google.gson.Gson;
import io.ballerina.shell.DiagnosticReporter;
import io.ballerina.shell.cli.handlers.help.BbeRecord;
import io.ballerina.shell.cli.handlers.help.BbeTitle;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Stream;

public class BbeTopicsProvider
extends DiagnosticReporter {
    private static final String BALLERINA_HOME = System.getProperty("ballerina.home");
    private static final String EXAMPLES = "examples";
    private static final String BBE_FILE = "index.json";
    private static final String TOPICS = "topics";
    private final List<String> topicList = new ArrayList<String>();
    private static BbeTopicsProvider bbeTopicsProvider = null;

    private BbeTopicsProvider() {
        this.populateTopicList();
    }

    private void populateTopicList() {
        Gson gson = new Gson();
        String file = BALLERINA_HOME + File.separator + EXAMPLES + File.separator + BBE_FILE;
        String jsonString = this.readFileAsString(file);
        if (jsonString != null) {
            this.topicList.add(TOPICS);
            jsonString = jsonString.trim();
            BbeTitle[] bbeTitles = (BbeTitle[])gson.fromJson(jsonString, BbeTitle[].class);
            Stream<BbeTitle> streamList = Arrays.stream(bbeTitles);
            streamList.forEach(bbeTitle -> {
                if (bbeTitle != null) {
                    BbeRecord[] samples = bbeTitle.getSamples();
                    Stream<BbeRecord> sampleList = Arrays.stream(samples);
                    sampleList.forEach(bbeRecordElement -> {
                        if (bbeRecordElement != null) {
                            this.topicList.add(bbeRecordElement.getUrl().replace("-", " "));
                        }
                    });
                }
            });
        }
    }

    public static synchronized BbeTopicsProvider getBbeTopicsProvider() {
        if (bbeTopicsProvider == null) {
            bbeTopicsProvider = new BbeTopicsProvider();
        }
        return bbeTopicsProvider;
    }

    public List<String> getTopicList() {
        return this.topicList;
    }

    private String readFileAsString(String file) {
        String content = null;
        try {
            content = Files.readString(Path.of(file, new String[0]));
        }
        catch (IOException e) {
            this.addDebugDiagnostic("Error loading the file : " + e.getMessage());
        }
        return content;
    }
}

