/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.shell.cli.jline;

import io.ballerina.shell.cli.PropertiesLoader;
import io.ballerina.shell.cli.handlers.help.BbeTopicsProvider;
import io.ballerina.shell.cli.utils.FileUtils;
import java.util.List;
import org.jline.builtins.Completers;
import org.jline.reader.Candidate;
import org.jline.reader.Completer;
import org.jline.reader.LineReader;
import org.jline.reader.ParsedLine;
import org.jline.reader.impl.completer.StringsCompleter;

public class JlineSimpleCompleter
implements Completer {
    private final StringsCompleter topicsOptionCompleter;
    private final StringsCompleter commandsCompleter;
    private final StringsCompleter keywordsCompleter;
    private final Completers.FileNameCompleter fileNameCompleter;
    private final StringsCompleter topicsCompleter;

    public JlineSimpleCompleter() {
        BbeTopicsProvider bbeTopicsProvider = BbeTopicsProvider.getBbeTopicsProvider();
        List<String> topicsKeywords = bbeTopicsProvider.getTopicList();
        this.topicsCompleter = new StringsCompleter(topicsKeywords);
        List<String> commandsKeywords = FileUtils.readKeywords(PropertiesLoader.getProperty("resource.commands.file"));
        List<String> codeKeywords = FileUtils.readKeywords(PropertiesLoader.getProperty("resource.keywords.file"));
        this.commandsCompleter = new StringsCompleter(commandsKeywords);
        this.keywordsCompleter = new StringsCompleter(codeKeywords);
        String helpDescriptionPostfix = PropertiesLoader.getProperty("commands.help.ps.description");
        String helpExamplePostfix = PropertiesLoader.getProperty("commands.help.ps.example");
        this.topicsOptionCompleter = new StringsCompleter(new String[]{helpDescriptionPostfix, helpExamplePostfix});
        this.fileNameCompleter = new Completers.FileNameCompleter();
    }

    public void complete(LineReader reader, ParsedLine line, List<Candidate> candidates) {
        if (this.hasPropertyPrefix(line, "commands.help")) {
            if (line.wordIndex() == 1) {
                this.topicsCompleter.complete(reader, line, candidates);
            } else {
                this.topicsOptionCompleter.complete(reader, line, candidates);
            }
        } else if (this.hasPropertyPrefix(line, "commands.file")) {
            this.fileNameCompleter.complete(reader, line, candidates);
        } else if (this.hasPropertyPrefix(line, "commands.prefix")) {
            this.commandsCompleter.complete(reader, line, candidates);
        } else {
            this.keywordsCompleter.complete(reader, line, candidates);
        }
    }

    private boolean hasPropertyPrefix(ParsedLine line, String propertyName) {
        return line.line().trim().startsWith(PropertiesLoader.getProperty(propertyName));
    }
}

