/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.shell.cli.jline;

import io.ballerina.shell.cli.ShellExitException;
import io.ballerina.shell.cli.TerminalAdapter;
import java.io.PrintWriter;
import org.jline.reader.EndOfFileException;
import org.jline.reader.LineReader;
import org.jline.reader.UserInterruptException;
import org.jline.utils.AttributedStringBuilder;
import org.jline.utils.AttributedStyle;

public class JlineTerminalAdapter
extends TerminalAdapter {
    protected final LineReader lineReader;

    public JlineTerminalAdapter(LineReader lineReader) {
        this.lineReader = lineReader;
    }

    @Override
    protected String color(String text, int color) {
        return new AttributedStringBuilder().style(AttributedStyle.DEFAULT.foreground(color)).append((CharSequence)text).toAnsi();
    }

    @Override
    public String readLine(String prefix, String postfix) throws ShellExitException {
        try {
            return this.lineReader.readLine(prefix, postfix, (Character)null, null);
        }
        catch (UserInterruptException e) {
            return "";
        }
        catch (EndOfFileException e) {
            throw new ShellExitException();
        }
    }

    @Override
    public void println(String text) {
        PrintWriter writer = this.lineReader.getTerminal().writer();
        writer.println(text);
        writer.flush();
    }

    @Override
    public String readOneLine(String prompt) {
        return this.lineReader.readLine(prompt);
    }
}

