/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.udp.compiler;

import io.ballerina.compiler.api.symbols.ModuleSymbol;
import io.ballerina.compiler.api.symbols.ServiceDeclarationSymbol;
import io.ballerina.compiler.api.symbols.TypeDescKind;
import io.ballerina.compiler.api.symbols.TypeReferenceTypeSymbol;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import io.ballerina.compiler.api.symbols.UnionTypeSymbol;
import io.ballerina.compiler.syntax.tree.IdentifierToken;
import io.ballerina.compiler.syntax.tree.ImportDeclarationNode;
import io.ballerina.compiler.syntax.tree.ImportPrefixNode;
import io.ballerina.compiler.syntax.tree.ModulePartNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.ServiceDeclarationNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.projects.plugins.AnalysisTask;
import io.ballerina.projects.plugins.SyntaxNodeAnalysisContext;
import io.ballerina.stdlib.udp.compiler.UdpServiceValidator;
import io.ballerina.stdlib.udp.compiler.Utils;
import io.ballerina.tools.diagnostics.Diagnostic;
import io.ballerina.tools.diagnostics.DiagnosticSeverity;
import java.util.List;
import java.util.Optional;

public class UdpServiceValidatorTask
implements AnalysisTask<SyntaxNodeAnalysisContext> {
    private static final String ORG_NAME = "ballerina";

    public void perform(SyntaxNodeAnalysisContext ctx) {
        List diagnostics = ctx.semanticModel().diagnostics();
        for (Diagnostic diagnostic : diagnostics) {
            if (diagnostic.diagnosticInfo().severity() != DiagnosticSeverity.ERROR) continue;
            return;
        }
        ServiceDeclarationNode serviceDeclarationNode = (ServiceDeclarationNode)ctx.node();
        String modulePrefix = this.getPrefix(ctx);
        Optional serviceDeclarationSymbol = ctx.semanticModel().symbol((Node)serviceDeclarationNode);
        if (serviceDeclarationSymbol.isPresent()) {
            List listenerTypes = ((ServiceDeclarationSymbol)serviceDeclarationSymbol.get()).listenerTypes();
            for (TypeSymbol listenerType : listenerTypes) {
                if (!this.isListenerBelongsToUdpModule(listenerType)) continue;
                UdpServiceValidator udpServiceValidator = new UdpServiceValidator(ctx, modulePrefix + SyntaxKind.COLON_TOKEN.stringValue());
                udpServiceValidator.validate();
                return;
            }
        }
    }

    private String getPrefix(SyntaxNodeAnalysisContext ctx) {
        ModulePartNode modulePartNode = (ModulePartNode)ctx.syntaxTree().rootNode();
        for (ImportDeclarationNode importDeclaration : modulePartNode.imports()) {
            if (!Utils.equals(((IdentifierToken)importDeclaration.moduleName().get(0)).toString().stripTrailing(), "udp")) continue;
            if (!importDeclaration.prefix().isPresent()) break;
            return ((ImportPrefixNode)importDeclaration.prefix().get()).children().get(1).toString();
        }
        return "udp";
    }

    private boolean isUdpModule(ModuleSymbol moduleSymbol) {
        return Utils.equals((String)moduleSymbol.getName().get(), "udp") && Utils.equals(moduleSymbol.id().orgName(), ORG_NAME);
    }

    private boolean isListenerBelongsToUdpModule(TypeSymbol listenerType) {
        if (listenerType.typeKind() == TypeDescKind.UNION) {
            return ((UnionTypeSymbol)listenerType).memberTypeDescriptors().stream().filter(typeDescriptor -> typeDescriptor instanceof TypeReferenceTypeSymbol).map(typeReferenceTypeSymbol -> (TypeReferenceTypeSymbol)typeReferenceTypeSymbol).anyMatch(typeReferenceTypeSymbol -> this.isUdpModule((ModuleSymbol)typeReferenceTypeSymbol.getModule().get()));
        }
        if (listenerType.typeKind() == TypeDescKind.TYPE_REFERENCE) {
            return this.isUdpModule((ModuleSymbol)((TypeReferenceTypeSymbol)listenerType).typeDescriptor().getModule().get());
        }
        return false;
    }
}

