/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.lib.data.xmldata.utils;

import io.ballerina.lib.data.xmldata.FromString;
import io.ballerina.lib.data.xmldata.utils.Constants;
import io.ballerina.lib.data.xmldata.utils.DiagnosticErrorCode;
import io.ballerina.lib.data.xmldata.utils.DiagnosticLog;
import io.ballerina.lib.data.xmldata.utils.XsdUtils;
import io.ballerina.lib.data.xmldata.xml.QualifiedName;
import io.ballerina.lib.data.xmldata.xml.QualifiedNameFactory;
import io.ballerina.lib.data.xmldata.xml.QualifiedNameMap;
import io.ballerina.lib.data.xmldata.xml.QualifiedNameSemantic;
import io.ballerina.lib.data.xmldata.xml.xsd.ChoiceInfo;
import io.ballerina.lib.data.xmldata.xml.xsd.ElementInfo;
import io.ballerina.lib.data.xmldata.xml.xsd.ModelGroupInfo;
import io.ballerina.lib.data.xmldata.xml.xsd.SequenceInfo;
import io.ballerina.runtime.api.Module;
import io.ballerina.runtime.api.creators.TypeCreator;
import io.ballerina.runtime.api.creators.ValueCreator;
import io.ballerina.runtime.api.flags.SymbolFlags;
import io.ballerina.runtime.api.types.AnnotatableType;
import io.ballerina.runtime.api.types.ArrayType;
import io.ballerina.runtime.api.types.Field;
import io.ballerina.runtime.api.types.MapType;
import io.ballerina.runtime.api.types.PredefinedTypes;
import io.ballerina.runtime.api.types.RecordType;
import io.ballerina.runtime.api.types.ReferenceType;
import io.ballerina.runtime.api.types.TupleType;
import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.api.types.TypeTags;
import io.ballerina.runtime.api.types.UnionType;
import io.ballerina.runtime.api.utils.StringUtils;
import io.ballerina.runtime.api.utils.TypeUtils;
import io.ballerina.runtime.api.utils.ValueUtils;
import io.ballerina.runtime.api.values.BArray;
import io.ballerina.runtime.api.values.BError;
import io.ballerina.runtime.api.values.BMap;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.runtime.api.values.BTypedesc;
import io.ballerina.stdlib.constraint.Constraints;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import javax.xml.namespace.QName;

public class DataUtils {
    private static final String ATTRIBUTE_PREFIX = "attribute_";
    private static final String VALUE = "value";
    private static String contentFieldName = "#content";

    public static QualifiedName validateAndGetXmlNameFromRecordAnnotation(RecordType recordType, String recordName, QualifiedName elementName, boolean useSemanticEquality) {
        BMap annotations = recordType.getAnnotations();
        String localName = recordName;
        for (BString annotationsKey : (BString[])annotations.getKeys()) {
            String localPart;
            if (!DataUtils.isNameAnnotationKey(annotationsKey.getValue())) continue;
            String name = ((BMap)annotations.get((Object)annotationsKey)).get((Object)Constants.VALUE).toString();
            if (!name.equals(localPart = elementName.getLocalPart())) {
                throw DiagnosticLog.error(DiagnosticErrorCode.TYPE_NAME_MISMATCH_WITH_XML_ELEMENT, name, localPart);
            }
            localName = name;
            break;
        }
        for (BString annotationsKey : (BString[])annotations.getKeys()) {
            String key = annotationsKey.getValue();
            if (!DataUtils.isNamespaceAnnotationKey(key)) continue;
            Map namespaceAnnotation = (Map)annotations.get((Object)StringUtils.fromString((String)key));
            BString uri = (BString)namespaceAnnotation.get(Constants.URI);
            BString prefix = (BString)namespaceAnnotation.get(Constants.PREFIX);
            return QualifiedNameFactory.createQualifiedName(uri == null ? "" : uri.getValue(), localName, prefix == null ? "" : prefix.getValue(), useSemanticEquality);
        }
        return QualifiedNameFactory.createQualifiedName("$$ns_annot_not_defined$$", localName, "", useSemanticEquality);
    }

    public static void validateTypeNamespace(String prefix, String uri, RecordType recordType) {
        ArrayList<String> namespace = DataUtils.getNamespace(recordType);
        int size = namespace.size();
        if (size == 0) {
            return;
        }
        if (size == 1 && uri.equals(namespace.get(0))) {
            return;
        }
        if (namespace.isEmpty() || prefix.equals(namespace.get(0)) && uri.equals(namespace.get(1))) {
            return;
        }
        throw DiagnosticLog.error(DiagnosticErrorCode.NAMESPACE_MISMATCH, recordType.getName());
    }

    public static void validateTypeNamespaceForNextRecord(String prefix, String uri, RecordType recordType, RecordType parentRecord, String fieldName) {
        ArrayList<String> fieldNamespace = DataUtils.getFieldNamespaceForNextRecord(parentRecord, fieldName);
        if (!fieldNamespace.isEmpty()) {
            DataUtils.validateFieldNamespaces(fieldNamespace, prefix, uri, recordType);
            return;
        }
        ArrayList<String> parentNamespace = DataUtils.getParentNamespaceForNextRecord(parentRecord);
        if (!parentNamespace.isEmpty()) {
            DataUtils.validateParentNamespaces(parentNamespace, prefix, uri, recordType);
        }
    }

    private static void validateParentNamespaces(ArrayList<String> parentNamespace, String prefix, String uri, RecordType recordType) {
        int size = parentNamespace.size();
        if (size == 0 || size == 2) {
            return;
        }
        if (size == 1 && uri.equals(parentNamespace.get(0))) {
            return;
        }
        throw DiagnosticLog.error(DiagnosticErrorCode.NAMESPACE_MISMATCH, recordType.getName());
    }

    private static void validateFieldNamespaces(ArrayList<String> namespace, String prefix, String uri, RecordType recordType) {
        int size = namespace.size();
        if (size == 0) {
            return;
        }
        if (size == 1 && uri.equals(namespace.get(0))) {
            return;
        }
        if (namespace.isEmpty() || prefix.equals(namespace.get(0)) && uri.equals(namespace.get(1))) {
            return;
        }
        throw DiagnosticLog.error(DiagnosticErrorCode.NAMESPACE_MISMATCH, recordType.getName());
    }

    private static ArrayList<String> getNamespace(RecordType recordType) {
        BMap annotations = recordType.getAnnotations();
        ArrayList<String> namespace = new ArrayList<String>();
        for (BString annotationsKey : (BString[])annotations.getKeys()) {
            if (!DataUtils.isNamespaceAnnotationKey(annotationsKey.getValue())) continue;
            BMap namespaceAnnotation = (BMap)annotations.get((Object)annotationsKey);
            boolean isContainsPrefix = namespaceAnnotation.containsKey((Object)Constants.PREFIX);
            if (isContainsPrefix) {
                namespace.add(((BString)namespaceAnnotation.get((Object)Constants.PREFIX)).getValue());
            }
            namespace.add(((BString)namespaceAnnotation.get((Object)Constants.URI)).getValue());
            break;
        }
        return namespace;
    }

    private static ArrayList<String> getNamespacesArray(BMap<BString, Object> namespaceAnnotation) {
        ArrayList<String> namespace = new ArrayList<String>();
        if (namespaceAnnotation == null) {
            return namespace;
        }
        boolean isContainsPrefix = namespaceAnnotation.containsKey((Object)Constants.PREFIX);
        if (isContainsPrefix) {
            namespace.add(((BString)namespaceAnnotation.get((Object)Constants.PREFIX)).getValue());
        }
        namespace.add(((BString)namespaceAnnotation.get((Object)Constants.URI)).getValue());
        return namespace;
    }

    private static ArrayList<String> getFieldNamespaceForNextRecord(RecordType parentRecord, String fieldName) {
        BMap<BString, Object> namespaceAnnotation = DataUtils.getRelevantFieldNamespaceForRecordField(parentRecord, fieldName);
        return DataUtils.getNamespacesArray(namespaceAnnotation);
    }

    private static ArrayList<String> getParentNamespaceForNextRecord(RecordType parentRecord) {
        BMap<BString, Object> namespaceAnnotation = DataUtils.getRelevantParentNamespaceForRecordField(parentRecord);
        return DataUtils.getNamespacesArray(namespaceAnnotation);
    }

    private static BMap<BString, Object> getRelevantFieldNamespaceForRecordField(RecordType recordType, String fieldName) {
        BMap annotations = recordType.getAnnotations();
        for (BString annotationKey : (BString[])annotations.getKeys()) {
            String annotationFieldName;
            String keyStr = annotationKey.getValue();
            if (!keyStr.contains("$field$.") || !(annotationFieldName = keyStr.split("\\$field\\$\\.")[1].replaceAll("\\\\", "")).equals(fieldName)) continue;
            Map fieldAnnotation = (Map)annotations.get((Object)annotationKey);
            for (BString key : fieldAnnotation.keySet()) {
                if (!DataUtils.isNamespaceAnnotationKey(key.getValue())) continue;
                return (BMap)fieldAnnotation.get(key);
            }
        }
        return null;
    }

    private static BMap<BString, Object> getRelevantParentNamespaceForRecordField(RecordType recordType) {
        BMap annotations = recordType.getAnnotations();
        for (BString annotationKey : (BString[])annotations.getKeys()) {
            if (!DataUtils.isNamespaceAnnotationKey(annotationKey.getValue())) continue;
            return (BMap)annotations.get((Object)annotationKey);
        }
        return null;
    }

    public static Map<QualifiedName, Field> getAllFieldsInRecordType(RecordType recordType, XmlAnalyzerData analyzerData) {
        BMap annotations = recordType.getAnnotations();
        LinkedHashMap<String, QualifiedName> modifiedNames = new LinkedHashMap<String, QualifiedName>();
        for (BString annotationKey : (BString[])annotations.getKeys()) {
            String keyStr = annotationKey.getValue();
            if (!keyStr.contains("$field$.")) continue;
            String fieldName = keyStr.split("\\$field\\$\\.")[1].replaceAll("\\\\", "");
            Map fieldAnnotation = (Map)annotations.get((Object)annotationKey);
            QualifiedName fieldQName = DataUtils.getFieldNameFromRecord(fieldAnnotation, fieldName, analyzerData.useSemanticEquality);
            fieldQName.setLocalPart(DataUtils.getModifiedName(fieldAnnotation, fieldName));
            modifiedNames.put(fieldName, fieldQName);
        }
        HashMap<QualifiedName, Field> fieldMap = new HashMap<QualifiedName, Field>();
        HashMap<String, ArrayList<QualifiedName>> fieldNames = new HashMap<String, ArrayList<QualifiedName>>();
        Map recordFields = recordType.getFields();
        for (String key : recordFields.keySet()) {
            QualifiedNameMap attributeMap = (QualifiedNameMap)analyzerData.attributeHierarchy.peek();
            QualifiedName modifiedQName = ((HashMap)modifiedNames).getOrDefault(key, QualifiedNameFactory.createQualifiedName("$$ns_annot_not_defined$$", key, "", analyzerData.useSemanticEquality));
            String localName = modifiedQName.getLocalPart();
            if (attributeMap.contains(modifiedQName) && modifiedQName.getAttributeState() == QualifiedName.AttributeState.NOT_DEFINED) {
                if (key.equals(((Field)attributeMap.get(modifiedQName)).getFieldName())) continue;
                modifiedQName.setAttributeState(QualifiedName.AttributeState.ELEMENT);
                fieldMap.put(modifiedQName, (Field)recordFields.get(key));
                fieldNames.put(localName, new ArrayList<QualifiedName>(List.of(modifiedQName)));
                continue;
            }
            if (fieldMap.containsKey(modifiedQName)) {
                throw DiagnosticLog.error(DiagnosticErrorCode.DUPLICATE_FIELD, localName);
            }
            if (fieldNames.containsKey(localName)) {
                List qNames = (List)fieldNames.get(localName);
                qNames.forEach(qName -> {
                    if (DataUtils.isSameAttributeFlag(qName.getAttributeState(), modifiedQName.getAttributeState()) && DataUtils.isSameNamespace(qName, modifiedQName)) {
                        throw DiagnosticLog.error(DiagnosticErrorCode.DUPLICATE_FIELD, localName);
                    }
                });
                fieldMap.put(modifiedQName, (Field)recordFields.get(key));
                ((List)fieldNames.get(localName)).add(modifiedQName);
                continue;
            }
            if (attributeMap.contains(modifiedQName)) continue;
            fieldMap.put(modifiedQName, (Field)recordFields.get(key));
            fieldNames.put(localName, new ArrayList<QualifiedName>(List.of(modifiedQName)));
        }
        return fieldMap;
    }

    public static Map<QualifiedName, Field> getAllAttributesInRecordType(RecordType recordType, boolean useSemanticEquality) {
        BMap annotations = recordType.getAnnotations();
        HashMap<QualifiedName, Field> attributes = new HashMap<QualifiedName, Field>();
        for (BString annotationKey : (BString[])annotations.getKeys()) {
            String keyStr = annotationKey.getValue();
            if (!keyStr.contains("$field$.") || !DataUtils.isAttributeField(annotationKey, (BMap<BString, Object>)annotations)) continue;
            String attributeName = keyStr.split("\\$field\\$\\.")[1].replaceAll("\\\\", "");
            Map fieldAnnotation = (Map)annotations.get((Object)annotationKey);
            QualifiedName fieldQName = DataUtils.getFieldNameFromRecord(fieldAnnotation, attributeName, useSemanticEquality);
            fieldQName.setAttributeState(QualifiedName.AttributeState.ATTRIBUTE);
            fieldQName.setLocalPart(DataUtils.getModifiedName(fieldAnnotation, attributeName));
            attributes.put(fieldQName, (Field)recordType.getFields().get(attributeName));
        }
        return attributes;
    }

    public static QualifiedName getFieldNameFromRecord(Map<BString, Object> fieldAnnotation, String fieldName, boolean useSemanticEquality) {
        for (BString key : fieldAnnotation.keySet()) {
            if (!DataUtils.isNamespaceAnnotationKey(key.getValue())) continue;
            Map namespaceAnnotation = (Map)fieldAnnotation.get(key);
            BString uri = (BString)namespaceAnnotation.get(Constants.URI);
            BString prefix = (BString)namespaceAnnotation.get(Constants.PREFIX);
            return QualifiedNameFactory.createQualifiedName(uri == null ? "" : uri.getValue(), fieldName, prefix == null ? "" : prefix.getValue(), useSemanticEquality);
        }
        return QualifiedNameFactory.createQualifiedName("$$ns_annot_not_defined$$", fieldName, "", useSemanticEquality);
    }

    static String getModifiedName(Map<BString, Object> fieldAnnotation, String attributeName) {
        for (BString key : fieldAnnotation.keySet()) {
            if (!DataUtils.isNameAnnotationKey(key.getValue())) continue;
            return ((Map)fieldAnnotation.get(key)).get(Constants.VALUE).toString();
        }
        return attributeName;
    }

    public static QualifiedName getElementName(QName qName, boolean useSemanticEquality) {
        return QualifiedNameFactory.createQualifiedName(qName.getNamespaceURI(), qName.getLocalPart(), qName.getPrefix(), QualifiedName.AttributeState.ELEMENT, useSemanticEquality);
    }

    public static Object convertStringToExpType(BString value, Type expType) {
        Type refferedType = TypeUtils.getReferredType((Type)expType);
        Object result = switch (refferedType.getTag()) {
            case 15, 23, 29 -> FromString.fromStringWithType(value, (Type)PredefinedTypes.TYPE_JSON);
            case 32 -> DataUtils.convertStringToExpType(value, ((ArrayType)refferedType).getElementType());
            case 33 -> DataUtils.convertStringToUnionExpType(value, expType);
            case 16 -> ValueUtils.convert((Object)value, (Type)expType);
            default -> FromString.fromStringWithType(value, expType);
        };
        if (result instanceof BError) {
            throw (BError)((Object)result);
        }
        return result;
    }

    private static Object convertStringToUnionExpType(BString value, Type expType) {
        for (Type memberType : ((UnionType)expType).getMemberTypes()) {
            memberType = TypeUtils.getReferredType((Type)memberType);
            try {
                return DataUtils.convertStringToExpType(value, memberType);
            }
            catch (Exception exception) {
            }
        }
        throw DiagnosticLog.error(DiagnosticErrorCode.FIELD_CANNOT_CAST_INTO_TYPE, expType);
    }

    public static void validateRequiredFields(XmlAnalyzerData analyzerData, BMap<BString, Object> currentMapValue) {
        Map fields = ((QualifiedNameMap)analyzerData.fieldHierarchy.peek()).getMembers();
        for (QualifiedName key : fields.keySet()) {
            Field field = (Field)fields.get(key);
            String fieldName = field.getFieldName();
            Type fieldType = TypeUtils.getReferredType((Type)field.getFieldType());
            if (fieldType.getTag() == 32) {
                ArrayType arrayType = (ArrayType)fieldType;
                if (arrayType.getSize() == -1 || (long)arrayType.getSize() == ((BArray)currentMapValue.get((Object)StringUtils.fromString((String)fieldName))).getLength()) continue;
                throw DiagnosticLog.error(DiagnosticErrorCode.ARRAY_SIZE_MISMATCH, new Object[0]);
            }
            if (!SymbolFlags.isFlagOn((long)field.getFlags(), (long)256L)) continue;
            throw DiagnosticLog.error(DiagnosticErrorCode.REQUIRED_FIELD_NOT_PRESENT, fieldName);
        }
        Map attributes = ((QualifiedNameMap)analyzerData.attributeHierarchy.peek()).getMembers();
        for (QualifiedName key : attributes.keySet()) {
            Field field = (Field)attributes.get(key);
            if (SymbolFlags.isFlagOn((long)field.getFlags(), (long)4096L)) continue;
            throw DiagnosticLog.error(DiagnosticErrorCode.REQUIRED_ATTRIBUTE_NOT_PRESENT, field.getFieldName());
        }
    }

    public static boolean isArrayValueAssignable(Type type) {
        int typeTag = type.getTag();
        if (typeTag == 33) {
            for (Type memberType : ((UnionType)type).getMemberTypes()) {
                if (!DataUtils.isArrayValueAssignable((memberType = TypeUtils.getReferredType((Type)memberType)).getTag())) continue;
                return true;
            }
        }
        return DataUtils.isArrayValueAssignable(typeTag);
    }

    public static boolean isArrayValueAssignable(int typeTag) {
        return typeTag == 32 || typeTag == 23 || typeTag == 15;
    }

    public static boolean isStringValueAssignable(int typeTag) {
        return typeTag == 5 || typeTag == 23 || typeTag == 15;
    }

    public static BArray createArrayValue(Type type) {
        return switch (type.getTag()) {
            case 32 -> ValueCreator.createArrayValue((ArrayType)((ArrayType)type));
            case 15 -> ValueCreator.createArrayValue((ArrayType)PredefinedTypes.TYPE_JSON_ARRAY);
            case 23 -> ValueCreator.createArrayValue((ArrayType)PredefinedTypes.TYPE_ANYDATA_ARRAY);
            case 53 -> DataUtils.createArrayValue(TypeUtils.getReferredType((Type)type));
            default -> throw new IllegalStateException("Unexpected value: " + type.getTag());
        };
    }

    public static MapType getMapTypeFromConstraintType(Type constraintType) {
        return switch (constraintType.getTag()) {
            case 27 -> (MapType)constraintType;
            case 1, 2, 3, 4, 5, 6, 14, 15, 16, 24, 47 -> TypeCreator.createMapType((Type)constraintType);
            case 32 -> TypeCreator.createMapType((Type)((ArrayType)constraintType).getElementType());
            case 53 -> DataUtils.getMapTypeFromConstraintType(TypeUtils.getReferredType((Type)constraintType));
            default -> TypeCreator.createMapType((Type)PredefinedTypes.TYPE_ANYDATA);
        };
    }

    public static void updateExpectedTypeStacks(RecordType recordType, XmlAnalyzerData analyzerData) {
        analyzerData.attributeHierarchy.push(new QualifiedNameMap<Field>(DataUtils.getAllAttributesInRecordType(recordType, analyzerData.useSemanticEquality)));
        analyzerData.fieldHierarchy.push(new QualifiedNameMap<Field>(DataUtils.getAllFieldsInRecordType(recordType, analyzerData)));
        analyzerData.visitedFieldHierarchy.push(new QualifiedNameMap(new HashMap()));
        analyzerData.restTypes.push(recordType.getRestFieldType());
        analyzerData.xsdModelGroupInfo.push(new HashMap());
        analyzerData.xmlElementInfo.push(new HashMap());
    }

    public static void popExpectedTypeStacks(XmlAnalyzerData analyzerData) {
        analyzerData.fieldHierarchy.pop();
        analyzerData.visitedFieldHierarchy.pop();
        analyzerData.restTypes.pop();
        analyzerData.attributeHierarchy.pop();
        analyzerData.arrayIndexes.pop();
        XsdUtils.popXsdValidationStacks(analyzerData);
    }

    public static boolean isAnydataOrJson(int typeTag) {
        return typeTag == 23 || typeTag == 15;
    }

    public static boolean isSupportedType(Type type) {
        switch (type.getTag()) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 21: 
            case 23: 
            case 24: 
            case 27: 
            case 46: {
                return true;
            }
            case 32: {
                return DataUtils.isSupportedType(((ArrayType)type).getElementType());
            }
            case 33: {
                return DataUtils.isSupportedUnionType((UnionType)type);
            }
            case 53: {
                return DataUtils.isSupportedType(TypeUtils.getReferredType((Type)type));
            }
        }
        return false;
    }

    private static boolean isSupportedUnionType(UnionType type) {
        for (Type memberType : type.getMemberTypes()) {
            if (!DataUtils.isSupportedType(memberType)) continue;
            return true;
        }
        return false;
    }

    public static void updateOptions(BMap<BString, Object> options, XmlAnalyzerData analyzerData) {
        analyzerData.attributePrefix = options.get((Object)Constants.ATTRIBUTE_PREFIX).toString();
        analyzerData.textFieldName = options.get((Object)Constants.TEXT_FIELD_NAME).toString();
        analyzerData.allowDataProjection = (Boolean)options.get((Object)Constants.ALLOW_DATA_PROJECTION);
        analyzerData.useSemanticEquality = (Boolean)options.get((Object)Constants.USE_SEMANTIC_EQUALITY);
    }

    public static void logArrayMismatchErrorIfProjectionNotAllowed(boolean allowDataProjection) {
        if (allowDataProjection) {
            return;
        }
        throw DiagnosticLog.error(DiagnosticErrorCode.ARRAY_SIZE_MISMATCH, new Object[0]);
    }

    public static boolean isSameNamespace(QualifiedName q1, QualifiedName q2) {
        String ns1 = q1.getNamespaceURI();
        String ns2 = q2.getNamespaceURI();
        if (q1 instanceof QualifiedNameSemantic && q2 instanceof QualifiedNameSemantic) {
            return ns1.equals(ns2) || ns1.equals("$$ns_annot_not_defined$$") || ns2.equals("$$ns_annot_not_defined$$");
        }
        return ns1.equals(ns2) && q1.getPrefix().equals(q2.getPrefix()) || ns1.equals("$$ns_annot_not_defined$$") || ns2.equals("$$ns_annot_not_defined$$");
    }

    public static boolean isSameAttributeFlag(QualifiedName.AttributeState flag1, QualifiedName.AttributeState flag2) {
        return flag1 == QualifiedName.AttributeState.NOT_DEFINED || flag2 == QualifiedName.AttributeState.NOT_DEFINED || flag1.equals((Object)flag2);
    }

    public static boolean isXMLArrayType(Type type) {
        if (type.getTag() != 32) {
            return false;
        }
        ArrayType arrayType = (ArrayType)type;
        Type elementType = TypeUtils.getReferredType((Type)arrayType.getElementType());
        return TypeTags.isXMLTypeTag((int)elementType.getTag());
    }

    public static Object getModifiedRecord(BMap<BString, Object> input, BString textFieldName, BTypedesc type) {
        Type describingType = type.getDescribingType();
        Type referredType = TypeUtils.getReferredType((Type)describingType);
        contentFieldName = textFieldName.getValue();
        if (describingType.getTag() == 27) {
            Type constraintType = TypeUtils.getReferredType((Type)((MapType)describingType).getConstrainedType());
            switch (constraintType.getTag()) {
                case 32: {
                    return DataUtils.processArrayValue(input, (ArrayType)constraintType);
                }
                case 27: {
                    BMap jsonMap = ValueCreator.createMapValue((MapType)TypeCreator.createMapType((Type)PredefinedTypes.TYPE_XML));
                    for (Map.Entry entry : input.entrySet()) {
                        jsonMap.put((Object)((BString)entry.getKey()), entry.getValue());
                    }
                    return jsonMap;
                }
                case 33: {
                    return DiagnosticLog.error(DiagnosticErrorCode.UNSUPPORTED_TYPE, new Object[0]);
                }
            }
        }
        if (referredType instanceof RecordType && describingType.getFlags() != 2049L) {
            BArray jsonArray = ValueCreator.createArrayValue((ArrayType)PredefinedTypes.TYPE_JSON_ARRAY);
            BMap<BString, Object> recordField = DataUtils.addFields(input, describingType);
            BMap<BString, Object> processedRecord = DataUtils.processParentAnnotation(describingType, recordField);
            BString rootTagName = ((BString[])processedRecord.getKeys())[0];
            jsonArray.append(processedRecord.get((Object)rootTagName));
            jsonArray.append((Object)rootTagName);
            return jsonArray;
        }
        return input;
    }

    private static BMap<BString, Object> mergeOriginalAndCurrentAnnotations(BMap<BString, Object> originalTypeAnnotations, BMap<BString, Object> typeAnnotations) {
        BMap mergedAnnotations = ValueCreator.createMapValue();
        for (Map.Entry entry : originalTypeAnnotations.entrySet()) {
            if (mergedAnnotations.containsKey(entry.getKey())) continue;
            mergedAnnotations.put((Object)((BString)entry.getKey()), entry.getValue());
        }
        for (Map.Entry entry : typeAnnotations.entrySet()) {
            if (mergedAnnotations.containsKey(entry.getKey())) continue;
            mergedAnnotations.put((Object)((BString)entry.getKey()), entry.getValue());
        }
        return mergedAnnotations;
    }

    private static BMap<BString, Object> processArrayValue(BMap<BString, Object> input, ArrayType arrayType) {
        Type elementType = arrayType.getElementType();
        Type referedType = TypeUtils.getReferredType((Type)elementType);
        switch (referedType.getTag()) {
            case 24: {
                BMap jsonMap = ValueCreator.createMapValue((MapType)Constants.JSON_MAP_TYPE);
                for (Map.Entry entry : input.entrySet()) {
                    ArrayList<BMap> records = new ArrayList<BMap>();
                    BArray arrayValue = (BArray)entry.getValue();
                    int i = 0;
                    while ((long)i < arrayValue.getLength()) {
                        BMap<BString, Object> record = DataUtils.addFields((BMap<BString, Object>)((BMap)arrayValue.get((long)i)), elementType);
                        BMap<BString, Object> parentRecord = DataUtils.processParentAnnotation(referedType, record);
                        records.add((BMap)parentRecord.get((Object)((BString[])parentRecord.getKeys())[0]));
                        ++i;
                    }
                    jsonMap.put((Object)((BString)entry.getKey()), (Object)ValueCreator.createArrayValue((Object[])records.toArray(), (ArrayType)TypeCreator.createArrayType((Type)referedType)));
                }
                return jsonMap;
            }
            case 16: {
                ArrayType xmlArrayType = TypeCreator.createArrayType((Type)PredefinedTypes.TYPE_XML);
                BMap jsonMap = ValueCreator.createMapValue((MapType)TypeCreator.createMapType((Type)xmlArrayType));
                for (Map.Entry entry : input.entrySet()) {
                    BArray arrayValue = (BArray)entry.getValue();
                    BArray xmlArrayValue = ValueCreator.createArrayValue((ArrayType)xmlArrayType);
                    int i = 0;
                    while ((long)i < arrayValue.getLength()) {
                        xmlArrayValue.append(arrayValue.get((long)i));
                        ++i;
                    }
                    jsonMap.put((Object)((BString)entry.getKey()), (Object)xmlArrayValue);
                }
                return jsonMap;
            }
        }
        return input;
    }

    private static BMap<BString, Object> addFields(BMap<BString, Object> input, Type type) {
        BMap recordValue = ValueCreator.createMapValue((MapType)Constants.JSON_MAP_TYPE);
        BMap<BString, Object> annotations = ValueCreator.createMapValue();
        if (type instanceof AnnotatableType) {
            AnnotatableType annotatableType = (AnnotatableType)type;
            annotations = annotatableType.getAnnotations();
        }
        RecordType recordType = (RecordType)TypeUtils.getReferredType((Type)type);
        BMap<BString, Object> mergedAnnotations = type instanceof ReferenceType ? DataUtils.mergeOriginalAndCurrentAnnotations(annotations, (BMap<BString, Object>)recordType.getAnnotations()) : annotations;
        Map fields = recordType.getFields();
        for (Map.Entry entry : input.entrySet()) {
            String key = ((BString)entry.getKey()).getValue();
            Object value = entry.getValue();
            if (fields.containsKey(key)) {
                DataUtils.processRecordField(((Field)fields.get(key)).getFieldType(), mergedAnnotations, (BMap<BString, Object>)recordValue, entry, key, value);
                continue;
            }
            recordValue.put((Object)StringUtils.fromString((String)key), value);
        }
        return recordValue;
    }

    static BString[] getOrderedRecordKeysIfXsdSequencePresent(BMap<BString, Object> input, HashMap<String, Integer> xsdSequencePriorityOrder) {
        HashMap<String, String> localPartKeys = DataUtils.getLocalPartKeys(input);
        if (xsdSequencePriorityOrder.isEmpty()) {
            return (BString[])input.getKeys();
        }
        return (BString[])xsdSequencePriorityOrder.entrySet().stream().filter(entry -> localPartKeys.containsKey(entry.getKey())).sorted(Comparator.comparingInt(Map.Entry::getValue)).map(entry -> StringUtils.fromString((String)((String)localPartKeys.get(entry.getKey())))).toArray(BString[]::new);
    }

    private static HashMap<String, String> getLocalPartKeys(BMap<BString, Object> input) {
        HashMap<String, String> localPartKeys = new HashMap<String, String>();
        for (Map.Entry entry : input.entrySet()) {
            String k = ((BString)entry.getKey()).getValue();
            if (k.contains(ATTRIBUTE_PREFIX)) continue;
            int i = k.indexOf(":");
            if (i != -1) {
                localPartKeys.put(k.substring(i + 1), k);
                continue;
            }
            localPartKeys.put(k, k);
        }
        return localPartKeys;
    }

    private static void processRecordField(Type fieldType, BMap<BString, Object> annotations, BMap<BString, Object> recordValue, Map.Entry<BString, Object> entry, String key, Object value) {
        fieldType = DataUtils.getTypeFromUnionType(fieldType, value);
        switch (fieldType.getTag()) {
            case 24: {
                DataUtils.processRecord(key, annotations, recordValue, value, (RecordType)fieldType);
                break;
            }
            case 32: {
                DataUtils.processArray(fieldType, annotations, recordValue, entry);
                break;
            }
            case 53: {
                Type referredType = TypeUtils.getReferredType((Type)fieldType);
                if (referredType.getTag() != 24) {
                    DataUtils.processRecordField(referredType, annotations, recordValue, entry, key, value);
                    return;
                }
                DataUtils.processTypeReferenceType(fieldType, annotations, recordValue, key, value);
                break;
            }
            default: {
                DataUtils.addPrimitiveValue(DataUtils.addFieldNamespaceAnnotation(key, key, annotations, recordValue), annotations, recordValue, value);
            }
        }
    }

    private static void processTypeReferenceType(Type fieldType, BMap<BString, Object> annotations, BMap<BString, Object> recordValue, String key, Object value) {
        BMap namespaceAnnotRecord = ValueCreator.createMapValue((MapType)Constants.JSON_MAP_TYPE);
        Type referredType = TypeUtils.getReferredType((Type)fieldType);
        RecordType recType = (RecordType)referredType;
        BMap<BString, Object> mergedAnnotations = DataUtils.mergeOriginalAndCurrentAnnotations(annotations, (BMap<BString, Object>)recType.getAnnotations());
        boolean doesNamespaceDefinedInField = false;
        if (!mergedAnnotations.isEmpty()) {
            String fieldName = key;
            QName qName = DataUtils.addFieldNamespaceAnnotation(fieldName, key = DataUtils.getKeyNameFromAnnotation(mergedAnnotations, key), mergedAnnotations, (BMap<BString, Object>)namespaceAnnotRecord);
            if (!qName.getNamespaceURI().isEmpty()) {
                doesNamespaceDefinedInField = true;
            }
            String localPart = qName.getLocalPart();
            key = qName.getPrefix().isBlank() ? localPart : qName.getPrefix() + ":" + localPart;
        }
        BMap annotationRecord = ValueCreator.createMapValue((MapType)Constants.JSON_MAP_TYPE);
        if (!doesNamespaceDefinedInField) {
            BMap subRecordAnnotations = recType.getAnnotations();
            key = DataUtils.getElementName((BMap<BString, Object>)subRecordAnnotations, key);
            DataUtils.processSubRecordAnnotation((BMap<BString, Object>)subRecordAnnotations, (BMap<BString, Object>)annotationRecord);
        }
        BMap<BString, Object> subRecordValue = DataUtils.addFields((BMap<BString, Object>)((BMap)value), referredType);
        DataUtils.addNamespaceToSubRecord(key, (BMap<BString, Object>)namespaceAnnotRecord, subRecordValue);
        if (!annotationRecord.isEmpty()) {
            subRecordValue.put((Object)((BString[])annotationRecord.getKeys())[0], annotationRecord.get((Object)((BString[])annotationRecord.getKeys())[0]));
        }
        recordValue.put((Object)StringUtils.fromString((String)key), subRecordValue);
    }

    private static void addNamespaceToSubRecord(String key, BMap<BString, Object> namespaceAnnotRecord, BMap<BString, Object> subRecord) {
        if (namespaceAnnotRecord.isEmpty()) {
            return;
        }
        Object value = namespaceAnnotRecord.get((Object)StringUtils.fromString((String)key));
        if (value == null) {
            return;
        }
        for (Map.Entry nsAnnotEntry : ((BMap)value).entrySet()) {
            subRecord.put((Object)((BString)nsAnnotEntry.getKey()), nsAnnotEntry.getValue());
        }
    }

    private static QName addFieldNamespaceAnnotation(String fieldName, String key, BMap<BString, Object> annotations, BMap<BString, Object> recordValue) {
        BString annotationKey = StringUtils.fromString((String)("$field$." + fieldName.replaceAll("[^a-zA-Z\\d _]", "\\\\$0")));
        boolean isAttributeField = DataUtils.isAttributeField(annotationKey, annotations);
        if (annotations.containsKey((Object)annotationKey)) {
            BMap annotationValue = (BMap)annotations.get((Object)annotationKey);
            for (BString fieldKey : (BString[])annotationValue.getKeys()) {
                if (!DataUtils.isNamespaceAnnotationKey(fieldKey.getValue())) continue;
                return DataUtils.processFieldNamespaceAnnotation((BMap<BString, Object>)annotationValue, key, fieldKey, recordValue, isAttributeField);
            }
        }
        return new QName("", key, "");
    }

    public static boolean isAttributeField(BString annotationKey, BMap<BString, Object> annotations) {
        if (!annotations.containsKey((Object)annotationKey)) {
            return false;
        }
        BMap annotationValue = (BMap)annotations.get((Object)annotationKey);
        for (BString fieldKey : (BString[])annotationValue.getKeys()) {
            if (!DataUtils.isAttributeAnnotationKey(fieldKey.getValue())) continue;
            return true;
        }
        return false;
    }

    private static BMap<BString, Object> getFieldNamespaceAndNameAnnotations(String key, BMap<BString, Object> parentAnnotations) {
        BMap nsFieldAnnotation = ValueCreator.createMapValue((MapType)Constants.JSON_MAP_TYPE);
        BString annotationKey = StringUtils.fromString((String)("$field$." + key.replaceAll("[^a-zA-Z\\d _]", "\\\\$0")));
        if (!parentAnnotations.containsKey((Object)annotationKey)) {
            return nsFieldAnnotation;
        }
        BMap annotationValue = (BMap)parentAnnotations.get((Object)annotationKey);
        for (BString fieldKey : (BString[])annotationValue.getKeys()) {
            String keyName = fieldKey.getValue();
            if (!DataUtils.isNamespaceAnnotationKey(keyName) && !DataUtils.isNameAnnotationKey(keyName)) continue;
            nsFieldAnnotation.put((Object)fieldKey, annotationValue.get((Object)fieldKey));
        }
        return nsFieldAnnotation;
    }

    private static void processRecord(String key, BMap<BString, Object> parentAnnotations, BMap<BString, Object> record, Object value, RecordType childType) {
        BMap parentRecordAnnotations = ValueCreator.createMapValue((MapType)Constants.JSON_MAP_TYPE);
        BMap annotation = childType.getAnnotations();
        if (!parentAnnotations.isEmpty()) {
            annotation.merge(DataUtils.getFieldNamespaceAndNameAnnotations(key, parentAnnotations), true);
            DataUtils.processSubRecordAnnotation(parentAnnotations, (BMap<BString, Object>)parentRecordAnnotations);
        }
        BMap<BString, Object> subRecord = DataUtils.addFields((BMap<BString, Object>)((BMap)value), (Type)childType);
        if (!annotation.isEmpty()) {
            DataUtils.processSubRecordAnnotation((BMap<BString, Object>)annotation, subRecord);
        }
        key = DataUtils.getElementName((BMap<BString, Object>)annotation, key);
        record.put((Object)StringUtils.fromString((String)key), subRecord);
        if (!parentRecordAnnotations.isEmpty()) {
            record.put((Object)((BString[])parentRecordAnnotations.getKeys())[0], parentRecordAnnotations.get((Object)((BString[])parentRecordAnnotations.getKeys())[0]));
        }
    }

    private static void addPrimitiveValue(QName qName, BMap<BString, Object> annotations, BMap<BString, Object> record, Object value) {
        BMap currentValue;
        BString localPart = StringUtils.fromString((String)qName.getLocalPart());
        BString key = qName.getPrefix().isBlank() ? localPart : StringUtils.fromString((String)(qName.getPrefix() + ":" + String.valueOf(localPart)));
        BString annotationKey = StringUtils.fromString((String)("$field$." + localPart.getValue().replaceAll("[^a-zA-Z\\d _]", "\\\\$0")));
        BString prevKey = key;
        if (record.containsKey((Object)key)) {
            currentValue = (BMap)record.get((Object)key);
            prevKey = key;
            key = StringUtils.fromString((String)contentFieldName);
        } else {
            currentValue = record;
        }
        if (annotations.containsKey((Object)annotationKey)) {
            BMap annotationValue = (BMap)annotations.get((Object)annotationKey);
            String keyName = DataUtils.processFieldAnnotation((BMap<BString, Object>)annotationValue, prevKey.getValue());
            String prevKeyValue = prevKey.getValue();
            BString formattedKeyName = StringUtils.fromString((String)keyName);
            BString formattedContentFieldName = StringUtils.fromString((String)contentFieldName);
            if (key.getValue().equals(contentFieldName)) {
                currentValue.put((Object)formattedContentFieldName, value);
                if (!keyName.equals(prevKeyValue)) {
                    record.put((Object)formattedKeyName, record.remove((Object)prevKey));
                }
            } else {
                currentValue.put((Object)formattedKeyName, value);
            }
        } else {
            currentValue.put((Object)key, value);
        }
    }

    private static void processArray(Type childType, BMap<BString, Object> annotations, BMap<BString, Object> record, Map.Entry<BString, Object> entry) {
        Type elementType = ((ArrayType)childType).getElementType();
        Type referedType = TypeUtils.getReferredType((Type)elementType);
        BMap annotationRecord = ValueCreator.createMapValue((MapType)Constants.JSON_MAP_TYPE);
        String keyName = entry.getKey().getValue();
        if (!annotations.isEmpty()) {
            keyName = DataUtils.getKeyNameFromAnnotation(annotations, keyName);
            DataUtils.processSubRecordAnnotation(annotations, (BMap<BString, Object>)annotationRecord);
        }
        BArray arrayValue = (BArray)entry.getValue();
        if (referedType.getTag() == 24) {
            ArrayList<BMap> records = new ArrayList<BMap>();
            int i = 0;
            while ((long)i < arrayValue.getLength()) {
                BMap<BString, Object> subRecord = DataUtils.addFields((BMap<BString, Object>)((BMap)arrayValue.get((long)i)), elementType);
                subRecord = DataUtils.processParentAnnotation(referedType, subRecord);
                records.add((BMap)subRecord.get((Object)((BString[])subRecord.getKeys())[0]));
                ++i;
            }
            record.put((Object)StringUtils.fromString((String)DataUtils.getElementName((BMap<BString, Object>)((RecordType)referedType).getAnnotations(), keyName)), (Object)ValueCreator.createArrayValue((Object[])records.toArray(), (ArrayType)TypeCreator.createArrayType((Type)Constants.JSON_ARRAY_TYPE)));
        } else {
            ArrayList<Object> records = new ArrayList<Object>();
            int i = 0;
            while ((long)i < arrayValue.getLength()) {
                records.add(arrayValue.get((long)i));
                ++i;
            }
            record.put((Object)StringUtils.fromString((String)keyName), (Object)ValueCreator.createArrayValue((Object[])records.toArray(), (ArrayType)TypeCreator.createArrayType((Type)Constants.JSON_ARRAY_TYPE)));
        }
        if (!annotationRecord.isEmpty()) {
            record.put((Object)((BString[])annotationRecord.getKeys())[0], annotationRecord.get((Object)((BString[])annotationRecord.getKeys())[0]));
        }
    }

    private static String getKeyNameFromAnnotation(BMap<BString, Object> annotations, String keyName) {
        BString annotationKey = StringUtils.fromString((String)("$field$." + keyName.replaceAll("[^a-zA-Z\\d _]", "\\\\$0")));
        if (annotations.containsKey((Object)annotationKey)) {
            BMap annotationValue = (BMap)annotations.get((Object)annotationKey);
            return DataUtils.processFieldAnnotation((BMap<BString, Object>)annotationValue, keyName);
        }
        return keyName;
    }

    public static Type getTypeFromUnionType(Type childType, Object value) {
        if (childType instanceof UnionType) {
            UnionType bUnionType = (UnionType)childType;
            for (Type memberType : bUnionType.getMemberTypes()) {
                if (!value.getClass().getName().toUpperCase(Locale.ROOT).contains(memberType.getName().toUpperCase(Locale.ROOT))) continue;
                childType = TypeUtils.getReferredType((Type)memberType);
            }
        }
        return childType;
    }

    private static BMap<BString, Object> processParentAnnotation(Type type, BMap<BString, Object> record) {
        BMap<BString, Object> annotations = ValueCreator.createMapValue();
        if (type instanceof AnnotatableType) {
            AnnotatableType annotatableType = (AnnotatableType)type;
            annotations = annotatableType.getAnnotations();
        }
        Type referedType = TypeUtils.getReferredType((Type)type);
        BMap<BString, Object> mergedAnnotations = type instanceof ReferenceType ? DataUtils.mergeOriginalAndCurrentAnnotations(annotations, (BMap<BString, Object>)((RecordType)referedType).getAnnotations()) : annotations;
        BMap parentRecord = ValueCreator.createMapValue((MapType)Constants.JSON_MAP_TYPE);
        BMap namespaces = ValueCreator.createMapValue((MapType)Constants.JSON_MAP_TYPE);
        BString rootName = DataUtils.processAnnotation(mergedAnnotations, type.getName(), (BMap<BString, Object>)namespaces);
        if (!namespaces.isEmpty()) {
            for (Map.Entry namespace : namespaces.entrySet()) {
                record.put((Object)((BString)namespace.getKey()), namespace.getValue());
            }
        }
        parentRecord.put((Object)rootName, record);
        return parentRecord;
    }

    private static String processFieldAnnotation(BMap<BString, Object> annotation, String key) {
        for (BString value : (BString[])annotation.getKeys()) {
            String stringValue = value.getValue();
            if (DataUtils.isNameAnnotationKey(stringValue)) {
                BMap names = (BMap)annotation.get((Object)value);
                String name = names.get((Object)StringUtils.fromString((String)VALUE)).toString();
                key = ((String)key).contains(":") ? ((String)key).substring(0, ((String)key).indexOf(":") + 1) + name : (((String)key).contains(ATTRIBUTE_PREFIX) ? ((String)key).substring(0, ((String)key).indexOf("_") + 1) + name : name);
            }
            if (!DataUtils.isAttributeAnnotationKey(stringValue)) continue;
            key = ATTRIBUTE_PREFIX.concat((String)key);
        }
        return key;
    }

    private static BString processAnnotation(BMap<BString, Object> annotation, String key, BMap<BString, Object> namespaces) {
        boolean hasNamespaceAnnotation = false;
        for (BString value : (BString[])annotation.getKeys()) {
            if (value.getValue().contains("$field$.")) continue;
            String stringValue = value.getValue();
            if (DataUtils.isNameAnnotationKey(stringValue)) {
                key = DataUtils.processNameAnnotation(annotation, key, value, hasNamespaceAnnotation);
            }
            if (!DataUtils.isNamespaceAnnotationKey(stringValue)) continue;
            hasNamespaceAnnotation = true;
            key = DataUtils.processNamespaceAnnotation(annotation, key, value, namespaces);
        }
        return StringUtils.fromString((String)key);
    }

    private static void processSubRecordAnnotation(BMap<BString, Object> annotation, BMap<BString, Object> subRecord) {
        BString[] keys;
        for (BString value : keys = (BString[])annotation.getKeys()) {
            if (!DataUtils.isNamespaceAnnotationKey(value.getValue())) continue;
            DataUtils.processNamespaceAnnotation(annotation, "", value, subRecord);
        }
    }

    private static String getElementName(BMap<BString, Object> annotation, String key) {
        BString[] keys = (BString[])annotation.getKeys();
        boolean hasNamespaceAnnotation = false;
        for (BString value : keys) {
            if (!DataUtils.isNamespaceAnnotationKey(value.getValue())) continue;
            hasNamespaceAnnotation = true;
            BMap namespaceAnnotation = (BMap)annotation.get((Object)value);
            BString prefix = (BString)namespaceAnnotation.get((Object)Constants.PREFIX);
            if (prefix == null) continue;
            key = prefix.getValue().concat(":").concat(key);
        }
        for (BString value : keys) {
            if (!DataUtils.isNameAnnotationKey(value.getValue())) continue;
            key = DataUtils.processNameAnnotation(annotation, key, value, hasNamespaceAnnotation);
        }
        return key;
    }

    private static String processNameAnnotation(BMap<BString, Object> annotation, String key, BString value, boolean hasNamespaceAnnotation) {
        String nameValue = ((BMap)annotation.get((Object)value)).get((Object)StringUtils.fromString((String)VALUE)).toString();
        if (hasNamespaceAnnotation) {
            return key.substring(0, key.indexOf(":") + 1) + nameValue;
        }
        return nameValue;
    }

    private static String processNamespaceAnnotation(BMap<BString, Object> annotation, String key, BString value, BMap<BString, Object> subRecord) {
        BMap namespaceAnnotation = (BMap)annotation.get((Object)value);
        BString uri = (BString)namespaceAnnotation.get((Object)Constants.URI);
        BString prefix = (BString)namespaceAnnotation.get((Object)Constants.PREFIX);
        if (prefix == null) {
            subRecord.put((Object)StringUtils.fromString((String)"attribute_xmlns"), (Object)uri);
        } else {
            subRecord.put((Object)StringUtils.fromString((String)("attribute_xmlns:" + String.valueOf(prefix))), (Object)uri);
            key = prefix.getValue().concat(":").concat(key);
        }
        return key;
    }

    private static QName processFieldNamespaceAnnotation(BMap<BString, Object> annotation, String key, BString value, BMap<BString, Object> subRecord, boolean isAttributeField) {
        BMap namespaceAnnotation = (BMap)annotation.get((Object)value);
        BString uri = (BString)namespaceAnnotation.get((Object)Constants.URI);
        BString prefix = (BString)namespaceAnnotation.get((Object)Constants.PREFIX);
        QName qName = new QName(uri == null ? "" : uri.getValue(), key, prefix == null ? "" : prefix.getValue());
        if (isAttributeField) {
            DataUtils.addAttributeToRecord(prefix, uri, key, subRecord);
        } else {
            BMap nextMapValue = ValueCreator.createMapValue((MapType)Constants.JSON_MAP_TYPE);
            key = DataUtils.addAttributeToRecord(prefix, uri, key, (BMap<BString, Object>)nextMapValue);
            subRecord.put((Object)StringUtils.fromString((String)key), (Object)nextMapValue);
        }
        return qName;
    }

    private static String addAttributeToRecord(BString prefix, BString uri, String key, BMap<BString, Object> subRecord) {
        if (prefix == null) {
            subRecord.put((Object)StringUtils.fromString((String)"attribute_xmlns"), (Object)uri);
            return key;
        }
        subRecord.put((Object)StringUtils.fromString((String)("attribute_xmlns:" + String.valueOf(prefix))), (Object)uri);
        return prefix.getValue().concat(":").concat(key);
    }

    public static boolean isRegExpType(Type type) {
        Module module = type.getPackage();
        if (module == null) {
            return false;
        }
        String moduleName = module.getName();
        String typeName = type.getName();
        if (typeName == null || moduleName == null) {
            return false;
        }
        if (moduleName.equals("lang.regexp") && typeName.equals("RegExp")) {
            return true;
        }
        if (type.getTag() == 53) {
            return DataUtils.isRegExpType(((ReferenceType)type).getReferredType());
        }
        return false;
    }

    private static boolean isNamespaceAnnotationKey(String key) {
        return key.startsWith("ballerina/data.xmldata") && key.endsWith("Namespace");
    }

    public static boolean isNameAnnotationKey(String key) {
        return key.startsWith("ballerina/data.xmldata") && key.endsWith("Name");
    }

    private static boolean isAttributeAnnotationKey(String key) {
        return key.startsWith("ballerina/data.xmldata") && key.endsWith("Attribute");
    }

    public static Object validateConstraints(Object convertedValue, BTypedesc typed, boolean requireValidation) {
        if (!requireValidation) {
            return convertedValue;
        }
        Object result = Constraints.validate((Object)convertedValue, (BTypedesc)typed);
        if (result instanceof BError) {
            BError bError = (BError)((Object)result);
            return DiagnosticLog.createXmlError(DataUtils.getPrintableErrorMsg(bError));
        }
        return convertedValue;
    }

    private static String getPrintableErrorMsg(BError err) {
        Object errorMsg = err.getMessage() != null ? err.getMessage() : "";
        Object details = err.getDetails();
        if (details != null && !details.toString().equals("{}")) {
            errorMsg = (String)errorMsg + ", " + String.valueOf(details);
        }
        return errorMsg;
    }

    public static boolean isEqualQualifiedName(QualifiedName firstQName, QualifiedName secondQName) {
        if (firstQName == null || secondQName == null) {
            return false;
        }
        if (firstQName.equals(secondQName)) {
            return true;
        }
        return firstQName.getLocalPart().equals(secondQName.getLocalPart()) && (firstQName.getNamespaceURI().equals("$$ns_annot_not_defined$$") || secondQName.getNamespaceURI().equals("$$ns_annot_not_defined$$"));
    }

    public static boolean isSimpleType(Type type) {
        return switch (type.getTag()) {
            case 15, 16, 23, 24, 27, 47 -> false;
            case 32 -> DataUtils.isSimpleType(((ArrayType)type).getElementType());
            case 53 -> DataUtils.isSimpleType(((ReferenceType)type).getReferredType());
            default -> true;
        };
    }

    public static String generateStringFromXmlReader(Reader reader) throws IOException {
        int numCharsRead;
        StringBuilder builder = new StringBuilder();
        char[] buffer = new char[1024];
        while ((numCharsRead = reader.read(buffer)) != -1) {
            builder.append(buffer, 0, numCharsRead);
        }
        return builder.toString();
    }

    public static boolean isSupportedTypeForAttributes(Type fieldType) {
        if (TypeTags.isIntegerTypeTag((int)fieldType.getTag())) {
            return true;
        }
        if (TypeTags.isStringTypeTag((int)fieldType.getTag())) {
            return true;
        }
        if (TypeTags.isXMLTypeTag((int)fieldType.getTag())) {
            return false;
        }
        return switch (fieldType.getTag()) {
            case 2, 3, 4, 6, 14, 15, 23, 29, 33 -> true;
            default -> false;
        };
    }

    public static boolean isContainsUnionType(Type expType) {
        Type memberType;
        if (expType == null) {
            return false;
        }
        if ((expType = TypeUtils.getReferredType((Type)expType)).getTag() == 33) {
            for (Type memberType2 : ((UnionType)expType).getMemberTypes()) {
                if (DataUtils.isSimpleType(memberType2)) continue;
                return true;
            }
        }
        if (expType.getTag() == 32) {
            memberType = TypeUtils.getReferredType((Type)((ArrayType)expType).getElementType());
            return DataUtils.isContainsUnionType(memberType);
        }
        if (expType.getTag() == 27) {
            memberType = TypeUtils.getReferredType((Type)((MapType)expType).getConstrainedType());
            return DataUtils.isContainsUnionType(memberType);
        }
        if (expType.getTag() == 44) {
            TupleType tupleType = (TupleType)expType;
            for (Type type : tupleType.getTupleTypes()) {
                if (!DataUtils.isContainsUnionType(type)) continue;
                return true;
            }
            return DataUtils.isContainsUnionType(tupleType.getRestType());
        }
        if (expType.getTag() == 24) {
            RecordType recordType = (RecordType)expType;
            for (Field field : recordType.getFields().values()) {
                if (!DataUtils.isContainsUnionType(field.getFieldType())) continue;
                return true;
            }
            return DataUtils.isContainsUnionType(recordType.getRestFieldType());
        }
        return false;
    }

    public static Collection<String> getXmlElementNames(RecordType fieldType) {
        HashSet<String> elementNames = new HashSet<String>(fieldType.getFields().keySet());
        BMap annotations = fieldType.getAnnotations();
        for (BString annotationKey : (BString[])annotations.getKeys()) {
            String key = annotationKey.getValue();
            if (!key.contains("$field$.")) continue;
            String fieldName = key.split("\\$field\\$\\.")[1].replaceAll("\\\\", "");
            Map fieldAnnotation = (Map)annotations.get((Object)annotationKey);
            for (BString fieldAnnotationKey : fieldAnnotation.keySet()) {
                DataUtils.updateFieldSetWithName(fieldAnnotation, elementNames, fieldAnnotationKey, fieldName);
            }
        }
        return elementNames;
    }

    private static void updateFieldSetWithName(Map<BString, Object> fieldAnnotation, Set<String> elementNames, BString fieldAnnotationKey, String fieldName) {
        String fieldAnnotationKeyStr = fieldAnnotationKey.getValue();
        if (fieldAnnotationKeyStr.startsWith("ballerina/data.xmldata") && fieldAnnotationKeyStr.endsWith("Name")) {
            BMap fieldAnnotationValue = (BMap)fieldAnnotation.get(fieldAnnotationKey);
            String xmlElementName = StringUtils.getStringValue((Object)fieldAnnotationValue.getStringValue(Constants.VALUE));
            elementNames.remove(fieldName);
            elementNames.add(xmlElementName);
        }
    }

    public static HashMap<String, String> getXmlElementNameMap(RecordType fieldType) {
        HashMap<String, String> elementMap = new HashMap<String, String>();
        BMap annotations = fieldType.getAnnotations();
        for (BString annotationKey : (BString[])annotations.getKeys()) {
            String key = annotationKey.getValue();
            if (!key.contains("$field$.")) continue;
            String fieldName = key.split("\\$field\\$\\.")[1].replaceAll("\\\\", "");
            Map fieldAnnotation = (Map)annotations.get((Object)annotationKey);
            for (BString fieldAnnotationKey : fieldAnnotation.keySet()) {
                DataUtils.getXmlElementNameFromFieldAnnotation(fieldAnnotation, fieldAnnotationKey, fieldName, elementMap);
            }
        }
        return elementMap;
    }

    private static void getXmlElementNameFromFieldAnnotation(Map<BString, Object> fieldAnnotation, BString fieldAnnotationKey, String fieldName, HashMap<String, String> xmlElementNameMap) {
        String fieldAnnotationKeyStr = fieldAnnotationKey.getValue();
        if (fieldAnnotationKeyStr.startsWith("ballerina/data.xmldata") && fieldAnnotationKeyStr.endsWith("Name")) {
            BMap fieldAnnotationValue = (BMap)fieldAnnotation.get(fieldAnnotationKey);
            String xmlElementName = StringUtils.getStringValue((Object)fieldAnnotationValue.getStringValue(Constants.VALUE));
            xmlElementNameMap.remove(fieldName);
            xmlElementNameMap.put(xmlElementName, fieldName);
        }
    }

    public static void popMappingTypeStacks(XmlAnalyzerMetaData xmlParserData) {
        xmlParserData.fieldHierarchy.pop();
        xmlParserData.visitedFieldHierarchy.pop();
        xmlParserData.restTypes.pop();
    }

    public static HashMap<String, Integer> getXsdSequencePriorityOrder(RecordType fieldType) {
        return DataUtils.getXsdSequencePriorityOrder((Type)fieldType, false);
    }

    public static HashMap<String, Integer> getXsdSequencePriorityOrder(Type type, boolean isSequenceElements) {
        if (type.getTag() != 24) {
            return new HashMap<String, Integer>();
        }
        RecordType fieldType = (RecordType)type;
        HashMap<String, Integer> elementPriorityOrder = new HashMap<String, Integer>();
        if (!isSequenceElements) {
            return elementPriorityOrder;
        }
        BMap annotations = fieldType.getAnnotations();
        for (BString annotationKey : (BString[])annotations.getKeys()) {
            String key = annotationKey.getValue();
            if (!key.contains("$field$.")) continue;
            String fieldName = key.split("\\$field\\$\\.")[1].replaceAll("\\\\", "");
            Map fieldAnnotation = (Map)annotations.get((Object)annotationKey);
            for (BString fieldAnnotationKey : fieldAnnotation.keySet()) {
                String fieldAnnotationKeyStr = fieldAnnotationKey.getValue();
                if (!fieldAnnotationKeyStr.startsWith("ballerina/data.xmldata") || !fieldAnnotationKeyStr.endsWith("SequenceOrder")) continue;
                BMap fieldAnnotationValue = (BMap)fieldAnnotation.get(fieldAnnotationKey);
                elementPriorityOrder.put(fieldName, fieldAnnotationValue.getIntValue(Constants.VALUE).intValue());
            }
        }
        return elementPriorityOrder;
    }

    public static HashMap<String, ModelGroupInfo> getFieldNamesWithModelGroupAnnotations(RecordType fieldType, HashMap<FieldAnnotationValue, String> elementNamesMap) {
        HashMap<String, ModelGroupInfo> fieldNamesWithModelGroupAnnotations = new HashMap<String, ModelGroupInfo>();
        BMap annotations = fieldType.getAnnotations();
        for (BString annotationKey : (BString[])annotations.getKeys()) {
            String key = annotationKey.getValue();
            if (!key.contains("$field$.")) continue;
            String fieldName = key.split("\\$field\\$\\.")[1].replaceAll("\\\\", "");
            if (elementNamesMap.containsKey(fieldName)) {
                fieldName = elementNamesMap.get(fieldName);
            }
            Map fieldAnnotation = (Map)annotations.get((Object)annotationKey);
            for (BString fieldAnnotationKey : fieldAnnotation.keySet()) {
                String fieldAnnotationKeyStr = fieldAnnotationKey.getValue();
                if (!fieldAnnotationKeyStr.startsWith("ballerina/data.xmldata")) continue;
                if (fieldAnnotationKeyStr.endsWith("Sequence")) {
                    SequenceInfo sequenceInfo = new SequenceInfo(fieldName, (BMap<BString, Object>)((BMap)fieldAnnotation.get(fieldAnnotationKey)), fieldType, null);
                    fieldNamesWithModelGroupAnnotations.put(fieldName, sequenceInfo);
                }
                if (!fieldAnnotationKeyStr.endsWith("Choice")) continue;
                ChoiceInfo choiceInfo = new ChoiceInfo(fieldName, (BMap<BString, Object>)((BMap)fieldAnnotation.get(fieldAnnotationKey)), fieldType, null);
                fieldNamesWithModelGroupAnnotations.put(fieldName, choiceInfo);
            }
        }
        return fieldNamesWithModelGroupAnnotations;
    }

    public static HashMap<String, ElementInfo> getFieldNamesWithElementGroupAnnotations(RecordType fieldType) {
        HashMap<String, ElementInfo> fieldNamesWithElementInfoAnnotations = new HashMap<String, ElementInfo>();
        BMap annotations = fieldType.getAnnotations();
        for (BString annotationKey : (BString[])annotations.getKeys()) {
            String key = annotationKey.getValue();
            if (!key.contains("$field$.")) continue;
            String fieldName = key.split("\\$field\\$\\.")[1].replaceAll("\\\\", "");
            Map fieldAnnotation = (Map)annotations.get((Object)annotationKey);
            for (BString fieldAnnotationKey : fieldAnnotation.keySet()) {
                String fieldAnnotationKeyStr = fieldAnnotationKey.getValue();
                if (!fieldAnnotationKeyStr.startsWith("ballerina/data.xmldata") || !fieldAnnotationKeyStr.endsWith("Element")) continue;
                ElementInfo elementInfo = new ElementInfo(null, fieldName, (BMap<BString, Object>)((BMap)fieldAnnotation.get(fieldAnnotationKey)));
                fieldNamesWithElementInfoAnnotations.put(fieldName, elementInfo);
            }
        }
        return fieldNamesWithElementInfoAnnotations;
    }

    public static ArrayList<String> getFieldNamesWithSequenceAnnotations(RecordType fieldType) {
        ArrayList<String> fieldNamesWithModelGroupAnnotations = new ArrayList<String>();
        BMap annotations = fieldType.getAnnotations();
        for (BString annotationKey : (BString[])annotations.getKeys()) {
            String key = annotationKey.getValue();
            if (!key.contains("$field$.")) continue;
            String fieldName = key.split("\\$field\\$\\.")[1].replaceAll("\\\\", "");
            Map fieldAnnotation = (Map)annotations.get((Object)annotationKey);
            for (BString fieldAnnotationKey : fieldAnnotation.keySet()) {
                String fieldAnnotationKeyStr = fieldAnnotationKey.getValue();
                if (!fieldAnnotationKeyStr.startsWith("ballerina/data.xmldata") || !fieldAnnotationKeyStr.endsWith("Sequence")) continue;
                fieldNamesWithModelGroupAnnotations.add(fieldName);
            }
        }
        return fieldNamesWithModelGroupAnnotations;
    }

    public static HashMap<FieldAnnotationValue, String> getElementNameMap(Type type) {
        HashMap<FieldAnnotationValue, String> names = new HashMap<FieldAnnotationValue, String>();
        if (type instanceof RecordType) {
            RecordType recordType = (RecordType)type;
            BMap annotations = recordType.getAnnotations();
            for (BString annotationKey : (BString[])annotations.getKeys()) {
                String key = annotationKey.getValue();
                if (!key.contains("$field$.")) continue;
                String fieldName = key.split("\\$field\\$\\.")[1].replaceAll("\\\\", "");
                Map fieldAnnotation = (Map)annotations.get((Object)annotationKey);
                String xmlElementName = null;
                String xmlElementNamespaceUri = null;
                for (BString fieldAnnotationKey : fieldAnnotation.keySet()) {
                    BMap fieldAnnotationValue;
                    String fieldAnnotationKeyStr = fieldAnnotationKey.getValue();
                    if (!fieldAnnotationKeyStr.startsWith("ballerina/data.xmldata")) continue;
                    if (fieldAnnotationKeyStr.endsWith("Name")) {
                        fieldAnnotationValue = (BMap)fieldAnnotation.get(fieldAnnotationKey);
                        xmlElementName = StringUtils.getStringValue((Object)fieldAnnotationValue.getStringValue(Constants.VALUE));
                    }
                    if (!fieldAnnotationKeyStr.endsWith("Namespace")) continue;
                    fieldAnnotationValue = (BMap)fieldAnnotation.get(fieldAnnotationKey);
                    xmlElementNamespaceUri = StringUtils.getStringValue((Object)fieldAnnotationValue.getStringValue(Constants.URI));
                }
                names.put(new FieldAnnotationValue(xmlElementName, xmlElementNamespaceUri), fieldName);
            }
            return names;
        }
        return names;
    }

    public static class XmlAnalyzerData
    extends XmlAnalyzerMetaData {
        public static XmlAnalyzerData copy(XmlAnalyzerData analyzerData) {
            XmlAnalyzerData data = new XmlAnalyzerData();
            data.nodesStack = (Stack)analyzerData.nodesStack.clone();
            data.fieldHierarchy = (Stack)analyzerData.fieldHierarchy.clone();
            data.visitedFieldHierarchy = (Stack)analyzerData.visitedFieldHierarchy.clone();
            data.attributeHierarchy = (Stack)analyzerData.attributeHierarchy.clone();
            data.restTypes = (Stack)analyzerData.restTypes.clone();
            data.arrayIndexes = (Stack)analyzerData.arrayIndexes.clone();
            data.rootRecord = analyzerData.rootRecord;
            data.currentField = analyzerData.currentField;
            data.attributePrefix = analyzerData.attributePrefix;
            data.textFieldName = analyzerData.textFieldName;
            data.allowDataProjection = analyzerData.allowDataProjection;
            data.useSemanticEquality = analyzerData.useSemanticEquality;
            data.xmlElementInfo = (Stack)analyzerData.xmlElementInfo.clone();
            data.xsdModelGroupInfo = (Stack)analyzerData.xsdModelGroupInfo.clone();
            data.modelGroupStack = (Stack)analyzerData.modelGroupStack.clone();
            return data;
        }

        public void resetFrom(XmlAnalyzerData analyzerData) {
            this.nodesStack = analyzerData.nodesStack;
            this.fieldHierarchy = analyzerData.fieldHierarchy;
            this.visitedFieldHierarchy = analyzerData.visitedFieldHierarchy;
            this.attributeHierarchy = analyzerData.attributeHierarchy;
            this.restTypes = analyzerData.restTypes;
            this.arrayIndexes = analyzerData.arrayIndexes;
            this.rootRecord = analyzerData.rootRecord;
            this.currentField = analyzerData.currentField;
            this.attributePrefix = analyzerData.attributePrefix;
            this.textFieldName = analyzerData.textFieldName;
            this.allowDataProjection = analyzerData.allowDataProjection;
            this.useSemanticEquality = analyzerData.useSemanticEquality;
            this.xmlElementInfo = analyzerData.xmlElementInfo;
            this.xsdModelGroupInfo = analyzerData.xsdModelGroupInfo;
            this.modelGroupStack = analyzerData.modelGroupStack;
        }
    }

    public static class XmlAnalyzerMetaData {
        public Stack<QualifiedNameMap<Field>> attributeHierarchy = new Stack();
        public Stack<HashMap<String, Integer>> arrayIndexes = new Stack();
        public Stack<HashMap<String, ElementInfo>> xmlElementInfo = new Stack();
        public Stack<HashMap<String, ModelGroupInfo>> xsdModelGroupInfo = new Stack();
        public Stack<ModelGroupInfo> modelGroupStack = new Stack();
        public Stack<Object> nodesStack = new Stack();
        public Stack<QualifiedNameMap<Field>> fieldHierarchy = new Stack();
        public Stack<QualifiedNameMap<Field>> visitedFieldHierarchy = new Stack();
        public Stack<Type> restTypes = new Stack();
        public RecordType rootRecord;
        public Field currentField;
        public boolean allowDataProjection;
        public boolean useSemanticEquality;
        public String attributePrefix;
        public String textFieldName;
        public BMap<BString, Object> currentNode;
        public final Stack<RecordType> recordTypeStack = new Stack();
    }

    record FieldAnnotationValue(String elementName, String namespaceUri) {
    }

    public static class XmlParserData
    extends XmlAnalyzerMetaData {
        public final Stack<QualifiedName> restFieldsPoints = new Stack();
        public final Stack<QualifiedNameMap<Boolean>> parents = new Stack();
        public QualifiedNameMap<Boolean> siblings = new QualifiedNameMap(new LinkedHashMap());
    }
}

