/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.lib.data.xmldata.xml.xsd;

import io.ballerina.lib.data.xmldata.utils.Constants;
import io.ballerina.lib.data.xmldata.utils.DataUtils;
import io.ballerina.lib.data.xmldata.utils.DiagnosticErrorCode;
import io.ballerina.lib.data.xmldata.utils.DiagnosticLog;
import io.ballerina.lib.data.xmldata.xml.xsd.ElementInfo;
import io.ballerina.lib.data.xmldata.xml.xsd.ModelGroupInfo;
import io.ballerina.runtime.api.types.RecordType;
import io.ballerina.runtime.api.values.BMap;
import io.ballerina.runtime.api.values.BString;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Stack;

public class ChoiceInfo
implements ModelGroupInfo {
    private final Stack<HashMap<String, ElementInfo>> xmlElementInfo;
    private final Map<String, Integer> remainingElementCount = new HashMap<String, Integer>();
    private final Map<String, Integer> minimumElementCount = new HashMap<String, Integer>();
    private final Map<String, Integer> maxElementCount = new HashMap<String, Integer>();
    private final Map<String, Boolean> elementOptionality = new HashMap<String, Boolean>();
    public String fieldName;
    public long minOccurs;
    public long maxOccurs;
    public int occurrences;
    String lastElement = "";
    public final Set<String> allElements = new HashSet<String>();
    public final Set<String> visitedElements = new HashSet<String>();
    public final Set<String> containElements = new HashSet<String>();
    private final HashMap<String, String> xmlElementNameMap;
    private boolean isMiddleOfElement = false;

    public ChoiceInfo(String fieldName, BMap<BString, Object> element, RecordType fieldType, Stack<HashMap<String, ElementInfo>> xmlElementInfo) {
        this.fieldName = fieldName;
        this.minOccurs = element.containsKey((Object)Constants.MIN_OCCURS) ? element.getIntValue(Constants.MIN_OCCURS) : 1L;
        this.maxOccurs = element.containsKey((Object)Constants.MAX_OCCURS) ? element.getIntValue(Constants.MAX_OCCURS) : Math.max(this.minOccurs, 1L);
        this.occurrences = 0;
        this.allElements.addAll(DataUtils.getXmlElementNames(fieldType));
        this.xmlElementNameMap = DataUtils.getXmlElementNameMap(fieldType);
        this.reOrderElementNamesBasedOnTheNameAnnotation();
        this.xmlElementInfo = xmlElementInfo;
    }

    public void updateOccurrences() {
        ++this.occurrences;
        if ((long)this.occurrences > this.maxOccurs) {
            throw DiagnosticLog.error(DiagnosticErrorCode.ELEMENT_OCCURS_MORE_THAN_MAX_ALLOWED_TIMES, this.fieldName);
        }
    }

    @Override
    public void validate() {
        this.generateElementOptionalityMapIfNotPresent();
        this.markOtherElementsAsOptional();
        this.reset();
    }

    private void markOtherElementsAsOptional() {
        if (!this.allElements.isEmpty()) {
            HashMap<String, ElementInfo> elementInfo = this.xmlElementInfo.peek();
            for (String element : this.allElements) {
                ElementInfo eleInfo;
                if (this.containElements.contains(element) || (eleInfo = elementInfo.get(element)) == null) continue;
                eleInfo.isInsideChoice = true;
            }
        }
    }

    private void reset() {
        this.visitedElements.clear();
        this.isMiddleOfElement = false;
        this.remainingElementCount.putAll(this.maxElementCount);
        this.lastElement = "";
        this.containElements.clear();
    }

    @Override
    public void visit(String element, boolean isStartElement) {
        this.generateElementOptionalityMapIfNotPresent();
        if (this.isMiddleOfElement && isStartElement) {
            return;
        }
        this.isMiddleOfElement = isStartElement;
        if (isStartElement) {
            return;
        }
        this.remainingElementCount.put(element, this.remainingElementCount.get(element) - 1);
        this.containElements.add(element);
        if (this.visitedElements.contains(element)) {
            if (this.remainingElementCount.get(element) == 0) {
                this.remainingElementCount.putAll(this.maxElementCount);
                this.visitedElements.remove(element);
            }
            return;
        }
        if (this.allElements.contains(element)) {
            int count = this.maxElementCount.get(element) - this.remainingElementCount.get(element);
            if (count >= this.minimumElementCount.get(element)) {
                this.visitedElements.add(element);
                this.updateOccurrences();
            }
            if (this.remainingElementCount.get(element) == 0) {
                this.remainingElementCount.putAll(this.maxElementCount);
                this.visitedElements.remove(element);
            }
            return;
        }
        throw DiagnosticLog.error(DiagnosticErrorCode.INVALID_ELEMENT_FOUND, this.xmlElementNameMap.get(element), this.fieldName);
    }

    @Override
    public boolean isElementContains(String elementName) {
        return this.allElements.contains(elementName);
    }

    @Override
    public boolean isMiddleOfModelGroup() {
        return this.isMiddleOfElement;
    }

    @Override
    public boolean predictStartNewModelGroup(String element) {
        this.generateElementOptionalityMapIfNotPresent();
        return !this.isMiddleOfElement && !this.isElementContains(element);
    }

    @Override
    public void validateMinOccurrences() {
        if ((long)this.occurrences < this.minOccurs) {
            throw DiagnosticLog.error(DiagnosticErrorCode.ELEMENT_OCCURS_LESS_THAN_MIN_REQUIRED_TIMES, this.fieldName);
        }
    }

    private void generateElementOptionalityMapIfNotPresent() {
        if (this.elementOptionality.isEmpty()) {
            if (!this.xmlElementInfo.isEmpty()) {
                this.allElements.forEach(element -> {
                    HashMap<String, ElementInfo> elementInfo = this.xmlElementInfo.peek();
                    if (elementInfo.containsKey(element)) {
                        ElementInfo info = elementInfo.get(element);
                        this.elementOptionality.put((String)element, info.minOccurs == 0L);
                        this.remainingElementCount.put((String)element, (int)info.maxOccurs);
                        this.maxElementCount.put((String)element, (int)info.maxOccurs);
                        this.minimumElementCount.put((String)element, (int)info.minOccurs);
                    } else {
                        this.elementOptionality.put((String)element, false);
                        this.remainingElementCount.put((String)element, 1);
                        this.maxElementCount.put((String)element, 1);
                        this.minimumElementCount.put((String)element, 1);
                    }
                });
            } else {
                this.allElements.forEach(element -> {
                    this.elementOptionality.put((String)element, false);
                    this.remainingElementCount.put((String)element, 1);
                    this.maxElementCount.put((String)element, 1);
                    this.minimumElementCount.put((String)element, 1);
                });
            }
        }
    }

    private void reOrderElementNamesBasedOnTheNameAnnotation() {
        this.allElements.forEach(element -> {
            if (!this.xmlElementNameMap.containsKey(element)) {
                this.xmlElementNameMap.put((String)element, (String)element);
            }
        });
    }

    @Override
    public long getMinOccurs() {
        return this.minOccurs;
    }

    @Override
    public long getMaxOccurs() {
        return this.maxOccurs;
    }

    @Override
    public String getFieldName() {
        return this.fieldName;
    }
}

