/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.io.channels.base;

import io.ballerina.stdlib.io.channels.base.Channel;
import io.ballerina.stdlib.io.channels.base.CharacterChannel;
import io.ballerina.stdlib.io.channels.base.IOChannel;
import io.ballerina.stdlib.io.csv.Format;
import io.ballerina.stdlib.io.utils.BallerinaIOException;
import java.io.IOException;
import java.util.regex.Pattern;

public class DelimitedRecordChannel
implements IOChannel {
    private String recordSeparator;
    private String fieldSeparator;
    private StringBuilder persistentCharSequence;
    private int recordCharacterCount = 100;
    private CharacterChannel channel;
    private boolean remaining = true;
    private int numberOfRecordsReadThroughChannel = 0;
    private int numberOfRecordsWrittenToChannel = 0;
    private Format format;
    private static final String DOUBLE_QUOTE_REGEX = "\"([^\"]*)\"";

    public DelimitedRecordChannel(CharacterChannel channel, Format format) {
        this.channel = channel;
        this.format = format;
        this.persistentCharSequence = new StringBuilder();
    }

    public DelimitedRecordChannel(CharacterChannel channel, String recordSeparator, String fieldSeparator) {
        this.recordSeparator = recordSeparator;
        this.fieldSeparator = fieldSeparator;
        this.channel = channel;
        this.persistentCharSequence = new StringBuilder();
    }

    @Override
    public boolean hasReachedEnd() {
        return !this.remaining && this.channel.hasReachedEnd();
    }

    @Override
    public Channel getChannel() {
        return this.channel.getChannel();
    }

    private String getRecordSeparatorForReading() {
        if (null == this.format) {
            return this.recordSeparator;
        }
        return this.format.getReadRecSeparator();
    }

    private String getFieldSeparatorForReading() {
        if (null == this.format) {
            return this.fieldSeparator;
        }
        return this.format.getReadFieldSeparator();
    }

    private String getRecordSeparatorForWriting() {
        if (null == this.format) {
            return this.recordSeparator;
        }
        return this.format.getWriteRecSeparator();
    }

    private String getFieldSeparatorForWriting() {
        if (null == this.format) {
            return this.fieldSeparator;
        }
        return this.format.getWriteFieldSeparator();
    }

    private String readRecord() throws BallerinaIOException {
        String record = null;
        boolean minimumRecordCount = true;
        int numberOfSplits = 2;
        do {
            String[] delimitedRecord;
            if ((delimitedRecord = this.persistentCharSequence.toString().split(this.getRecordSeparatorForReading(), 2)).length > 1) {
                record = this.processIdentifiedRecord(delimitedRecord);
                int recordCharacterLength = record.length();
                if (recordCharacterLength <= this.recordCharacterCount) continue;
                this.recordCharacterCount = record.length();
                continue;
            }
            this.readRecordFromChannel();
            if (!this.channel.hasReachedEnd()) continue;
            delimitedRecord = this.persistentCharSequence.toString().split(this.getRecordSeparatorForReading(), 2);
            String string = record = delimitedRecord.length == 2 ? this.processIdentifiedRecord(delimitedRecord) : this.readFinalRecord();
        } while (record == null && !this.channel.hasReachedEnd());
        if (null == record) {
            record = this.readFinalRecord();
        }
        return record;
    }

    private String readFinalRecord() {
        boolean minimumRemainingLength = false;
        String record = "";
        this.remaining = false;
        if (this.persistentCharSequence.length() > 0) {
            record = this.persistentCharSequence.toString();
            this.persistentCharSequence.setLength(0);
        }
        return record;
    }

    private String readRecordFromChannel() throws BallerinaIOException {
        String readCharacters = this.channel.read(this.recordCharacterCount);
        this.persistentCharSequence.append(readCharacters);
        return readCharacters;
    }

    private String processIdentifiedRecord(String[] delimitedRecords) {
        boolean minimumRemainingLength = false;
        boolean delimitedRecordIndex = false;
        boolean delimitedRemainingIndex = true;
        String recordContent = delimitedRecords[1];
        String record = delimitedRecords[0];
        this.persistentCharSequence.setLength(0);
        this.persistentCharSequence.append(recordContent);
        return record;
    }

    private String[] splitIgnoreBlanks(String record, String regex) {
        Pattern reg = Pattern.compile(regex);
        String[] split = reg.split(record);
        for (int i = 0; i < split.length; ++i) {
            String field = split[i];
            if (field.isEmpty()) {
                split[i] = "";
                continue;
            }
            if (!field.matches(DOUBLE_QUOTE_REGEX)) continue;
            split[i] = field.substring(field.indexOf(34) + 1, field.lastIndexOf(34));
        }
        return split;
    }

    public String[] getFields(String record) {
        String fieldSeparatorForReading = this.getFieldSeparatorForReading();
        if (null != this.format && this.format.shouldIgnoreBlanks()) {
            return this.splitIgnoreBlanks(record, fieldSeparatorForReading);
        }
        return record.split(fieldSeparatorForReading);
    }

    public String[] read() throws BallerinaIOException {
        String record;
        boolean emptyArrayIndex = false;
        String[] fields = new String[]{};
        if (this.remaining && (!(record = this.readRecord()).isEmpty() || this.remaining)) {
            fields = this.getFields(record);
            ++this.numberOfRecordsReadThroughChannel;
        }
        return fields;
    }

    private String encloseField(String field) {
        return "\"" + field + "\"";
    }

    private String composeRecord(String[] fields) {
        StringBuilder recordConsolidator = new StringBuilder();
        long numberOfFields = fields.length;
        boolean fieldStartIndex = false;
        long secondLastFieldIndex = numberOfFields - 1L;
        int fieldCount = 0;
        while ((long)fieldCount < numberOfFields) {
            String currentFieldString = fields[fieldCount];
            if (currentFieldString.contains(this.getFieldSeparatorForWriting())) {
                currentFieldString = this.encloseField(currentFieldString);
            }
            recordConsolidator.append(currentFieldString);
            if ((long)fieldCount < secondLastFieldIndex) {
                recordConsolidator.append(this.getFieldSeparatorForWriting());
            }
            ++fieldCount;
        }
        String finalizedRecord = recordConsolidator.toString();
        return finalizedRecord;
    }

    public void write(String[] fields) throws IOException {
        boolean writeOffset = false;
        Object record = this.composeRecord(fields);
        record = (String)record + this.getRecordSeparatorForWriting();
        this.channel.write((String)record, 0);
        ++this.numberOfRecordsWrittenToChannel;
    }

    @Override
    public int id() {
        return this.channel.id();
    }

    @Override
    public void close() throws IOException {
        this.channel.close();
    }

    @Override
    public boolean remaining() {
        return this.persistentCharSequence.length() > 0;
    }

    public boolean hasNext() throws BallerinaIOException {
        String readChars;
        if (this.remaining && this.persistentCharSequence.length() == 0 && (readChars = this.readRecordFromChannel()).isEmpty()) {
            this.remaining = false;
        }
        return this.remaining;
    }
}

