/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.io.nativeimpl;

import io.ballerina.runtime.api.Module;
import io.ballerina.runtime.api.creators.TypeCreator;
import io.ballerina.runtime.api.creators.ValueCreator;
import io.ballerina.runtime.api.flags.SymbolFlags;
import io.ballerina.runtime.api.types.ArrayType;
import io.ballerina.runtime.api.types.Field;
import io.ballerina.runtime.api.types.StructureType;
import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.api.utils.StringUtils;
import io.ballerina.runtime.api.utils.TypeUtils;
import io.ballerina.runtime.api.values.BArray;
import io.ballerina.runtime.api.values.BError;
import io.ballerina.runtime.api.values.BMap;
import io.ballerina.runtime.api.values.BObject;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.runtime.api.values.BTypedesc;
import io.ballerina.stdlib.io.channels.base.CharacterChannel;
import io.ballerina.stdlib.io.channels.base.DelimitedRecordChannel;
import io.ballerina.stdlib.io.csv.Format;
import io.ballerina.stdlib.io.nativeimpl.CsvChannelUtils;
import io.ballerina.stdlib.io.readers.CharacterChannelReader;
import io.ballerina.stdlib.io.utils.BallerinaIOException;
import io.ballerina.stdlib.io.utils.IOUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.nio.channels.ClosedChannelException;
import java.util.ArrayList;
import java.util.Map;

public class RecordChannelUtils {
    private static final String DEFAULT = "default";
    private static final String BUFFERED_READER_ENTRY = "bufferedReader";
    private static final String IS_CLOSED = "isClosed";

    private RecordChannelUtils() {
    }

    public static void initRecordChannel(BObject textRecordChannel, BObject characterChannelInfo, BString fieldSeparator, BString recordSeparator, BString format) {
        try {
            CharacterChannel characterChannel = (CharacterChannel)characterChannelInfo.getNativeData("char_channel");
            BufferedReader bufferedReader = new BufferedReader(new CharacterChannelReader(characterChannel));
            DelimitedRecordChannel delimitedRecordChannel = DEFAULT.equals(format.getValue()) ? new DelimitedRecordChannel(characterChannel, recordSeparator.getValue(), fieldSeparator.getValue()) : new DelimitedRecordChannel(characterChannel, Format.valueOf(format.getValue()));
            textRecordChannel.addNativeData("txt_record", (Object)delimitedRecordChannel);
            textRecordChannel.addNativeData(BUFFERED_READER_ENTRY, (Object)bufferedReader);
            textRecordChannel.addNativeData(IS_CLOSED, (Object)false);
        }
        catch (Exception e) {
            String message = "error occurred while converting character channel to textRecord channel: " + e.getMessage();
            throw IOUtils.createError(message);
        }
    }

    public static boolean hasNext(BObject channel) {
        Object textChannel = channel.getNativeData("txt_record");
        if (textChannel == null) {
            return false;
        }
        DelimitedRecordChannel textRecordChannel = (DelimitedRecordChannel)textChannel;
        if (!textRecordChannel.hasReachedEnd()) {
            try {
                return textRecordChannel.hasNext();
            }
            catch (BallerinaIOException e) {
                String msg = "error occurred while checking hasNext on ReadableTextRecordChannel: " + e.getMessage();
                throw IOUtils.createError(msg);
            }
        }
        return false;
    }

    public static Object getNext(BObject channel) {
        if (RecordChannelUtils.isChannelClosed(channel)) {
            return IOUtils.createError("Record channel is already closed.");
        }
        DelimitedRecordChannel textRecordChannel = (DelimitedRecordChannel)channel.getNativeData("txt_record");
        if (textRecordChannel.hasReachedEnd()) {
            return IOUtils.createEoFError();
        }
        try {
            String[] records = textRecordChannel.read();
            return StringUtils.fromStringArray((String[])records);
        }
        catch (BallerinaIOException e) {
            return IOUtils.createError(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object getAllRecords(BObject channel, int skipHeaders, BTypedesc typeDesc) {
        BError bError;
        Type describingType = TypeUtils.getReferredType((Type)typeDesc.getDescribingType());
        if (RecordChannelUtils.isChannelClosed(channel)) {
            return IOUtils.createError("Record channel is already closed.");
        }
        DelimitedRecordChannel textRecordChannel = (DelimitedRecordChannel)channel.getNativeData("txt_record");
        if (textRecordChannel.hasReachedEnd()) {
            return IOUtils.createEoFError();
        }
        try {
            if (describingType.getTag() == 24) {
                StructureType structType = (StructureType)describingType;
                ArrayList<BMap> outList = new ArrayList<BMap>();
                ArrayList<String> headerNames = new ArrayList<String>();
                while (textRecordChannel.hasNext()) {
                    String[] record;
                    if (headerNames.size() == 0) {
                        for (String header : record = textRecordChannel.read()) {
                            headerNames.add(header.trim());
                        }
                        RecordChannelUtils.validateHeaders(headerNames, structType);
                        continue;
                    }
                    record = textRecordChannel.read();
                    if (skipHeaders > 1) {
                        --skipHeaders;
                        continue;
                    }
                    Object returnStruct = CsvChannelUtils.getStruct(record, structType, headerNames);
                    if (returnStruct instanceof BError) {
                        Object object = returnStruct;
                        return object;
                    }
                    Map struct = (Map)returnStruct;
                    outList.add(ValueCreator.createRecordValue((Module)describingType.getPackage(), (String)describingType.getName(), (Map)struct));
                }
                Object[] out = outList.toArray();
                BArray bArray = ValueCreator.createArrayValue((Object[])out, (ArrayType)TypeCreator.createArrayType((Type)describingType));
                return bArray;
            }
            if (describingType.getTag() == 32) {
                ArrayList<BArray> outList = new ArrayList<BArray>();
                while (textRecordChannel.hasNext()) {
                    String[] record = textRecordChannel.read();
                    if (skipHeaders != 0) {
                        --skipHeaders;
                        continue;
                    }
                    outList.add(StringUtils.fromStringArray((String[])record));
                }
                Object[] out = outList.toArray();
                BArray bArray = ValueCreator.createArrayValue((Object[])out, (ArrayType)TypeCreator.createArrayType((Type)describingType));
                return bArray;
            }
            BError outList = IOUtils.createError(String.format("Only 'string[]' and 'record{}' types are supported, but found '%s' ", describingType.getName()));
            return outList;
        }
        catch (BallerinaIOException e) {
            bError = IOUtils.createError(e);
            return bError;
        }
        catch (BError e) {
            bError = e;
            return bError;
        }
        finally {
            RecordChannelUtils.close(channel);
        }
    }

    public static Object streamNext(BObject iterator) {
        BObject channel = (BObject)iterator.getNativeData("iterator_name");
        BufferedReader bufferedReader = (BufferedReader)channel.getNativeData(BUFFERED_READER_ENTRY);
        BTypedesc typeDesc = (BTypedesc)iterator.getNativeData("csv_return_type");
        Type describingType = TypeUtils.getReferredType((Type)typeDesc.getDescribingType());
        try {
            String line = bufferedReader.readLine();
            if (line == null) {
                bufferedReader.close();
                return IOUtils.createEoFError();
            }
            DelimitedRecordChannel textRecordChannel = (DelimitedRecordChannel)channel.getNativeData("txt_record");
            if (describingType.getTag() == 24) {
                ArrayList headerNames;
                Object returnStruct;
                StructureType structType = (StructureType)describingType;
                String[] record = textRecordChannel.getFields(line);
                if (!iterator.getNativeData().containsKey("header_names")) {
                    ArrayList<String> headers = new ArrayList<String>();
                    for (String header : record) {
                        headers.add(header.trim());
                    }
                    RecordChannelUtils.validateHeaders(headers, structType);
                    iterator.addNativeData("header_names", headers);
                    line = bufferedReader.readLine();
                    record = textRecordChannel.getFields(line);
                }
                if ((returnStruct = CsvChannelUtils.getStruct(record, structType, headerNames = (ArrayList)iterator.getNativeData("header_names"))) instanceof BError) {
                    return returnStruct;
                }
                Map struct = (Map)returnStruct;
                return ValueCreator.createRecordValue((Module)describingType.getPackage(), (String)describingType.getName(), (Map)struct);
            }
            String[] records = textRecordChannel.getFields(line);
            return StringUtils.fromStringArray((String[])records);
        }
        catch (IOException e) {
            return IOUtils.createError(e);
        }
    }

    public static Object readRecord(BObject channel) {
        BufferedReader bufferedReader = (BufferedReader)channel.getNativeData(BUFFERED_READER_ENTRY);
        try {
            String line = bufferedReader.readLine();
            if (line == null) {
                bufferedReader.close();
                return IOUtils.createEoFError();
            }
            DelimitedRecordChannel textRecordChannel = (DelimitedRecordChannel)channel.getNativeData("txt_record");
            String[] record = textRecordChannel.getFields(line);
            return StringUtils.fromStringArray((String[])record);
        }
        catch (IOException e) {
            return IOUtils.createError(e);
        }
    }

    public static Object write(BObject channel, BArray content) {
        if (RecordChannelUtils.isChannelClosed(channel)) {
            return IOUtils.createError("Record channel is already closed.");
        }
        DelimitedRecordChannel delimitedRecordChannel = (DelimitedRecordChannel)channel.getNativeData("txt_record");
        try {
            delimitedRecordChannel.write(content.getStringArray());
        }
        catch (IOException e) {
            return IOUtils.createError(e);
        }
        return null;
    }

    public static Object close(BObject channel) {
        if (RecordChannelUtils.isChannelClosed(channel)) {
            return IOUtils.createError("Record channel is already closed.");
        }
        DelimitedRecordChannel recordChannel = (DelimitedRecordChannel)channel.getNativeData("txt_record");
        try {
            BufferedReader bufferedReader = (BufferedReader)channel.getNativeData(BUFFERED_READER_ENTRY);
            bufferedReader.close();
            recordChannel.close();
            channel.addNativeData(IS_CLOSED, (Object)true);
        }
        catch (IOException e) {
            return IOUtils.createError(e);
        }
        return null;
    }

    private static boolean isChannelClosed(BObject channel) {
        if (channel.getNativeData(IS_CLOSED) != null) {
            return (Boolean)channel.getNativeData(IS_CLOSED);
        }
        return false;
    }

    public static Object closeBufferedReader(BObject channel) {
        try {
            BufferedReader bufferedReader = (BufferedReader)channel.getNativeData(BUFFERED_READER_ENTRY);
            bufferedReader.close();
        }
        catch (ClosedChannelException e) {
            return IOUtils.createError("Record channel is already closed.");
        }
        catch (IOException e) {
            return IOUtils.createError(e);
        }
        return null;
    }

    public static Object closeStream(BObject iterator) {
        BObject channel = (BObject)iterator.getNativeData("iterator_name");
        try {
            BufferedReader bufferedReader = (BufferedReader)channel.getNativeData(BUFFERED_READER_ENTRY);
            bufferedReader.close();
        }
        catch (ClosedChannelException e) {
            return IOUtils.createError("Record channel is already closed.");
        }
        catch (IOException e) {
            return IOUtils.createError(e);
        }
        return null;
    }

    private static void validateHeaders(ArrayList<String> headers, StructureType structType) {
        structType.getFields().forEach((key, value) -> {
            Field field = value;
            if (!headers.contains(field.getFieldName().trim()) && !SymbolFlags.isFlagOn((long)field.getFlags(), (long)4096L)) {
                throw IOUtils.createError(String.format("The csv file does not contain the column - %s.", field.getFieldName().trim()));
            }
        });
        headers.forEach(header -> {
            if (structType.getFields().get(header) == null) {
                throw IOUtils.createError(String.format("The csv file contains an additional column - %s.", header));
            }
        });
    }
}

