/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.io.readers;

import io.ballerina.stdlib.io.channels.base.CharacterChannel;
import io.ballerina.stdlib.io.utils.BallerinaIOException;
import java.io.IOException;
import java.io.Reader;

public class CharacterChannelReader
extends Reader {
    private CharacterChannel channel;

    public CharacterChannelReader(CharacterChannel channel) {
        this.channel = channel;
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        if (!this.channel.hasReachedEnd()) {
            try {
                String content = this.channel.read(len);
                if (!content.isEmpty()) {
                    char[] chars = content.toCharArray();
                    System.arraycopy(chars, 0, cbuf, off, chars.length);
                    return chars.length;
                }
            }
            catch (BallerinaIOException e) {
                throw new IOException(e);
            }
        }
        return -1;
    }

    @Override
    public void close() throws IOException {
        this.channel.close();
    }
}

