/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.io.utils;

import io.ballerina.runtime.api.Module;
import io.ballerina.runtime.api.creators.ErrorCreator;
import io.ballerina.runtime.api.utils.StringUtils;
import io.ballerina.runtime.api.values.BError;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.stdlib.io.channels.base.Channel;
import io.ballerina.stdlib.io.channels.base.CharacterChannel;
import io.ballerina.stdlib.io.nativeimpl.ModuleUtils;
import io.ballerina.stdlib.io.utils.BallerinaIOException;
import io.ballerina.stdlib.io.utils.IOConstants;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.nio.file.AccessDeniedException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.HashSet;

public class IOUtils {
    private IOUtils() {
    }

    public static BError createError(String errorMsg) {
        return IOUtils.createError(IOConstants.ErrorCode.GenericError, errorMsg);
    }

    public static BError createError(Throwable error) {
        return IOUtils.createError(error.getMessage());
    }

    public static BError createError(IOConstants.ErrorCode errorId, String errorMsg) {
        return ErrorCreator.createError((Module)ModuleUtils.getModule(), (String)errorId.errorCode(), (BString)StringUtils.fromString((String)errorMsg), null, null);
    }

    public static BError createEoFError() {
        return IOUtils.createError(IOConstants.ErrorCode.EoF, "EoF when reading from the channel");
    }

    public static int writeFull(Channel channel, byte[] content, int offset) throws IOException {
        while ((offset += IOUtils.write(channel, content, offset)) < content.length) {
        }
        return offset;
    }

    private static int write(Channel channel, byte[] content, int offset) throws IOException {
        ByteBuffer writeBuffer = ByteBuffer.wrap(content);
        writeBuffer.position(offset);
        int write = channel.write(writeBuffer);
        return offset += write;
    }

    public static void writeFull(CharacterChannel characterChannel, String payload) throws BallerinaIOException {
        try {
            int numberOfCharsWritten;
            int totalNumberOfCharsWritten = 0;
            int lengthOfPayload = payload.getBytes(Charset.forName(characterChannel.getEncoding())).length;
            while ((totalNumberOfCharsWritten += (numberOfCharsWritten = characterChannel.write(payload, 0))) != lengthOfPayload && numberOfCharsWritten != 0) {
            }
            if (totalNumberOfCharsWritten != lengthOfPayload) {
                String message = String.format("JSON payload was partially written expected: %d, written : %d", lengthOfPayload, totalNumberOfCharsWritten);
                throw new BallerinaIOException(message);
            }
        }
        catch (ClosedChannelException e) {
            throw new BallerinaIOException("writable channel is already closed", e);
        }
        catch (IOException e) {
            throw new BallerinaIOException("unable to write the content fully", e);
        }
    }

    public static int readFull(Channel channel, byte[] content) throws IOException, BError {
        int numberOfBytesToRead = content.length;
        int nBytesRead = 0;
        while ((nBytesRead += IOUtils.read(channel, content)) < numberOfBytesToRead && !channel.hasReachedEnd()) {
        }
        return nBytesRead;
    }

    private static int read(Channel channel, byte[] content) throws IOException, BError {
        if (channel.hasReachedEnd()) {
            throw IOUtils.createEoFError();
        }
        return channel.read(ByteBuffer.wrap(content));
    }

    private static void createDirsExtended(Path path) throws IOException {
        Path parent = path.getParent();
        if (parent != null && !parent.toFile().exists()) {
            Files.createDirectories(parent, new FileAttribute[0]);
        }
    }

    public static FileChannel openFileChannelExtended(Path path, IOConstants.FileOpenOption option) throws BallerinaIOException {
        HashSet<StandardOpenOption> opts = new HashSet<StandardOpenOption>();
        if (option.equals((Object)IOConstants.FileOpenOption.READ)) {
            if (!path.toFile().exists()) {
                String msg = "no such file or directory: " + path.toFile().getAbsolutePath();
                throw IOUtils.createError(IOConstants.ErrorCode.FileNotFoundError, msg);
            }
            if (!Files.isReadable(path)) {
                throw new BallerinaIOException("file is not readable: " + String.valueOf(path));
            }
            opts.add(StandardOpenOption.READ);
        }
        boolean write = option.equals((Object)IOConstants.FileOpenOption.OVERWRITE);
        boolean append = option.equals((Object)IOConstants.FileOpenOption.APPEND);
        try {
            if (write || append) {
                if (path.toFile().exists() && !Files.isWritable(path)) {
                    throw new BallerinaIOException("file is not writable: " + String.valueOf(path));
                }
                IOUtils.createDirsExtended(path);
                opts.add(StandardOpenOption.CREATE);
                if (append) {
                    opts.add(StandardOpenOption.APPEND);
                } else {
                    opts.add(StandardOpenOption.WRITE);
                    opts.add(StandardOpenOption.TRUNCATE_EXISTING);
                }
            }
            return FileChannel.open(path, opts, new FileAttribute[0]);
        }
        catch (AccessDeniedException e) {
            String msg = "do not have necessary permissions to access: " + e.getMessage();
            throw IOUtils.createError(IOConstants.ErrorCode.AccessDeniedError, msg);
        }
        catch (IOException | UnsupportedOperationException e) {
            throw new BallerinaIOException("fail to open file: " + e.getMessage(), e);
        }
    }

    public static Module getIOPackage() {
        return ModuleUtils.getModule();
    }
}

