/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.io.utils;

import io.ballerina.runtime.api.Module;
import io.ballerina.runtime.api.creators.ErrorCreator;
import io.ballerina.runtime.api.creators.ValueCreator;
import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.api.utils.StringUtils;
import io.ballerina.runtime.api.utils.TypeUtils;
import io.ballerina.runtime.api.values.BArray;
import io.ballerina.runtime.api.values.BError;
import io.ballerina.runtime.api.values.BObject;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.stdlib.io.channels.base.Channel;
import io.ballerina.stdlib.io.utils.Base64ByteChannel;
import io.ballerina.stdlib.io.utils.Base64Wrapper;
import io.ballerina.stdlib.io.utils.IOConstants;
import io.ballerina.stdlib.io.utils.IOUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.util.Base64;

public class Utils {
    private static final int READABLE_BUFFER_SIZE = 8192;
    private static final Module PACKAGE_ID_MIME = new Module("ballerina", "mime", "1.0.0");
    private static final String STRUCT_TYPE = "ReadableByteChannel";
    private static final String ENCODING_ERROR = "EncodeError";
    private static final String DECODING_ERROR = "DecodeError";

    private Utils() {
    }

    private static BError createBase64Error(String errorType, String msg, boolean isMimeSpecific) {
        if (isMimeSpecific) {
            return ErrorCreator.createDistinctError((String)errorType, (Module)PACKAGE_ID_MIME, (BString)StringUtils.fromString((String)msg));
        }
        return IOUtils.createError(IOConstants.ErrorCode.GenericError, msg);
    }

    private static byte[] getByteArray(InputStream input) throws IOException {
        try (ByteArrayOutputStream output = new ByteArrayOutputStream();){
            int len;
            byte[] buffer = new byte[8192];
            while ((len = input.read(buffer)) != -1) {
                output.write(buffer, 0, len);
            }
            byte[] byArray = output.toByteArray();
            return byArray;
        }
    }

    public static Object encode(Object input, String charset, boolean isMimeSpecific) {
        switch (TypeUtils.getReferredType((Type)TypeUtils.getType((Object)input)).getTag()) {
            case 32: {
                return Utils.encodeBlob(((BArray)input).getBytes(), isMimeSpecific);
            }
            case 24: 
            case 47: {
                BObject byteChannel = (BObject)input;
                if (STRUCT_TYPE.equals(TypeUtils.getType((Object)byteChannel).getName())) {
                    return Utils.encodeByteChannel(byteChannel, isMimeSpecific);
                }
                return Utils.createBase64Error(ENCODING_ERROR, "incompatible object", isMimeSpecific);
            }
            case 5: {
                return Utils.encodeString(input.toString(), charset, isMimeSpecific);
            }
        }
        return Utils.createBase64Error(ENCODING_ERROR, "incompatible input", isMimeSpecific);
    }

    public static Object decode(Object encodedInput, String charset, boolean isMimeSpecific) {
        switch (TypeUtils.getType((Object)encodedInput).getTag()) {
            case 32: {
                return Utils.decodeBlob(((BArray)encodedInput).getBytes(), isMimeSpecific);
            }
            case 24: 
            case 47: {
                return Utils.decodeByteChannel((BObject)encodedInput, isMimeSpecific);
            }
            case 5: {
                return Utils.decodeString(encodedInput, charset, isMimeSpecific);
            }
        }
        return Utils.createBase64Error(DECODING_ERROR, "incompatible input", isMimeSpecific);
    }

    public static Object encodeString(String stringToBeEncoded, String charset, boolean isMimeSpecific) {
        try {
            byte[] encodedValue = isMimeSpecific ? Base64.getMimeEncoder().encode(stringToBeEncoded.getBytes(charset)) : Base64.getEncoder().encode(stringToBeEncoded.getBytes(charset));
            return StringUtils.fromString((String)new String(encodedValue, StandardCharsets.ISO_8859_1));
        }
        catch (UnsupportedEncodingException e) {
            return Utils.createBase64Error(DECODING_ERROR, e.getMessage(), isMimeSpecific);
        }
    }

    private static Object decodeString(Object stringToBeDecoded, String charset, boolean isMimeSpecific) {
        try {
            byte[] decodedValue = isMimeSpecific ? Base64.getMimeDecoder().decode(stringToBeDecoded.toString().getBytes(StandardCharsets.ISO_8859_1)) : Base64.getDecoder().decode(stringToBeDecoded.toString().getBytes(StandardCharsets.ISO_8859_1));
            return StringUtils.fromString((String)new String(decodedValue, charset));
        }
        catch (UnsupportedEncodingException e) {
            return Utils.createBase64Error(DECODING_ERROR, e.getMessage(), isMimeSpecific);
        }
    }

    public static Object encodeByteChannel(BObject byteChannel, boolean isMimeSpecific) {
        Channel channel = (Channel)byteChannel.getNativeData("byteChannel");
        try {
            byte[] encodedByteArray = isMimeSpecific ? Base64.getMimeEncoder().encode(Utils.getByteArray(channel.getInputStream())) : Base64.getEncoder().encode(Utils.getByteArray(channel.getInputStream()));
            ByteArrayInputStream encodedStream = new ByteArrayInputStream(encodedByteArray);
            Base64ByteChannel decodedByteChannel = new Base64ByteChannel(encodedStream);
            BObject byteChannelObj = ValueCreator.createObjectValue((Module)IOUtils.getIOPackage(), (String)STRUCT_TYPE, (Object[])new Object[0]);
            byteChannelObj.addNativeData("byteChannel", (Object)new Base64Wrapper(decodedByteChannel));
            return byteChannelObj;
        }
        catch (IOException e) {
            return Utils.createBase64Error(ENCODING_ERROR, e.getMessage(), isMimeSpecific);
        }
    }

    public static Object decodeByteChannel(BObject byteChannel, boolean isMimeSpecific) {
        Channel channel = (Channel)byteChannel.getNativeData("byteChannel");
        try {
            byte[] decodedByteArray = isMimeSpecific ? Base64.getMimeDecoder().decode(Utils.getByteArray(channel.getInputStream())) : Base64.getDecoder().decode(Utils.getByteArray(channel.getInputStream()));
            ByteArrayInputStream decodedStream = new ByteArrayInputStream(decodedByteArray);
            Base64ByteChannel decodedByteChannel = new Base64ByteChannel(decodedStream);
            BObject byteChannelObj = ValueCreator.createObjectValue((Module)IOUtils.getIOPackage(), (String)STRUCT_TYPE, (Object[])new Object[0]);
            byteChannelObj.addNativeData("byteChannel", (Object)new Base64Wrapper(decodedByteChannel));
            return byteChannelObj;
        }
        catch (IOException e) {
            return Utils.createBase64Error(DECODING_ERROR, e.getMessage(), isMimeSpecific);
        }
    }

    public static BArray encodeBlob(byte[] bytes, boolean isMimeSpecific) {
        byte[] encodedContent = isMimeSpecific ? Base64.getMimeEncoder().encode(bytes) : Base64.getEncoder().encode(bytes);
        return ValueCreator.createArrayValue((byte[])encodedContent);
    }

    public static BArray decodeBlob(byte[] encodedContent, boolean isMimeSpecific) {
        byte[] decodedContent = isMimeSpecific ? Base64.getMimeDecoder().decode(encodedContent) : Base64.getDecoder().decode(encodedContent);
        return ValueCreator.createArrayValue((byte[])decodedContent);
    }
}

