/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.paho.mqttv5.client;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.util.Hashtable;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ScheduledExecutorService;
import org.eclipse.paho.mqttv5.client.DisconnectedBufferOptions;
import org.eclipse.paho.mqttv5.client.IMqttAsyncClient;
import org.eclipse.paho.mqttv5.client.IMqttMessageListener;
import org.eclipse.paho.mqttv5.client.IMqttToken;
import org.eclipse.paho.mqttv5.client.MqttActionListener;
import org.eclipse.paho.mqttv5.client.MqttCallback;
import org.eclipse.paho.mqttv5.client.MqttClientInterface;
import org.eclipse.paho.mqttv5.client.MqttClientPersistence;
import org.eclipse.paho.mqttv5.client.MqttConnectionOptions;
import org.eclipse.paho.mqttv5.client.MqttDisconnectResponse;
import org.eclipse.paho.mqttv5.client.MqttPingSender;
import org.eclipse.paho.mqttv5.client.MqttToken;
import org.eclipse.paho.mqttv5.client.MqttTopic;
import org.eclipse.paho.mqttv5.client.TimerPingSender;
import org.eclipse.paho.mqttv5.client.internal.ClientComms;
import org.eclipse.paho.mqttv5.client.internal.ConnectActionListener;
import org.eclipse.paho.mqttv5.client.internal.DisconnectedMessageBuffer;
import org.eclipse.paho.mqttv5.client.internal.MqttConnectionState;
import org.eclipse.paho.mqttv5.client.internal.MqttSessionState;
import org.eclipse.paho.mqttv5.client.internal.NetworkModule;
import org.eclipse.paho.mqttv5.client.internal.NetworkModuleService;
import org.eclipse.paho.mqttv5.client.logging.Logger;
import org.eclipse.paho.mqttv5.client.logging.LoggerFactory;
import org.eclipse.paho.mqttv5.client.persist.MemoryPersistence;
import org.eclipse.paho.mqttv5.client.persist.MqttDefaultFilePersistence;
import org.eclipse.paho.mqttv5.client.util.Debug;
import org.eclipse.paho.mqttv5.common.ExceptionHelper;
import org.eclipse.paho.mqttv5.common.MqttException;
import org.eclipse.paho.mqttv5.common.MqttMessage;
import org.eclipse.paho.mqttv5.common.MqttPersistenceException;
import org.eclipse.paho.mqttv5.common.MqttSecurityException;
import org.eclipse.paho.mqttv5.common.MqttSubscription;
import org.eclipse.paho.mqttv5.common.packet.MqttAuth;
import org.eclipse.paho.mqttv5.common.packet.MqttDataTypes;
import org.eclipse.paho.mqttv5.common.packet.MqttDisconnect;
import org.eclipse.paho.mqttv5.common.packet.MqttProperties;
import org.eclipse.paho.mqttv5.common.packet.MqttPublish;
import org.eclipse.paho.mqttv5.common.packet.MqttSubscribe;
import org.eclipse.paho.mqttv5.common.packet.MqttUnsubscribe;
import org.eclipse.paho.mqttv5.common.util.MqttTopicValidator;

public class MqttAsyncClient
implements MqttClientInterface,
IMqttAsyncClient {
    private static final String CLASS_NAME = MqttAsyncClient.class.getName();
    private Logger log = LoggerFactory.getLogger("org.eclipse.paho.mqttv5.client.internal.nls.logcat", CLASS_NAME);
    private static final long QUIESCE_TIMEOUT = 30000L;
    private static final long DISCONNECT_TIMEOUT = 10000L;
    private static final char MIN_HIGH_SURROGATE = '\ud800';
    private static final char MAX_HIGH_SURROGATE = '\udbff';
    private String serverURI;
    protected ClientComms comms;
    private Hashtable<String, MqttTopic> topics;
    private MqttClientPersistence persistence;
    private MqttCallback mqttCallback;
    private MqttConnectionOptions connOpts;
    private Object userContext;
    private Timer reconnectTimer;
    private static int reconnectDelay = 1000;
    private boolean reconnecting = false;
    private static final Object clientLock = new Object();
    private MqttSessionState mqttSession = new MqttSessionState();
    private MqttConnectionState mqttConnection;
    private ScheduledExecutorService executorService;
    private MqttPingSender pingSender;

    public MqttAsyncClient(String serverURI, String clientId) throws MqttException {
        this(serverURI, clientId, new MqttDefaultFilePersistence());
    }

    public MqttAsyncClient(String serverURI, String clientId, MqttClientPersistence persistence) throws MqttException {
        this(serverURI, clientId, persistence, null, null);
    }

    public MqttAsyncClient(String serverURI, String clientId, MqttClientPersistence persistence, MqttPingSender pingSender, ScheduledExecutorService executorService) throws MqttException {
        this.log.setResourceName(clientId);
        if (clientId != null) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            DataOutputStream dos = new DataOutputStream(baos);
            MqttDataTypes.encodeUTF8(dos, clientId);
            if (dos.size() - 2 > 65535) {
                throw new IllegalArgumentException("ClientId longer than 65535 characters");
            }
        } else {
            clientId = "";
        }
        this.mqttConnection = new MqttConnectionState(clientId);
        NetworkModuleService.validateURI(serverURI);
        this.serverURI = serverURI;
        this.mqttSession.setClientId(clientId);
        this.persistence = persistence;
        if (this.persistence == null) {
            this.persistence = new MemoryPersistence();
        }
        this.executorService = executorService;
        this.pingSender = pingSender;
        if (this.pingSender == null) {
            this.pingSender = new TimerPingSender(this.executorService);
        }
        this.log.fine(CLASS_NAME, "MqttAsyncClient", "101", new Object[]{clientId, serverURI, persistence});
        this.persistence.open(clientId);
        this.comms = new ClientComms(this, this.persistence, this.pingSender, this.executorService, this.mqttSession, this.mqttConnection);
        this.persistence.close();
        this.topics = new Hashtable();
    }

    protected static boolean Character_isHighSurrogate(char ch) {
        return ch >= '\ud800' && ch <= '\udbff';
    }

    protected NetworkModule[] createNetworkModules(String address, MqttConnectionOptions options) throws MqttException, MqttSecurityException {
        this.log.fine(CLASS_NAME, "createNetworkModules", "116", new Object[]{address});
        NetworkModule[] networkModules = null;
        String[] serverURIs = options.getServerURIs();
        String[] array = null;
        array = serverURIs == null ? new String[]{address} : (serverURIs.length == 0 ? new String[]{address} : serverURIs);
        networkModules = new NetworkModule[array.length];
        int i = 0;
        while (i < array.length) {
            networkModules[i] = this.createNetworkModule(array[i], options);
            ++i;
        }
        this.log.fine(CLASS_NAME, "createNetworkModules", "108");
        return networkModules;
    }

    private NetworkModule createNetworkModule(String address, MqttConnectionOptions options) throws MqttException, MqttSecurityException {
        this.log.fine(CLASS_NAME, "createNetworkModule", "115", new Object[]{address});
        NetworkModule netModule = NetworkModuleService.createInstance(address, options, this.mqttSession.getClientId());
        return netModule;
    }

    private String getHostName(String uri) {
        int portIndex = uri.indexOf(58);
        if (portIndex == -1) {
            portIndex = uri.indexOf(47);
        }
        if (portIndex == -1) {
            portIndex = uri.length();
        }
        return uri.substring(0, portIndex);
    }

    @Override
    public IMqttToken connect(Object userContext, MqttActionListener callback) throws MqttException, MqttSecurityException {
        return this.connect(new MqttConnectionOptions(), userContext, callback);
    }

    @Override
    public IMqttToken connect() throws MqttException, MqttSecurityException {
        return this.connect(null, null);
    }

    @Override
    public IMqttToken connect(MqttConnectionOptions options) throws MqttException, MqttSecurityException {
        return this.connect(options, null, null);
    }

    @Override
    public IMqttToken connect(MqttConnectionOptions options, Object userContext, MqttActionListener callback) throws MqttException, MqttSecurityException {
        if (this.comms.isConnected()) {
            throw ExceptionHelper.createMqttException(32100);
        }
        if (this.comms.isConnecting()) {
            throw new MqttException(32110);
        }
        if (this.comms.isDisconnecting()) {
            throw new MqttException(32102);
        }
        if (this.comms.isClosed()) {
            throw new MqttException(32111);
        }
        if (options == null) {
            options = new MqttConnectionOptions();
        }
        this.connOpts = options;
        this.userContext = userContext;
        boolean automaticReconnect = options.isAutomaticReconnect();
        this.log.fine(CLASS_NAME, "connect", "103", new Object[]{options.isCleanStart(), options.getConnectionTimeout(), options.getKeepAliveInterval(), options.getUserName(), options.getPassword() == null ? "[null]" : "[notnull]", options.getWillMessage() == null ? "[null]" : "[notnull]", userContext, callback});
        this.comms.setNetworkModules(this.createNetworkModules(this.serverURI, options));
        this.comms.setReconnectCallback(new MqttReconnectCallback(automaticReconnect));
        MqttToken userToken = new MqttToken(this.getClientId());
        ConnectActionListener connectActionListener = new ConnectActionListener(this, this.persistence, this.comms, options, userToken, userContext, callback, this.reconnecting, this.mqttSession, this.mqttConnection);
        userToken.setActionCallback(connectActionListener);
        userToken.setUserContext(this);
        this.mqttConnection.setSendReasonMessages(this.connOpts.isSendReasonMessages());
        if (this.mqttCallback instanceof MqttCallback) {
            connectActionListener.setMqttCallbackExtended(this.mqttCallback);
        }
        if (this.connOpts.isCleanStart()) {
            this.mqttSession.clearSessionState();
        }
        this.mqttConnection.clearConnectionState();
        this.mqttConnection.setIncomingTopicAliasMax(this.connOpts.getTopicAliasMaximum());
        this.comms.setNetworkModuleIndex(0);
        connectActionListener.connect();
        return userToken;
    }

    @Override
    public IMqttToken disconnect(Object userContext, MqttActionListener callback) throws MqttException {
        return this.disconnect(30000L, userContext, callback, 0, new MqttProperties());
    }

    @Override
    public IMqttToken disconnect() throws MqttException {
        return this.disconnect(null, null);
    }

    @Override
    public IMqttToken disconnect(long quiesceTimeout) throws MqttException {
        return this.disconnect(quiesceTimeout, null, null, 0, new MqttProperties());
    }

    @Override
    public IMqttToken disconnect(long quiesceTimeout, Object userContext, MqttActionListener callback, int reasonCode, MqttProperties disconnectProperties) throws MqttException {
        this.log.fine(CLASS_NAME, "disconnect", "104", new Object[]{quiesceTimeout, userContext, callback});
        MqttToken token = new MqttToken(this.getClientId());
        token.setActionCallback(callback);
        token.setUserContext(userContext);
        MqttDisconnect disconnect = new MqttDisconnect(reasonCode, disconnectProperties);
        try {
            this.comms.disconnect(disconnect, quiesceTimeout, token);
            Thread.sleep(100L);
        }
        catch (MqttException ex) {
            this.log.fine(CLASS_NAME, "disconnect", "105", null, ex);
            throw ex;
        }
        catch (Exception exception) {}
        this.log.fine(CLASS_NAME, "disconnect", "108");
        return token;
    }

    @Override
    public void disconnectForcibly() throws MqttException {
        this.disconnectForcibly(30000L, 10000L, 0, new MqttProperties());
    }

    @Override
    public void disconnectForcibly(long disconnectTimeout) throws MqttException {
        this.disconnectForcibly(30000L, disconnectTimeout, 0, new MqttProperties());
    }

    @Override
    public void disconnectForcibly(long quiesceTimeout, long disconnectTimeout, int reasonCode, MqttProperties disconnectProperties) throws MqttException {
        try {
            this.comms.disconnectForcibly(quiesceTimeout, disconnectTimeout, reasonCode, disconnectProperties);
            Thread.sleep(100L);
        }
        catch (MqttException ex) {
            this.log.fine(CLASS_NAME, "disconnectForcibly", "105", null, ex);
            throw ex;
        }
        catch (Exception exception) {}
        this.log.fine(CLASS_NAME, "disconnectForcibly", "108");
    }

    @Override
    public void disconnectForcibly(long quiesceTimeout, long disconnectTimeout, boolean sendDisconnectPacket) throws MqttException {
        this.comms.disconnectForcibly(quiesceTimeout, disconnectTimeout, sendDisconnectPacket, 0, new MqttProperties());
    }

    @Override
    public boolean isConnected() {
        return this.comms.isConnected();
    }

    @Override
    public String getClientId() {
        return this.mqttSession.getClientId();
    }

    @Override
    public void setClientId(String clientId) {
        this.mqttSession.setClientId(clientId);
    }

    @Override
    public String getServerURI() {
        return this.serverURI;
    }

    @Override
    public String getCurrentServerURI() {
        return this.comms.getNetworkModules()[this.comms.getNetworkModuleIndex()].getServerURI();
    }

    protected MqttTopic getTopic(String topic) {
        MqttTopicValidator.validate(topic, false, true);
        MqttTopic result = this.topics.get(topic);
        if (result == null) {
            result = new MqttTopic(topic, this.comms);
            this.topics.put(topic, result);
        }
        return result;
    }

    @Override
    public IMqttToken checkPing(Object userContext, MqttActionListener callback) throws MqttException {
        this.log.fine(CLASS_NAME, "ping", "117");
        MqttToken token = this.comms.checkForActivity(callback);
        this.log.fine(CLASS_NAME, "ping", "118");
        return token;
    }

    @Override
    public IMqttToken subscribe(String topicFilter, int qos, Object userContext, MqttActionListener callback) throws MqttException {
        return this.subscribe(new MqttSubscription[]{new MqttSubscription(topicFilter, qos)}, userContext, callback, new MqttProperties());
    }

    @Override
    public IMqttToken subscribe(String[] topicFilters, int[] qoss, Object userContext, MqttActionListener callback) throws MqttException {
        MqttSubscription[] subs = new MqttSubscription[topicFilters.length];
        int i = 0;
        while (i < topicFilters.length) {
            subs[i] = new MqttSubscription(topicFilters[i], qoss[i]);
            ++i;
        }
        return this.subscribe(subs, userContext, callback, new MqttProperties());
    }

    @Override
    public IMqttToken subscribe(String topicFilter, int qos) throws MqttException {
        return this.subscribe(new MqttSubscription[]{new MqttSubscription(topicFilter, qos)}, null, null, new MqttProperties());
    }

    @Override
    public IMqttToken subscribe(String[] topicFilters, int[] qoss) throws MqttException {
        return this.subscribe(topicFilters, qoss, null, null);
    }

    @Override
    public IMqttToken subscribe(MqttSubscription subscription) throws MqttException {
        return this.subscribe(new MqttSubscription[]{subscription}, null, null, new MqttProperties());
    }

    @Override
    public IMqttToken subscribe(MqttSubscription[] subscriptions) throws MqttException {
        return this.subscribe(subscriptions, null, null, new MqttProperties());
    }

    @Override
    public IMqttToken subscribe(MqttSubscription[] subscriptions, Object userContext, MqttActionListener callback, MqttProperties subscriptionProperties) throws MqttException {
        MqttSubscription[] mqttSubscriptionArray = subscriptions;
        int n = subscriptions.length;
        int n2 = 0;
        while (n2 < n) {
            MqttSubscription subscription = mqttSubscriptionArray[n2];
            this.comms.removeMessageListener(subscription.getTopic());
            MqttTopicValidator.validate(subscription.getTopic(), this.mqttConnection.isWildcardSubscriptionsAvailable(), this.mqttConnection.isSharedSubscriptionsAvailable());
            ++n2;
        }
        return this.subscribeBase(subscriptions, userContext, callback, subscriptionProperties);
    }

    private IMqttToken subscribeBase(MqttSubscription[] subscriptions, Object userContext, MqttActionListener callback, MqttProperties subscriptionProperties) throws MqttException {
        if (this.log.isLoggable(5)) {
            StringBuffer subs = new StringBuffer();
            int i = 0;
            while (i < subscriptions.length) {
                if (i > 0) {
                    subs.append(", ");
                }
                subs.append(subscriptions[i].toString());
                ++i;
            }
            this.log.fine(CLASS_NAME, "subscribe", "106", new Object[]{subs.toString(), userContext, callback});
        }
        MqttToken token = new MqttToken(this.getClientId());
        token.setActionCallback(callback);
        token.setUserContext(userContext);
        MqttSubscribe register = new MqttSubscribe(subscriptions, subscriptionProperties);
        token.setRequestMessage(register);
        this.comms.sendNoWait(register, token);
        this.log.fine(CLASS_NAME, "subscribe", "109");
        return token;
    }

    @Override
    public IMqttToken subscribe(MqttSubscription mqttSubscription, Object userContext, MqttActionListener callback, IMqttMessageListener messageListener, MqttProperties subscriptionProperties) throws MqttException {
        return this.subscribe(new MqttSubscription[]{mqttSubscription}, userContext, callback, messageListener, subscriptionProperties);
    }

    @Override
    public IMqttToken subscribe(MqttSubscription subscription, IMqttMessageListener messageListener) throws MqttException {
        return this.subscribe(new MqttSubscription[]{subscription}, null, null, messageListener, new MqttProperties());
    }

    @Override
    public IMqttToken subscribe(MqttSubscription[] subscriptions, IMqttMessageListener messageListener) throws MqttException {
        return this.subscribe(subscriptions, null, null, messageListener, new MqttProperties());
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public IMqttToken subscribe(MqttSubscription[] subscriptions, Object userContext, MqttActionListener callback, IMqttMessageListener[] messageListeners, MqttProperties subscriptionProperties) throws MqttException {
        block6: {
            i = 0;
            while (i < subscriptions.length) {
                MqttTopicValidator.validate(subscriptions[i].getTopic(), this.mqttConnection.isWildcardSubscriptionsAvailable(), this.mqttConnection.isSharedSubscriptionsAvailable());
                if (messageListeners == null || messageListeners[i] == null) {
                    this.comms.removeMessageListener(subscriptions[i].getTopic());
                } else {
                    this.comms.setMessageListener(null, subscriptions[i].getTopic(), messageListeners[i]);
                }
                ++i;
            }
            token = null;
            try {
                token = this.subscribeBase(subscriptions, userContext, callback, subscriptionProperties);
                break block6;
            }
            catch (Exception e) {
                var11_9 = subscriptions;
                var10_10 = subscriptions.length;
                var9_11 = 0;
                ** while (var9_11 < var10_10)
            }
lbl-1000:
            // 1 sources

            {
                subscription = var11_9[var9_11];
                this.comms.removeMessageListener(subscription.getTopic());
                ++var9_11;
                continue;
            }
lbl23:
            // 1 sources

            throw e;
        }
        return token;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public IMqttToken subscribe(MqttSubscription[] subscriptions, Object userContext, MqttActionListener callback, IMqttMessageListener messageListener, MqttProperties subscriptionProperties) throws MqttException {
        block10: {
            subId = subscriptionProperties.getSubscriptionIdentifiers().get(0);
            if (this.connOpts.useSubscriptionIdentifiers() && this.mqttConnection.isSubscriptionIdentifiersAvailable().booleanValue()) {
                if (subId != 0) {
                    if (this.comms.doesSubscriptionIdentifierExist(subId)) {
                        throw new IllegalArgumentException(String.format("The Subscription Identifier %s already exists.", new Object[]{subId}));
                    }
                } else {
                    subId = this.mqttSession.getNextSubscriptionIdentifier();
                }
            }
            var10_7 = subscriptions;
            var9_9 = subscriptions.length;
            var8_11 = 0;
            while (var8_11 < var9_9) {
                subscription = var10_7[var8_11];
                MqttTopicValidator.validate(subscription.getTopic(), this.mqttConnection.isWildcardSubscriptionsAvailable(), this.mqttConnection.isSharedSubscriptionsAvailable());
                if (messageListener == null) {
                    this.comms.removeMessageListener(subscription.getTopic());
                } else {
                    this.comms.setMessageListener(subId, subscription.getTopic(), messageListener);
                }
                ++var8_11;
            }
            token = null;
            try {
                token = this.subscribeBase(subscriptions, userContext, callback, subscriptionProperties);
                break block10;
            }
            catch (Exception e) {
                var12_14 = subscriptions;
                var11_15 = subscriptions.length;
                var10_8 = 0;
                ** while (var10_8 < var11_15)
            }
lbl-1000:
            // 1 sources

            {
                subscription = var12_14[var10_8];
                this.comms.removeMessageListener(subscription.getTopic());
                ++var10_8;
                continue;
            }
lbl33:
            // 1 sources

            throw e;
        }
        return token;
    }

    @Override
    public IMqttToken unsubscribe(String topicFilter, Object userContext, MqttActionListener callback) throws MqttException {
        return this.unsubscribe(new String[]{topicFilter}, userContext, callback, new MqttProperties());
    }

    @Override
    public IMqttToken unsubscribe(String topicFilter) throws MqttException {
        return this.unsubscribe(new String[]{topicFilter}, null, null, new MqttProperties());
    }

    @Override
    public IMqttToken unsubscribe(String[] topicFilters) throws MqttException {
        return this.unsubscribe(topicFilters, null, null, new MqttProperties());
    }

    @Override
    public IMqttToken unsubscribe(String[] topicFilters, Object userContext, MqttActionListener callback, MqttProperties unsubscribeProperties) throws MqttException {
        String topicFilter;
        int i;
        if (this.log.isLoggable(5)) {
            String subs = "";
            i = 0;
            while (i < topicFilters.length) {
                if (i > 0) {
                    subs = String.valueOf(subs) + ", ";
                }
                subs = String.valueOf(subs) + topicFilters[i];
                ++i;
            }
            this.log.fine(CLASS_NAME, "unsubscribe", "107", new Object[]{subs, userContext, callback});
        }
        String[] stringArray = topicFilters;
        int n = topicFilters.length;
        i = 0;
        while (i < n) {
            topicFilter = stringArray[i];
            MqttTopicValidator.validate(topicFilter, true, this.mqttConnection.isSharedSubscriptionsAvailable());
            ++i;
        }
        stringArray = topicFilters;
        n = topicFilters.length;
        i = 0;
        while (i < n) {
            topicFilter = stringArray[i];
            this.comms.removeMessageListener(topicFilter);
            ++i;
        }
        MqttToken token = new MqttToken(this.getClientId());
        token.setActionCallback(callback);
        token.setUserContext(userContext);
        token.internalTok.setTopics(topicFilters);
        MqttUnsubscribe unregister = new MqttUnsubscribe(topicFilters, unsubscribeProperties);
        token.setRequestMessage(unregister);
        this.comms.sendNoWait(unregister, token);
        this.log.fine(CLASS_NAME, "unsubscribe", "110");
        return token;
    }

    @Override
    public void setCallback(MqttCallback callback) {
        this.mqttCallback = callback;
        this.comms.setCallback(callback);
    }

    @Override
    public void setManualAcks(boolean manualAcks) {
        this.comms.setManualAcks(manualAcks);
    }

    @Override
    public void messageArrivedComplete(int messageId, int qos) throws MqttException {
        this.comms.messageArrivedComplete(messageId, qos);
    }

    @Override
    public IMqttToken[] getPendingTokens() {
        return this.comms.getPendingTokens();
    }

    @Override
    public IMqttToken publish(String topic, byte[] payload, int qos, boolean retained, Object userContext, MqttActionListener callback) throws MqttException, MqttPersistenceException {
        MqttMessage message = new MqttMessage(payload);
        message.setProperties(new MqttProperties());
        message.setQos(qos);
        message.setRetained(retained);
        return this.publish(topic, message, userContext, callback);
    }

    @Override
    public IMqttToken publish(String topic, byte[] payload, int qos, boolean retained) throws MqttException, MqttPersistenceException {
        return this.publish(topic, payload, qos, retained, null, null);
    }

    @Override
    public IMqttToken publish(String topic, MqttMessage message) throws MqttException, MqttPersistenceException {
        return this.publish(topic, message, null, null);
    }

    @Override
    public IMqttToken publish(String topic, MqttMessage message, Object userContext, MqttActionListener callback) throws MqttException, MqttPersistenceException {
        this.log.fine(CLASS_NAME, "publish", "111", new Object[]{topic, userContext, callback});
        MqttTopicValidator.validate(topic, false, true);
        MqttToken token = new MqttToken(this.getClientId());
        token.internalTok.setDeliveryToken(true);
        token.setActionCallback(callback);
        token.setUserContext(userContext);
        token.setMessage(message);
        token.internalTok.setTopics(new String[]{topic});
        MqttPublish pubMsg = new MqttPublish(topic, message, message.getProperties());
        token.setRequestMessage(pubMsg);
        this.comms.sendNoWait(pubMsg, token);
        this.log.fine(CLASS_NAME, "publish", "112");
        return token;
    }

    @Override
    public void reconnect() throws MqttException {
        this.log.fine(CLASS_NAME, "reconnect", "500", new Object[]{this.mqttSession.getClientId()});
        if (this.comms.isConnected()) {
            throw ExceptionHelper.createMqttException(32100);
        }
        if (this.comms.isConnecting()) {
            throw new MqttException(32110);
        }
        if (this.comms.isDisconnecting()) {
            throw new MqttException(32102);
        }
        if (this.comms.isClosed()) {
            throw new MqttException(32111);
        }
        this.stopReconnectCycle();
        this.attemptReconnect();
    }

    private void attemptReconnect() {
        this.log.fine(CLASS_NAME, "attemptReconnect", "500", new Object[]{this.mqttSession.getClientId()});
        try {
            this.connect(this.connOpts, this.userContext, new MqttReconnectActionListener("attemptReconnect"));
        }
        catch (MqttSecurityException ex) {
            this.log.fine(CLASS_NAME, "attemptReconnect", "804", null, ex);
        }
        catch (MqttException ex) {
            this.log.fine(CLASS_NAME, "attemptReconnect", "804", null, ex);
        }
    }

    private void startReconnectCycle() {
        String methodName = "startReconnectCycle";
        this.log.fine(CLASS_NAME, methodName, "503", new Object[]{this.mqttSession.getClientId(), (long)reconnectDelay});
        this.reconnectTimer = new Timer("MQTT Reconnect: " + this.mqttSession.getClientId());
        this.reconnectTimer.schedule((TimerTask)new ReconnectTask(), reconnectDelay);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopReconnectCycle() {
        String methodName = "stopReconnectCycle";
        this.log.fine(CLASS_NAME, methodName, "504", new Object[]{this.mqttSession.getClientId()});
        Object object = clientLock;
        synchronized (object) {
            if (this.connOpts.isAutomaticReconnect()) {
                if (this.reconnectTimer != null) {
                    this.reconnectTimer.cancel();
                    this.reconnectTimer = null;
                }
                reconnectDelay = 1000;
            }
        }
    }

    @Override
    public void setBufferOpts(DisconnectedBufferOptions bufferOpts) {
        this.comms.setDisconnectedMessageBuffer(new DisconnectedMessageBuffer(bufferOpts));
    }

    @Override
    public int getBufferedMessageCount() {
        return this.comms.getBufferedMessageCount();
    }

    @Override
    public MqttMessage getBufferedMessage(int bufferIndex) {
        return this.comms.getBufferedMessage(bufferIndex);
    }

    @Override
    public void deleteBufferedMessage(int bufferIndex) {
        this.comms.deleteBufferedMessage(bufferIndex);
    }

    @Override
    public int getInFlightMessageCount() {
        return this.comms.getActualInFlight();
    }

    @Override
    public void close() throws MqttException {
        this.close(false);
    }

    @Override
    public void close(boolean force) throws MqttException {
        this.log.fine(CLASS_NAME, "close", "113");
        this.comms.close(force);
        this.log.fine(CLASS_NAME, "close", "114");
    }

    @Override
    public Debug getDebug() {
        return new Debug(this.mqttSession.getClientId(), this.comms);
    }

    @Override
    public IMqttToken authenticate(int reasonCode, Object userContext, MqttProperties properties) throws MqttException {
        MqttToken token = new MqttToken(this.getClientId());
        token.setUserContext(userContext);
        MqttAuth auth = new MqttAuth(reasonCode, properties);
        this.comms.sendNoWait(auth, token);
        return null;
    }

    class MqttReconnectActionListener
    implements MqttActionListener {
        final String methodName;

        MqttReconnectActionListener(String methodName) {
            this.methodName = methodName;
        }

        @Override
        public void onSuccess(IMqttToken asyncActionToken) {
            MqttAsyncClient.this.log.fine(CLASS_NAME, this.methodName, "501", new Object[]{asyncActionToken.getClient().getClientId()});
            MqttAsyncClient.this.comms.setRestingState(false);
            MqttAsyncClient.this.stopReconnectCycle();
        }

        @Override
        public void onFailure(IMqttToken asyncActionToken, Throwable exception) {
            MqttAsyncClient.this.log.fine(CLASS_NAME, this.methodName, "502", new Object[]{asyncActionToken.getClient().getClientId()});
            if (reconnectDelay < MqttAsyncClient.this.connOpts.getMaxReconnectDelay()) {
                reconnectDelay = reconnectDelay * 2;
            }
            this.rescheduleReconnectCycle(reconnectDelay);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void rescheduleReconnectCycle(int delay) {
            String reschedulemethodName = String.valueOf(this.methodName) + ":rescheduleReconnectCycle";
            MqttAsyncClient.this.log.fine(CLASS_NAME, reschedulemethodName, "505", new Object[]{MqttAsyncClient.this.mqttSession.getClientId(), String.valueOf(reconnectDelay)});
            Object object = clientLock;
            synchronized (object) {
                if (MqttAsyncClient.this.connOpts.isAutomaticReconnect()) {
                    if (MqttAsyncClient.this.reconnectTimer != null) {
                        MqttAsyncClient.this.reconnectTimer.schedule((TimerTask)new ReconnectTask(), delay);
                    } else {
                        reconnectDelay = delay;
                        MqttAsyncClient.this.startReconnectCycle();
                    }
                }
            }
        }
    }

    class MqttReconnectCallback
    implements MqttCallback {
        final boolean automaticReconnect;

        MqttReconnectCallback(boolean isAutomaticReconnect) {
            this.automaticReconnect = isAutomaticReconnect;
        }

        @Override
        public void messageArrived(String topic, MqttMessage message) throws Exception {
        }

        @Override
        public void deliveryComplete(IMqttToken token) {
        }

        @Override
        public void connectComplete(boolean reconnect, String serverURI) {
        }

        @Override
        public void disconnected(MqttDisconnectResponse disconnectResponse) {
            if (this.automaticReconnect) {
                MqttAsyncClient.this.comms.setRestingState(true);
                MqttAsyncClient.this.reconnecting = true;
                MqttAsyncClient.this.startReconnectCycle();
            }
        }

        @Override
        public void mqttErrorOccurred(MqttException exception) {
        }

        @Override
        public void authPacketArrived(int reasonCode, MqttProperties properties) {
        }
    }

    private class ReconnectTask
    extends TimerTask {
        private static final String methodName = "ReconnectTask.run";

        private ReconnectTask() {
        }

        @Override
        public void run() {
            MqttAsyncClient.this.log.fine(CLASS_NAME, methodName, "506");
            MqttAsyncClient.this.attemptReconnect();
        }
    }
}

