/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.paho.mqttv5.client;

import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.eclipse.paho.mqttv5.client.MqttPingSender;
import org.eclipse.paho.mqttv5.client.internal.ClientComms;
import org.eclipse.paho.mqttv5.client.logging.Logger;
import org.eclipse.paho.mqttv5.client.logging.LoggerFactory;

public class TimerPingSender
implements MqttPingSender {
    private static final String CLASS_NAME = TimerPingSender.class.getName();
    private Logger log = LoggerFactory.getLogger("org.eclipse.paho.mqttv5.client.internal.nls.logcat", CLASS_NAME);
    private ClientComms comms;
    private Timer timer;
    private ScheduledExecutorService executorService = null;
    private ScheduledFuture<?> scheduledFuture;
    private String clientid;

    public TimerPingSender(ScheduledExecutorService executorService) {
        this.executorService = executorService;
    }

    @Override
    public void init(ClientComms comms) {
        if (comms == null) {
            throw new IllegalArgumentException("ClientComms cannot be null.");
        }
        this.comms = comms;
        this.clientid = comms.getClient().getClientId();
        this.log.setResourceName(this.clientid);
    }

    @Override
    public void start() {
        this.log.fine(CLASS_NAME, "start", "659", new Object[]{this.clientid});
        if (this.executorService == null) {
            this.timer = new Timer("MQTT Ping: " + this.clientid);
            this.timer.schedule((TimerTask)new PingTask(), this.comms.getKeepAlive());
        } else {
            this.schedule(this.comms.getKeepAlive());
        }
    }

    @Override
    public void stop() {
        this.log.fine(CLASS_NAME, "stop", "661", null);
        if (this.executorService == null) {
            if (this.timer != null) {
                this.timer.cancel();
            }
        } else if (this.scheduledFuture != null) {
            this.scheduledFuture.cancel(true);
        }
    }

    @Override
    public void schedule(long delayInMilliseconds) {
        if (this.executorService == null) {
            this.timer.schedule((TimerTask)new PingTask(), delayInMilliseconds);
        } else {
            this.scheduledFuture = this.executorService.schedule(new PingRunnable(), delayInMilliseconds, TimeUnit.MILLISECONDS);
        }
    }

    private class PingRunnable
    implements Runnable {
        private static final String methodName = "PingTask.run";

        private PingRunnable() {
        }

        @Override
        public void run() {
            String originalThreadName = Thread.currentThread().getName();
            Thread.currentThread().setName("MQTT Ping: " + TimerPingSender.this.clientid);
            TimerPingSender.this.log.fine(CLASS_NAME, methodName, "660", new Object[]{System.nanoTime()});
            TimerPingSender.this.comms.checkForActivity();
            Thread.currentThread().setName(originalThreadName);
        }
    }

    private class PingTask
    extends TimerTask {
        private static final String methodName = "PingTask.run";

        private PingTask() {
        }

        @Override
        public void run() {
            Thread.currentThread().setName("MQTT Ping: " + TimerPingSender.this.clientid);
            TimerPingSender.this.log.fine(CLASS_NAME, methodName, "660", new Object[]{System.nanoTime()});
            TimerPingSender.this.comms.checkForActivity();
        }
    }
}

