/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.sequencemodelgenerator.ls.extension;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import io.ballerina.compiler.api.SemanticModel;
import io.ballerina.projects.Project;
import io.ballerina.sequencemodelgenerator.core.ModelGenerator;
import io.ballerina.sequencemodelgenerator.core.model.Diagram;
import io.ballerina.sequencemodelgenerator.ls.extension.SequenceDiagramServiceRequest;
import io.ballerina.sequencemodelgenerator.ls.extension.SequenceDiagramServiceResponse;
import io.ballerina.tools.text.LineRange;
import java.nio.file.Path;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.ballerinalang.langserver.commons.eventsync.exceptions.EventSyncException;
import org.ballerinalang.langserver.commons.service.spi.ExtendedLanguageServerService;
import org.ballerinalang.langserver.commons.workspace.WorkspaceDocumentException;
import org.ballerinalang.langserver.commons.workspace.WorkspaceManager;
import org.eclipse.lsp4j.jsonrpc.services.JsonRequest;
import org.eclipse.lsp4j.jsonrpc.services.JsonSegment;
import org.eclipse.lsp4j.services.LanguageServer;

@JsonSegment(value="sequenceModelGeneratorService")
public class SequenceModelGeneratorService
implements ExtendedLanguageServerService {
    private WorkspaceManager workspaceManager;

    public void init(LanguageServer langServer, WorkspaceManager workspaceManager) {
        this.workspaceManager = workspaceManager;
    }

    public Class<?> getRemoteInterface() {
        return this.getClass();
    }

    @JsonRequest
    public CompletableFuture<SequenceDiagramServiceResponse> getSequenceDiagramModel(SequenceDiagramServiceRequest request) {
        return CompletableFuture.supplyAsync(() -> {
            SequenceDiagramServiceResponse response = new SequenceDiagramServiceResponse();
            Path filePath = Path.of(request.getFilePath(), new String[0]);
            try {
                Project project = this.getCurrentProject(filePath);
                SemanticModel semanticModel = (SemanticModel)this.workspaceManager.semanticModel(filePath).orElseThrow();
                Diagram sequenceModel = ModelGenerator.getSequenceDiagramModel((Project)project, (LineRange)request.getLineRange(), (SemanticModel)semanticModel);
                Gson gson = new GsonBuilder().create();
                JsonElement sequenceModelJson = gson.toJsonTree((Object)sequenceModel);
                response.setSequenceDiagram(sequenceModelJson);
            }
            catch (EventSyncException | WorkspaceDocumentException e) {
                throw new RuntimeException(e);
            }
            return response;
        });
    }

    private Project getCurrentProject(Path path) throws WorkspaceDocumentException, EventSyncException {
        Optional project = this.workspaceManager.project(path);
        if (project.isEmpty()) {
            return this.workspaceManager.loadProject(path);
        }
        return (Project)project.get();
    }
}

