/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.marshalling;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import org.jboss.marshalling.JDKSpecific;
import org.jboss.marshalling._private.GetUnsafeAction;
import sun.misc.Unsafe;

public final class FieldSetter {
    static final Unsafe unsafe = AccessController.doPrivileged(GetUnsafeAction.INSTANCE);
    private final Class<?> clazz;
    private final Class<?> fieldType;
    private final long fieldOffset;

    private FieldSetter(Field field) {
        this.clazz = field.getDeclaringClass();
        this.fieldType = field.getType();
        this.fieldOffset = unsafe.objectFieldOffset(field);
    }

    public void set(Object instance, Object value) throws IllegalArgumentException {
        if (!this.clazz.isInstance(instance)) {
            throw FieldSetter.incorrectType();
        }
        if (!this.fieldType.isInstance(value)) {
            throw FieldSetter.incorrectValueType();
        }
        unsafe.putObject(instance, this.fieldOffset, value);
    }

    public void setBoolean(Object instance, boolean value) throws IllegalArgumentException {
        if (!this.clazz.isInstance(instance)) {
            throw FieldSetter.incorrectType();
        }
        if (this.fieldType != Boolean.TYPE) {
            throw FieldSetter.incorrectValueType();
        }
        unsafe.putBoolean(instance, this.fieldOffset, value);
    }

    public void setByte(Object instance, byte value) throws IllegalArgumentException {
        if (!this.clazz.isInstance(instance)) {
            throw FieldSetter.incorrectType();
        }
        if (this.fieldType != Byte.TYPE) {
            throw FieldSetter.incorrectValueType();
        }
        unsafe.putByte(instance, this.fieldOffset, value);
    }

    public void setChar(Object instance, char value) throws IllegalArgumentException {
        if (!this.clazz.isInstance(instance)) {
            throw FieldSetter.incorrectType();
        }
        if (this.fieldType != Character.TYPE) {
            throw FieldSetter.incorrectValueType();
        }
        unsafe.putChar(instance, this.fieldOffset, value);
    }

    public void setDouble(Object instance, double value) throws IllegalArgumentException {
        if (!this.clazz.isInstance(instance)) {
            throw FieldSetter.incorrectType();
        }
        if (this.fieldType != Double.TYPE) {
            throw FieldSetter.incorrectValueType();
        }
        unsafe.putDouble(instance, this.fieldOffset, value);
    }

    public void setFloat(Object instance, float value) throws IllegalArgumentException {
        if (!this.clazz.isInstance(instance)) {
            throw FieldSetter.incorrectType();
        }
        if (this.fieldType != Float.TYPE) {
            throw FieldSetter.incorrectValueType();
        }
        unsafe.putFloat(instance, this.fieldOffset, value);
    }

    public void setInt(Object instance, int value) throws IllegalArgumentException {
        if (!this.clazz.isInstance(instance)) {
            throw FieldSetter.incorrectType();
        }
        if (this.fieldType != Integer.TYPE) {
            throw FieldSetter.incorrectValueType();
        }
        unsafe.putInt(instance, this.fieldOffset, value);
    }

    public void setLong(Object instance, long value) throws IllegalArgumentException {
        if (!this.clazz.isInstance(instance)) {
            throw FieldSetter.incorrectType();
        }
        if (this.fieldType != Long.TYPE) {
            throw FieldSetter.incorrectValueType();
        }
        unsafe.putLong(instance, this.fieldOffset, value);
    }

    public void setShort(Object instance, short value) throws IllegalArgumentException {
        if (!this.clazz.isInstance(instance)) {
            throw FieldSetter.incorrectType();
        }
        if (this.fieldType != Short.TYPE) {
            throw FieldSetter.incorrectValueType();
        }
        unsafe.putShort(instance, this.fieldOffset, value);
    }

    private static IllegalArgumentException incorrectType() {
        return new IllegalArgumentException("Instance is not of the correct type");
    }

    private static IllegalArgumentException incorrectValueType() {
        return new IllegalArgumentException("Value is not of the correct type");
    }

    public static FieldSetter get(Class<?> clazz, String name) throws SecurityException, IllegalArgumentException {
        Field field;
        Class<?> caller = JDKSpecific.getMyCaller();
        if (caller != clazz) {
            throw new SecurityException("Cannot get field from someone else's class");
        }
        try {
            field = clazz.getDeclaredField(name);
        }
        catch (NoSuchFieldException e) {
            throw new IllegalArgumentException("No such field '" + name + "'", e);
        }
        int modifiers = field.getModifiers();
        if (Modifier.isStatic(modifiers)) {
            throw new SecurityException("Cannot get access to static field '" + name + "'");
        }
        return new FieldSetter(field);
    }
}

