/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.graphql.commons.types;

import io.ballerina.stdlib.graphql.commons.types.DefaultDirective;
import io.ballerina.stdlib.graphql.commons.types.DirectiveLocation;
import io.ballerina.stdlib.graphql.commons.types.FederatedDirective;
import io.ballerina.stdlib.graphql.commons.types.InputValue;
import io.ballerina.stdlib.graphql.commons.utils.TypeUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class Directive
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String description;
    private final List<DirectiveLocation> locations;
    private final List<InputValue> args;

    public Directive(DefaultDirective defaultDirective) {
        this(defaultDirective.getName(), defaultDirective.getDescription(), defaultDirective.getLocations());
    }

    public Directive(FederatedDirective federatedDirective) {
        this(federatedDirective.getName(), null, federatedDirective.getLocations());
        federatedDirective.getArguments().forEach(this::addArg);
    }

    public Directive(String name, String description, List<DirectiveLocation> locations) {
        this.name = TypeUtils.removeEscapeCharacter(name);
        this.description = description;
        this.locations = locations;
        this.args = new ArrayList<InputValue>();
    }

    public void addArg(InputValue inputValue) {
        this.args.add(inputValue);
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public List<DirectiveLocation> getLocations() {
        return this.locations;
    }

    public List<InputValue> getArgs() {
        return this.args;
    }
}

