/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.graphql.commons.types;

import io.ballerina.stdlib.graphql.commons.types.Description;
import io.ballerina.stdlib.graphql.commons.types.TypeName;
import java.util.List;

public enum ScalarType {
    STRING(TypeName.STRING, Description.STRING, true),
    INT(TypeName.INT, Description.INT, true),
    FLOAT(TypeName.FLOAT, Description.FLOAT, true),
    BOOLEAN(TypeName.BOOLEAN, Description.BOOLEAN, true),
    DECIMAL(TypeName.DECIMAL, Description.DECIMAL, false),
    ID(TypeName.ID, Description.ID, true),
    UPLOAD(TypeName.UPLOAD, Description.UPLOAD, false),
    ANY(TypeName.ANY, null, false),
    FIELD_SET(TypeName.FIELD_SET, null, false),
    LINK_IMPORT(TypeName.LINK_IMPORT, null, false);

    private final TypeName typeName;
    private final Description description;
    private final boolean isInbuiltType;

    private ScalarType(TypeName typeName, Description description, Boolean isInbuiltType) {
        this.typeName = typeName;
        this.description = description;
        this.isInbuiltType = isInbuiltType;
    }

    public String getName() {
        return this.typeName.getName();
    }

    public String getDescription() {
        if (this.description == null) {
            return null;
        }
        return this.description.getDescription();
    }

    public Boolean isInbuiltType() {
        return this.isInbuiltType;
    }

    public static List<ScalarType> getFederatedScalarTypes() {
        return List.of(ANY, FIELD_SET, LINK_IMPORT);
    }
}

