/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.tcp;

import java.io.File;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SSLConfig {
    private static final Logger log = LoggerFactory.getLogger(SSLConfig.class);
    private static final String SEPARATOR = ",";
    private File keyStore;
    private String keyStorePass;
    private String certPass;
    private File trustStore;
    private String trustStorePass;
    private String sslProtocol;
    private String tlsStoreType;
    private String[] cipherSuites;
    private String[] enableProtocols;
    private boolean enableSessionCreation = true;
    private boolean needClientAuth;
    private boolean wantClientAuth;
    private String[] serverNames;
    private String[] sniMatchers;
    private int cacheSize = 50;
    private int cacheValidityPeriod = 15;
    private boolean ocspStaplingEnabled = false;
    private boolean hostNameVerificationEnabled = true;
    private File serverKeyFile;
    private File serverCertificates;
    private File clientKeyFile;
    private File clientCertificates;
    private File serverTrustCertificates;
    private File clientTrustCertificates;
    private String serverKeyPassword;
    private String clientKeyPassword;
    private int sessionTimeOut;
    private long handshakeTimeOut;
    private boolean disableSsl = false;
    private boolean useJavaDefaults = false;

    public String getCertPass() {
        return this.certPass;
    }

    public File getTrustStore() {
        return this.trustStore;
    }

    public SSLConfig setTrustStore(File trustStore) {
        if (log.isDebugEnabled()) {
            log.debug("Using trust store {}", (Object)trustStore);
        }
        this.trustStore = trustStore;
        return this;
    }

    public String getTrustStorePass() {
        return this.trustStorePass;
    }

    public SSLConfig setTrustStorePass(String trustStorePass) {
        this.trustStorePass = trustStorePass;
        return this;
    }

    public File getKeyStore() {
        return this.keyStore;
    }

    public String getKeyStorePass() {
        return this.keyStorePass;
    }

    public String[] getSniMatchers() {
        return this.sniMatchers == null ? null : (String[])this.sniMatchers.clone();
    }

    public void setSniMatchers(String sniMatchers) {
        if (log.isDebugEnabled()) {
            log.debug("Using sniMatchers {}", (Object)sniMatchers);
        }
        this.sniMatchers = sniMatchers.split(SEPARATOR);
    }

    public boolean isWantClientAuth() {
        return this.wantClientAuth;
    }

    public boolean isNeedClientAuth() {
        return this.needClientAuth;
    }

    public void setSSLProtocol(String sslProtocol) {
        if (log.isDebugEnabled()) {
            log.debug("Set SSLProtocol {}", (Object)sslProtocol);
        }
        this.sslProtocol = sslProtocol;
    }

    public String getTLSStoreType() {
        return this.tlsStoreType;
    }

    public void setTLSStoreType(String tlsStoreType) {
        this.tlsStoreType = tlsStoreType;
    }

    public String[] getEnableProtocols() {
        return this.enableProtocols == null ? null : (String[])this.enableProtocols.clone();
    }

    public void setEnableProtocols(String[] enableProtocols) {
        if (log.isDebugEnabled()) {
            log.debug("Set enable protocols {}", (Object)Arrays.toString(enableProtocols));
        }
        this.enableProtocols = (String[])enableProtocols.clone();
    }

    public String[] getCipherSuites() {
        return this.cipherSuites == null ? null : (String[])this.cipherSuites.clone();
    }

    public void setCipherSuites(String[] cipherSuites) {
        if (log.isDebugEnabled()) {
            log.debug("Set supported cipherSuites {}", (Object)Arrays.toString(cipherSuites));
        }
        this.cipherSuites = (String[])cipherSuites.clone();
    }

    public void setKeyStore(File keyStore) {
        this.keyStore = keyStore;
    }

    public void setKeyStorePass(String keyStorePass) {
        this.keyStorePass = keyStorePass;
    }

    public File getServerKeyFile() {
        return this.serverKeyFile;
    }

    public File getServerCertificates() {
        return this.serverCertificates;
    }

    public File getClientKeyFile() {
        return this.clientKeyFile;
    }

    public File getClientCertificates() {
        return this.clientCertificates;
    }

    public File getServerTrustCertificates() {
        return this.serverTrustCertificates;
    }

    public File getClientTrustCertificates() {
        return this.clientTrustCertificates;
    }

    public void setServerKeyFile(File serverKeyFile) {
        this.serverKeyFile = serverKeyFile;
    }

    public void setServerCertificates(File serverCertificates) {
        this.serverCertificates = serverCertificates;
    }

    public void setClientTrustCertificates(File clientTrustCertificates) {
        this.clientTrustCertificates = clientTrustCertificates;
    }

    public String getServerKeyPassword() {
        return this.serverKeyPassword;
    }

    public void setServerKeyPassword(String serverKeyPassword) {
        this.serverKeyPassword = serverKeyPassword;
    }

    public String getClientKeyPassword() {
        return this.clientKeyPassword;
    }

    public int getSessionTimeOut() {
        return this.sessionTimeOut;
    }

    public void setSessionTimeOut(int sessionTimeOut) {
        this.sessionTimeOut = sessionTimeOut;
    }

    public long getHandshakeTimeOut() {
        return this.handshakeTimeOut;
    }

    public void setHandshakeTimeOut(long handshakeTimeOut) {
        this.handshakeTimeOut = handshakeTimeOut;
    }
}

