/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.tcp;

import io.ballerina.stdlib.tcp.SSLConfig;
import io.netty.handler.ssl.CipherSuiteFilter;
import io.netty.handler.ssl.ClientAuth;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.SslProvider;
import io.netty.handler.ssl.SupportedCipherSuiteFilter;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.Arrays;
import java.util.List;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManagerFactory;

public class SSLHandlerFactory {
    private SSLConfig sslConfig;
    private boolean needClientAuth;
    private boolean wantClientAuth;
    private KeyManagerFactory kmf;
    private TrustManagerFactory tmf;

    public SSLHandlerFactory(SSLConfig sslConfig) {
        this.sslConfig = sslConfig;
        this.needClientAuth = sslConfig.isNeedClientAuth();
        this.wantClientAuth = sslConfig.isWantClientAuth();
    }

    private KeyStore getKeyStore(File keyStore, String keyStorePassword) throws IOException {
        KeyStore ks = null;
        String tlsStoreType = this.sslConfig.getTLSStoreType();
        if (keyStore != null && keyStorePassword != null) {
            try (FileInputStream is = new FileInputStream(keyStore);){
                ks = KeyStore.getInstance(tlsStoreType);
                ks.load(is, keyStorePassword.toCharArray());
            }
            catch (KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
                throw new IOException(e);
            }
        }
        return ks;
    }

    private SslContextBuilder serverContextBuilderWithKs(SslProvider sslProvider) {
        SslContextBuilder serverSslContextBuilder = SslContextBuilder.forServer((KeyManagerFactory)this.getKeyManagerFactory()).trustManager(this.getTrustStoreFactory()).sslProvider(sslProvider);
        this.setClientAuth(serverSslContextBuilder);
        return serverSslContextBuilder;
    }

    private SslContextBuilder clientContextBuilderWithKs(SslProvider sslProvider) {
        return SslContextBuilder.forClient().sslProvider(sslProvider).keyManager(this.kmf).trustManager(this.tmf);
    }

    private SslContextBuilder serverContextBuilderWithCerts(SslProvider sslProvider) {
        String keyPassword = this.sslConfig.getServerKeyPassword();
        SslContextBuilder serverSslContextBuilder = SslContextBuilder.forServer((File)this.sslConfig.getServerCertificates(), (File)this.sslConfig.getServerKeyFile()).keyManager(this.sslConfig.getServerCertificates(), this.sslConfig.getServerKeyFile(), keyPassword).trustManager(this.sslConfig.getServerTrustCertificates()).sslProvider(sslProvider);
        this.setClientAuth(serverSslContextBuilder);
        return serverSslContextBuilder;
    }

    private SslContextBuilder clientContextBuilderWithCerts(SslProvider sslProvider) {
        String keyPassword = this.sslConfig.getClientKeyPassword();
        return SslContextBuilder.forClient().sslProvider(sslProvider).keyManager(this.sslConfig.getClientCertificates(), this.sslConfig.getClientKeyFile(), keyPassword).trustManager(this.sslConfig.getClientTrustCertificates());
    }

    private void setCiphers(SslContextBuilder sslContextBuilder, List<String> ciphers) {
        sslContextBuilder.ciphers(ciphers, (CipherSuiteFilter)SupportedCipherSuiteFilter.INSTANCE);
    }

    private void setSslProtocol(SslContextBuilder sslContextBuilder) {
        sslContextBuilder.protocols(this.sslConfig.getEnableProtocols());
    }

    private KeyManagerFactory getKeyManagerFactory() {
        return this.kmf;
    }

    private TrustManagerFactory getTrustStoreFactory() {
        return this.tmf;
    }

    private void setClientAuth(SslContextBuilder serverSslContextBuilder) {
        if (this.needClientAuth) {
            serverSslContextBuilder.clientAuth(ClientAuth.REQUIRE);
        } else if (this.wantClientAuth) {
            serverSslContextBuilder.clientAuth(ClientAuth.OPTIONAL);
        } else {
            serverSslContextBuilder.clientAuth(ClientAuth.NONE);
        }
    }

    public SslContext createContextForClient() throws IOException, NoSuchAlgorithmException, KeyStoreException {
        SslContextBuilder sslContextBuilder;
        SslProvider provider = SslProvider.JDK;
        if (this.sslConfig.getClientTrustCertificates() != null) {
            sslContextBuilder = this.clientContextBuilderWithCerts(provider);
        } else {
            this.initializeTrustManagerFactory();
            sslContextBuilder = this.clientContextBuilderWithKs(provider);
        }
        String[] ciphers = this.sslConfig.getCipherSuites();
        if (ciphers != null) {
            this.setCiphers(sslContextBuilder, Arrays.asList(ciphers));
        }
        this.setSslProtocol(sslContextBuilder);
        SslContext sslContext = sslContextBuilder.build();
        int sessionTimeout = this.sslConfig.getSessionTimeOut();
        if (sessionTimeout > 0) {
            sslContext.sessionContext().setSessionTimeout(sessionTimeout);
        }
        return sslContext;
    }

    private void initializeTrustManagerFactory() throws IOException, NoSuchAlgorithmException, KeyStoreException {
        KeyStore tks = this.getKeyStore(this.sslConfig.getTrustStore(), this.sslConfig.getTrustStorePass());
        this.tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        this.tmf.init(tks);
    }

    public SslContext createContextForServer() throws IOException, NoSuchAlgorithmException, UnrecoverableKeyException, KeyStoreException {
        SslContextBuilder sslContextBuilder;
        SslProvider provider = SslProvider.JDK;
        if (this.sslConfig.getServerCertificates() != null) {
            sslContextBuilder = this.serverContextBuilderWithCerts(provider);
        } else {
            this.initializeKeyManagerFactory();
            sslContextBuilder = this.serverContextBuilderWithKs(provider);
        }
        String[] ciphers = this.sslConfig.getCipherSuites();
        if (ciphers != null) {
            this.setCiphers(sslContextBuilder, Arrays.asList(ciphers));
        }
        this.setSslProtocol(sslContextBuilder);
        SslContext sslContext = sslContextBuilder.build();
        int sessionTimeout = this.sslConfig.getSessionTimeOut();
        if (sessionTimeout > 0) {
            sslContext.sessionContext().setSessionTimeout(sessionTimeout);
        }
        return sslContext;
    }

    private void initializeKeyManagerFactory() throws IOException, NoSuchAlgorithmException, KeyStoreException, UnrecoverableKeyException {
        KeyStore ks = this.getKeyStore(this.sslConfig.getKeyStore(), this.sslConfig.getKeyStorePass());
        this.kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        this.kmf.init(ks, this.sslConfig.getCertPass() != null ? this.sslConfig.getCertPass().toCharArray() : this.sslConfig.getKeyStorePass().toCharArray());
    }
}

