/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.tcp;

import io.ballerina.stdlib.tcp.TcpListenerHandler;
import io.ballerina.stdlib.tcp.nativeclient.Client;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.codec.DecoderException;
import io.netty.handler.flow.FlowControlHandler;
import io.netty.handler.ssl.SslCloseCompletionEvent;
import io.netty.handler.ssl.SslHandshakeCompletionEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SslHandshakeListenerEventHandler
extends ChannelInboundHandlerAdapter {
    private TcpListenerHandler tcpListenerHandler;
    private static final Logger log = LoggerFactory.getLogger(Client.class);

    public SslHandshakeListenerEventHandler(TcpListenerHandler handler) {
        this.tcpListenerHandler = handler;
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object event) throws Exception {
        if (event instanceof SslHandshakeCompletionEvent) {
            if (((SslHandshakeCompletionEvent)event).isSuccess()) {
                ctx.pipeline().addLast("flowControlHandler", (ChannelHandler)new FlowControlHandler());
                ctx.pipeline().addLast("listenerHandler", (ChannelHandler)this.tcpListenerHandler);
                ctx.fireChannelActive();
                ctx.pipeline().remove((ChannelHandler)this);
            } else {
                ctx.close();
            }
        } else if (!(event instanceof SslCloseCompletionEvent)) {
            log.warn("Unexpected user event triggered");
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        log.error("Error while SSL handshake: " + cause.getMessage());
        if (cause instanceof DecoderException) {
            ctx.close();
        }
    }
}

