/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.tcp;

import io.ballerina.runtime.api.values.BMap;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.stdlib.tcp.Constants;
import io.ballerina.stdlib.tcp.SSLConfig;
import io.ballerina.stdlib.tcp.SSLHandlerFactory;
import io.ballerina.stdlib.tcp.SslHandshakeClientEventHandler;
import io.ballerina.stdlib.tcp.TcpClientHandler;
import io.ballerina.stdlib.tcp.Utils;
import io.ballerina.stdlib.tcp.WriteFlowController;
import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.timeout.IdleStateHandler;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

public class TcpClient {
    private Channel channel;

    public TcpClient(InetSocketAddress localAddress, InetSocketAddress remoteAddress, EventLoopGroup group, final CompletableFuture<Object> callback, final BMap<BString, Object> secureSocket) {
        final AtomicBoolean isCallbackCompleted = new AtomicBoolean(false);
        Bootstrap clientBootstrap = new Bootstrap();
        ((Bootstrap)((Bootstrap)((Bootstrap)clientBootstrap.group(group)).channel(NioSocketChannel.class)).handler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            protected void initChannel(SocketChannel ch) throws Exception {
                TcpClientHandler tcpClientHandler = new TcpClientHandler();
                if (secureSocket != null && secureSocket.getBooleanValue(Constants.SECURESOCKET_CONFIG_ENABLE_SSL).booleanValue()) {
                    TcpClient.this.setSSLHandler(ch, (BMap<BString, Object>)secureSocket, tcpClientHandler, callback);
                } else {
                    ch.pipeline().addLast("clientHandler", (ChannelHandler)tcpClientHandler);
                }
            }

            public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
                callback.complete(Utils.createTcpError(cause.getMessage()));
                isCallbackCompleted.set(true);
                ctx.close();
            }
        })).connect((SocketAddress)remoteAddress, (SocketAddress)localAddress).addListener((GenericFutureListener)((ChannelFutureListener)channelFuture -> {
            if (channelFuture.isSuccess()) {
                this.channel = channelFuture.channel();
                if (secureSocket == null || !secureSocket.getBooleanValue(Constants.SECURESOCKET_CONFIG_ENABLE_SSL).booleanValue()) {
                    channelFuture.channel().config().setAutoRead(false);
                    callback.complete(null);
                }
            } else if (!isCallbackCompleted.get()) {
                callback.complete((Object)Utils.createTcpError(String.format("Unable to connect with remote host: %s", channelFuture.cause().getMessage())));
            }
        }));
    }

    private void setSSLHandler(SocketChannel channel, BMap<BString, Object> secureSocket, TcpClientHandler tcpClientHandler, CompletableFuture<Object> callback) throws Exception {
        SSLConfig sslConfig = Utils.setSslConfig(secureSocket, new SSLConfig(), false);
        SSLHandlerFactory sslHandlerFactory = new SSLHandlerFactory(sslConfig);
        SslContext sslContext = sslHandlerFactory.createContextForClient();
        SslHandler sslHandler = sslContext.newHandler(channel.alloc());
        sslHandler.setHandshakeTimeout(sslConfig.getHandshakeTimeOut(), TimeUnit.SECONDS);
        channel.pipeline().addFirst("SSL_Handler", (ChannelHandler)sslHandler);
        channel.pipeline().addLast("SSL_handshakeHandler", (ChannelHandler)new SslHandshakeClientEventHandler(tcpClientHandler, callback));
    }

    public void writeData(byte[] bytes, CompletableFuture<Object> callback, double writeTimeoutInSec) {
        AtomicBoolean futureCompleted = new AtomicBoolean(false);
        long writeTimeoutInNano = (long)(writeTimeoutInSec * 1.0E9);
        if (this.channel.isActive()) {
            this.channel.pipeline().addFirst("writeTimeoutHandler", (ChannelHandler)new IdleStateHandler(0L, writeTimeoutInNano, 0L, TimeUnit.NANOSECONDS));
            WriteFlowController writeFlowController = new WriteFlowController(Unpooled.wrappedBuffer((byte[])bytes), callback, futureCompleted);
            TcpClientHandler tcpClientHandler = (TcpClientHandler)this.channel.pipeline().get("clientHandler");
            tcpClientHandler.addWriteFlowControl(writeFlowController);
            tcpClientHandler.setCallback(callback);
            tcpClientHandler.setWriteFutureCompleted(futureCompleted);
            if (this.channel.isWritable()) {
                writeFlowController.writeData(this.channel, tcpClientHandler.getWriteFlowControllers());
            }
        } else {
            callback.complete((Object)Utils.createTcpError("Socket connection already closed."));
        }
    }

    public void readData(double readTimeoutInSec, CompletableFuture<Object> callback) {
        long readTimeoutInNano = (long)(readTimeoutInSec * 1.0E9);
        if (this.channel.isActive()) {
            this.channel.pipeline().addFirst("readTimeoutHandler", (ChannelHandler)new IdleStateHandler(readTimeoutInNano, 0L, 0L, TimeUnit.NANOSECONDS));
            TcpClientHandler handler = (TcpClientHandler)this.channel.pipeline().get("clientHandler");
            handler.setCallback(callback);
            this.channel.read();
        } else {
            callback.complete((Object)Utils.createTcpError("Socket connection already closed."));
        }
    }

    public void close(CompletableFuture<Object> callback) {
        TcpClientHandler handler = (TcpClientHandler)this.channel.pipeline().get("clientHandler");
        if (handler != null) {
            handler.setIsCloseTriggered();
        }
        this.channel.close().addListener((GenericFutureListener)((ChannelFutureListener)future -> {
            if (future.isSuccess()) {
                callback.complete(null);
            } else {
                callback.complete((Object)Utils.createTcpError(String.format("Unable to close the  TCP client: %s", future.cause().getMessage())));
            }
        }));
    }
}

