/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.central.client;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.invoke.LambdaMetafactory;
import java.net.Proxy;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Supplier;
import okhttp3.Authenticator;
import okhttp3.Cache;
import okhttp3.Call;
import okhttp3.Credentials;
import okhttp3.HttpUrl;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.ballerinalang.central.client.BuildLogFormatter;
import org.ballerinalang.central.client.LogFormatter;
import org.ballerinalang.central.client.Utils;
import org.ballerinalang.central.client.exceptions.CentralClientException;
import org.ballerinalang.central.client.exceptions.ConnectionErrorException;
import org.ballerinalang.central.client.exceptions.NoPackageException;
import org.ballerinalang.central.client.exceptions.PackageAlreadyExistsException;
import org.ballerinalang.central.client.model.ConnectorInfo;
import org.ballerinalang.central.client.model.Error;
import org.ballerinalang.central.client.model.Package;
import org.ballerinalang.central.client.model.PackageNameResolutionRequest;
import org.ballerinalang.central.client.model.PackageNameResolutionResponse;
import org.ballerinalang.central.client.model.PackageResolutionRequest;
import org.ballerinalang.central.client.model.PackageResolutionResponse;
import org.ballerinalang.central.client.model.PackageSearchResult;
import org.ballerinalang.central.client.model.ToolResolutionCentralRequest;
import org.ballerinalang.central.client.model.ToolResolutionCentralResponse;
import org.ballerinalang.central.client.model.ToolSearchResult;

public class CentralAPIClient {
    private static final String PACKAGES = "packages";
    private static final String TOOLS = "tools";
    private static final String CONNECTORS = "connectors";
    private static final String TRIGGERS = "triggers";
    private static final String SEARCH_QUERY = "?q=";
    private static final String SEPARATOR = "/";
    private static final String RESOLVE_DEPENDENCIES = "resolve-dependencies";
    private static final String RESOLVE_MODULES = "resolve-modules";
    private static final String DEPRECATE = "deprecate";
    private static final String UN_DEPRECATE = "undeprecate";
    private static final String PACKAGE_PATH_PREFIX = "/packages/";
    private static final String TOOL_PATH_PREFIX = "/tools/";
    private static final String CONNECTOR_PATH_PREFIX = "/connectors/";
    private static final String TRIGGER_PATH_PREFIX = "/triggers/";
    private static final String ERR_CANNOT_FIND_PACKAGE = "error: could not connect to remote repository to find package: ";
    private static final String ERR_CANNOT_FIND_VERSIONS = "error: could not connect to remote repository to find versions for: ";
    private static final String ERR_CANNOT_PUSH = "error: failed to push the package: ";
    private static final String ERR_CANNOT_PULL_PACKAGE = "error: failed to pull the package: ";
    private static final String ERR_CANNOT_SEARCH = "error: failed to search packages: ";
    private static final String ERR_CANNOT_GET_CONNECTOR = "error: failed to find connector: ";
    private static final String ERR_CANNOT_GET_TRIGGERS = "error: failed to find triggers: ";
    private static final String ERR_CANNOT_GET_TRIGGER = "error: failed to find the trigger: ";
    private static final String ERR_PACKAGE_DEPRECATE = "error: failed to deprecate the package: ";
    private static final String ERR_PACKAGE_UN_DEPRECATE = "error: failed to undo deprecation of the package: ";
    private static final String ERR_PACKAGE_RESOLUTION = "error: while connecting to central: ";
    private static final MediaType JSON = MediaType.parse((String)"application/json; charset=utf-8");
    private static final MediaType JSON_CONTENT_TYPE = MediaType.parse((String)"application/json");
    public static final String SYS_PROP_CENTRAL_VERBOSE_ENABLED = "CENTRAL_VERBOSE_ENABLED";
    private static final int DEFAULT_CONNECT_TIMEOUT = 60;
    private static final int DEFAULT_READ_TIMEOUT = 60;
    private static final int DEFAULT_WRITE_TIMEOUT = 60;
    private static final int DEFAULT_CALL_TIMEOUT = 0;
    private static final int MAX_RETRY = 1;
    public static final String CONNECTION_RESET = "Connection reset";
    private final String baseUrl;
    private final Proxy proxy;
    private String accessToken;
    protected PrintStream outStream;
    private final boolean verboseEnabled;
    private final String proxyUsername;
    private final String proxyPassword;
    private final int connectTimeout;
    private final int readTimeout;
    private final int writeTimeout;
    private final int callTimeout;
    private final int maxRetries;

    public CentralAPIClient(String baseUrl, Proxy proxy, String accessToken) {
        this.outStream = System.out;
        this.baseUrl = baseUrl;
        this.proxy = proxy;
        this.accessToken = accessToken;
        this.verboseEnabled = Boolean.parseBoolean(System.getenv(SYS_PROP_CENTRAL_VERBOSE_ENABLED));
        this.proxyUsername = "";
        this.proxyPassword = "";
        this.connectTimeout = 60;
        this.readTimeout = 60;
        this.writeTimeout = 60;
        this.callTimeout = 0;
        this.maxRetries = 1;
    }

    public CentralAPIClient(String baseUrl, Proxy proxy, String accessToken, boolean verboseEnabled, int maxRetries, PrintStream outStream) {
        this.outStream = outStream;
        this.baseUrl = baseUrl;
        this.proxy = proxy;
        this.accessToken = accessToken;
        this.verboseEnabled = verboseEnabled;
        this.proxyUsername = "";
        this.proxyPassword = "";
        this.connectTimeout = 60;
        this.readTimeout = 60;
        this.writeTimeout = 60;
        this.callTimeout = 0;
        this.maxRetries = maxRetries;
    }

    public CentralAPIClient(String baseUrl, Proxy proxy, String proxyUsername, String proxyPassword, String accessToken, int connectionTimeout, int readTimeout, int writeTimeout, int callTimeout, int maxRetries) {
        this.outStream = System.out;
        this.baseUrl = baseUrl;
        this.proxy = proxy;
        this.accessToken = accessToken;
        this.verboseEnabled = Boolean.parseBoolean(System.getenv(SYS_PROP_CENTRAL_VERBOSE_ENABLED));
        this.proxyUsername = proxyUsername;
        this.proxyPassword = proxyPassword;
        this.connectTimeout = connectionTimeout;
        this.readTimeout = readTimeout;
        this.writeTimeout = writeTimeout;
        this.callTimeout = callTimeout;
        this.maxRetries = maxRetries;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Package getPackage(String orgNamePath, String packageNamePath, String version, String supportedPlatform, String ballerinaVersion) throws CentralClientException {
        String packageSignature = orgNamePath + SEPARATOR + packageNamePath + ":" + version;
        Optional<Object> body = Optional.empty();
        OkHttpClient client = this.getClient();
        try {
            Optional<MediaType> contentType;
            String resourceUrl = PACKAGE_PATH_PREFIX + orgNamePath + SEPARATOR + packageNamePath;
            String url = this.baseUrl + resourceUrl;
            if (null != version && !version.isEmpty()) {
                url = url + SEPARATOR + version;
            }
            Request getPackageReq = this.getNewRequest(supportedPlatform, ballerinaVersion).get().url(url).build();
            this.logRequestInitVerbose(getPackageReq);
            Call getPackageReqCall = client.newCall(getPackageReq);
            Response getPackageResponse = getPackageReqCall.execute();
            this.logRequestConnectVerbose(getPackageReq, resourceUrl);
            body = Optional.ofNullable(getPackageResponse.body());
            String responseBodyContent = null;
            if (body.isPresent()) {
                responseBodyContent = ((ResponseBody)body.get()).string();
            }
            this.logResponseVerbose(getPackageResponse, responseBodyContent);
            if (!body.isPresent() || !(contentType = Optional.ofNullable(((ResponseBody)body.get()).contentType())).isPresent() || !Utils.isApplicationJsonContentType(contentType.get().toString())) throw new CentralClientException(ERR_CANNOT_FIND_PACKAGE + packageSignature);
            if (getPackageResponse.code() == 200) {
                Package package_ = (Package)new Gson().fromJson(responseBodyContent, Package.class);
                return package_;
            }
            try {
                Error error;
                if (getPackageResponse.code() == 404) {
                    Error error2 = (Error)new Gson().fromJson(responseBodyContent, Error.class);
                    if (!error2.getMessage().contains("package not found for:")) throw new CentralClientException(ERR_CANNOT_FIND_PACKAGE + packageSignature + ". reason: " + error2.getMessage());
                    throw new NoPackageException(error2.getMessage());
                }
                if (getPackageResponse.code() == 401) {
                    this.handleUnauthorizedResponse(orgNamePath, body, responseBodyContent);
                }
                if (getPackageResponse.code() != 400 && getPackageResponse.code() != 500 && getPackageResponse.code() != 503 || (error = (Error)new Gson().fromJson(responseBodyContent, Error.class)).getMessage() == null || "".equals(error.getMessage())) throw new CentralClientException(ERR_CANNOT_FIND_PACKAGE + packageSignature);
                throw new CentralClientException(error.getMessage());
            }
            catch (IOException e) {
                throw new CentralClientException(ERR_CANNOT_FIND_PACKAGE + packageSignature + ". reason: " + e.getMessage());
            }
        }
        finally {
            body.ifPresent(ResponseBody::close);
            try {
                this.closeClient(client);
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<String> getPackageVersions(String orgNamePath, String packageNamePath, String supportedPlatform, String ballerinaVersion) throws CentralClientException {
        packageSignature = orgNamePath + "/" + packageNamePath;
        body = Optional.empty();
        client = this.getClient();
        try {
            resourceUrl = "/packages/" + orgNamePath + "/" + packageNamePath;
            url = this.baseUrl + resourceUrl;
            getVersionsReq = this.getNewRequest(supportedPlatform, ballerinaVersion).get().url(url).build();
            this.logRequestInitVerbose(getVersionsReq);
            getVersionsReqCall = client.newCall(getVersionsReq);
            getVersionsResponse = getVersionsReqCall.execute();
            this.logRequestConnectVerbose(getVersionsReq, resourceUrl);
            body = Optional.ofNullable(getVersionsResponse.body());
            responseBodyContent = null;
            if (body.isPresent()) {
                responseBodyContent = ((ResponseBody)body.get()).string();
            }
            this.logResponseVerbose(getVersionsResponse, responseBodyContent);
            if (body.isPresent() == false) throw new CentralClientException("error: could not connect to remote repository to find versions for: " + packageSignature + ".");
            contentType = Optional.ofNullable(((ResponseBody)body.get()).contentType());
            if (contentType.isPresent() == false) throw new CentralClientException("error: could not connect to remote repository to find versions for: " + packageSignature + ".");
            if (Utils.isApplicationJsonContentType(contentType.get().toString()) == false) throw new CentralClientException("error: could not connect to remote repository to find versions for: " + packageSignature + ".");
            if (getVersionsResponse.code() == 200) {
                var15_16 = Utils.getAsList(responseBodyContent);
                return var15_16;
            }
            if (getVersionsResponse.code() == 401) {
                this.handleUnauthorizedResponse(orgNamePath, body, responseBodyContent);
            }
            if (getVersionsResponse.code() != 404) ** GOTO lbl33
            error = (Error)new Gson().fromJson(responseBodyContent, Error.class);
            if (error.getMessage().contains("package not found")) {
                var16_20 = new ArrayList<String>();
                return var16_20;
            }
            throw new CentralClientException("error: could not connect to remote repository to find versions for: " + packageSignature + ". reason: " + error.getMessage());
lbl33:
            // 1 sources

            if (getVersionsResponse.code() != 400 && getVersionsResponse.code() != 500) {
                if (getVersionsResponse.code() != 503) throw new CentralClientException("error: could not connect to remote repository to find versions for: " + packageSignature + ".");
            }
            error = (Error)new Gson().fromJson(responseBodyContent, Error.class);
            throw new CentralClientException("error: could not connect to remote repository to find versions for: " + packageSignature + ". reason: " + error.getMessage());
        }
        catch (IOException e) {
            throw new CentralClientException("error: could not connect to remote repository to find versions for: " + packageSignature + ". reason: " + e.getMessage());
        }
        finally {
            body.ifPresent((Consumer<ResponseBody>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, close(), (Lokhttp3/ResponseBody;)V)());
            try {
                this.closeClient(client);
            }
            catch (IOException var16_19) {}
        }
    }

    public void pushPackage(Path balaPath, String org, String name, String version, String supportedPlatform, String ballerinaVersion) throws CentralClientException {
        boolean enableOutputStream = Boolean.parseBoolean(System.getProperty("enableOutputStream"));
        String packageSignature = org + SEPARATOR + name + ":" + version;
        String url = this.baseUrl + "/packages";
        Optional<Object> body = Optional.empty();
        OkHttpClient client = this.getClient();
        try {
            Object fileName = org + "-" + name + "-" + version + ".bala";
            Path fileNamePath = balaPath.getFileName();
            if (fileNamePath != null) {
                fileName = fileNamePath.toString();
            }
            MultipartBody balaFileReqBody = new MultipartBody.Builder().setType(MultipartBody.FORM).addFormDataPart("bala-file", (String)fileName, RequestBody.create((MediaType)MediaType.parse((String)"application/octet-stream"), (File)balaPath.toFile())).build();
            String remoteRepo = Utils.getRemoteRepo();
            String projectRepo = balaPath.toString().split(name)[0] + name;
            Utils.ProgressRequestBody balaFileReqBodyWithProgressBar = new Utils.ProgressRequestBody((RequestBody)balaFileReqBody, packageSignature + " [" + projectRepo + " -> " + remoteRepo + "]", this.outStream);
            String digestVal = "sha-256=" + Utils.checkHash(balaPath.toString(), "SHA-256");
            Request pushRequest = this.getNewRequest(supportedPlatform, ballerinaVersion).addHeader("digest", digestVal).post((RequestBody)(enableOutputStream ? balaFileReqBodyWithProgressBar : balaFileReqBody)).url(url).build();
            this.logRequestInitVerbose(pushRequest);
            Call pushRequestCall = client.newCall(pushRequest);
            Response packagePushResponse = pushRequestCall.execute();
            this.logRequestConnectVerbose(pushRequest, "/packages");
            body = Optional.ofNullable(packagePushResponse.body());
            String responseBodyContent = null;
            if (body.isPresent()) {
                responseBodyContent = ((ResponseBody)body.get()).string();
            }
            this.logResponseVerbose(packagePushResponse, responseBodyContent);
            if (packagePushResponse.code() == 204) {
                if (enableOutputStream) {
                    this.outStream.println(packageSignature + " pushed to central successfully");
                }
                return;
            }
            try {
                Optional<MediaType> contentType;
                if (packagePushResponse.code() == 401) {
                    this.handleUnauthorizedResponse(org, body, responseBodyContent);
                }
                if (body.isPresent() && (contentType = Optional.ofNullable(((ResponseBody)body.get()).contentType())).isPresent() && Utils.isApplicationJsonContentType(contentType.get().toString())) {
                    Error error;
                    if (packagePushResponse.code() == 400 && (error = (Error)new Gson().fromJson(responseBodyContent, Error.class)).getMessage() != null && !"".equals(error.getMessage())) {
                        if (error.getMessage().contains("subject claims missing in the user info repsonse")) {
                            error.setMessage("unauthorized access token for organization: '" + org + "'. check access token set in 'Settings.toml' file.");
                        }
                        throw new CentralClientException(error.getMessage());
                    }
                    if (!(packagePushResponse.code() != 500 && packagePushResponse.code() != 503 || (error = (Error)new Gson().fromJson(responseBodyContent, Error.class)).getMessage() == null || "".equals(error.getMessage()))) {
                        throw new CentralClientException("error: failed to push the package: '" + packageSignature + "' reason:" + error.getMessage());
                    }
                }
                throw new CentralClientException("error: failed to push the package: '" + packageSignature + "' to the remote repository '" + url + "'.");
            }
            catch (IOException e) {
                throw new CentralClientException("error: failed to push the package: '" + packageSignature + "' to the remote repository '" + url + "'. reason: " + e.getMessage());
            }
        }
        finally {
            body.ifPresent(ResponseBody::close);
            try {
                this.closeClient(client);
            }
            catch (IOException iOException) {}
        }
    }

    public void pullPackage(String org, String name, String version, Path packagePathInBalaCache, String supportedPlatform, String ballerinaVersion, boolean isBuild) throws CentralClientException {
        for (int retryCount = 0; retryCount <= this.maxRetries; ++retryCount) {
            try {
                this.pullPackageInternal(org, name, version, packagePathInBalaCache, supportedPlatform, ballerinaVersion, isBuild);
                break;
            }
            catch (CentralClientException centralClientException) {
                if (centralClientException.getMessage().contains(CONNECTION_RESET) && retryCount < this.maxRetries) {
                    if (!this.verboseEnabled) continue;
                    this.outStream.println("* Retrying to pull the package: " + org + SEPARATOR + name + ":" + version + " due to: " + centralClientException.getMessage() + ". Retry attempt: " + (retryCount + 1));
                    this.outStream.println();
                    continue;
                }
                throw centralClientException;
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private void pullPackageInternal(String org, String name, String version, Path packagePathInBalaCache, String supportedPlatform, String ballerinaVersion, boolean isBuild) throws CentralClientException {
        resourceUrl = "/packages/" + org + "/" + name;
        enableOutputStream = Boolean.parseBoolean(System.getProperty("enableOutputStream"));
        packageSignature = org + "/" + name;
        url = this.baseUrl + resourceUrl;
        if (null != version && !version.isEmpty()) {
            url = url + "/" + version;
            packageSignature = packageSignature + ":" + version;
        } else {
            url = url + "/*";
            packageSignature = packageSignature + ":*";
        }
        body = Optional.empty();
        client = this.getClient();
        try {
            logFormatter = new LogFormatter();
            if (isBuild) {
                logFormatter = new BuildLogFormatter();
            }
            packagePullReq = this.getNewRequest(supportedPlatform, ballerinaVersion).get().url(url).addHeader("Accept-Encoding", "identity").addHeader("Accept", "application/octet-stream").build();
            this.logRequestInitVerbose(packagePullReq);
            packagePullReqCall = client.newCall(packagePullReq);
            packagePullResponse = packagePullReqCall.execute();
            this.logRequestConnectVerbose(packagePullReq, resourceUrl);
            body = Optional.ofNullable(packagePullResponse.body());
            pkgPullResBodyContent = null;
            if (body.isPresent()) {
                pkgPullResBodyContent = ((ResponseBody)body.get()).string();
            }
            this.logResponseVerbose(packagePullResponse, pkgPullResBodyContent);
            if (packagePullResponse.code() != 302) ** GOTO lbl55
            balaUrl = Optional.ofNullable(packagePullResponse.header("Location"));
            balaFileName = Optional.ofNullable(packagePullResponse.header("Content-Disposition"));
            deprecationFlag = Optional.ofNullable(packagePullResponse.header("isdeprecated"));
            deprecationMsg = Optional.ofNullable(packagePullResponse.header("deprecatemessage"));
            digest = Optional.ofNullable(packagePullResponse.header("digest"));
            digestVal = digest.orElse("");
            isDeprecated = deprecationFlag.isPresent() != false && Boolean.parseBoolean(deprecationFlag.get()) != false;
            deprecationMessage = deprecationMsg.orElse("");
            if (!isBuild && isDeprecated) {
                this.outStream.println("WARNING [" + name + "] " + packageSignature + " is deprecated: " + deprecationMessage);
            }
            if (!balaUrl.isPresent() || !balaFileName.isPresent()) ** GOTO lbl53
            downloadBalaRequest = this.getNewRequest(supportedPlatform, ballerinaVersion).get().url(balaUrl.get()).header("Accept-Encoding", "identity").addHeader("Content-Disposition", balaFileName.get()).build();
            this.logRequestInitVerbose(downloadBalaRequest);
            downloadBalaRequestCall = client.newCall(downloadBalaRequest);
            balaDownloadResponse = downloadBalaRequestCall.execute();
            this.logRequestConnectVerbose(downloadBalaRequest, balaUrl.get());
            this.logResponseVerbose(balaDownloadResponse, null);
            if (balaDownloadResponse.code() == 200) {
                isNightlyBuild = ballerinaVersion.contains("SNAPSHOT");
                Utils.createBalaInHomeRepo(balaDownloadResponse, packagePathInBalaCache, org, name, isNightlyBuild, isDeprecated != false ? deprecationMessage : null, balaUrl.get(), balaFileName.get(), enableOutputStream != false ? this.outStream : null, logFormatter, digestVal);
                return;
            }
            try {
                block20: {
                    errorMessage = logFormatter.formatLog("error: failed to pull the package: '" + packageSignature + "'. BALA content download from '" + balaUrl.get() + "' failed.");
                    this.handleResponseErrors(balaDownloadResponse, errorMessage);
                    break block20;
lbl53:
                    // 1 sources

                    errorMsg = logFormatter.formatLog("error: failed to pull the package: '" + packageSignature + "' from the remote repository '" + url + "'. reason: bala file location is missing.");
                    throw new CentralClientException(errorMsg);
                }
                if (packagePullResponse.code() == 401) {
                    this.handleUnauthorizedResponse(org, body, pkgPullResBodyContent);
                }
                if (body.isPresent() && (contentType = Optional.ofNullable(((ResponseBody)body.get()).contentType())).isPresent() && Utils.isApplicationJsonContentType(contentType.get().toString())) {
                    if (!(packagePullResponse.code() != 400 && packagePullResponse.code() != 404 || (error = (Error)new Gson().fromJson(pkgPullResBodyContent, Error.class)).getMessage() == null || "".equals(error.getMessage()))) {
                        throw new CentralClientException("error: " + error.getMessage());
                    }
                    if (!(packagePullResponse.code() != 500 && packagePullResponse.code() != 503 || (error = (Error)new Gson().fromJson(pkgPullResBodyContent, Error.class)).getMessage() == null || "".equals(error.getMessage()))) {
                        errorMsg = logFormatter.formatLog("error: failed to pull the package: '" + packageSignature + "' from the remote repository '" + url + "'. reason: " + error.getMessage());
                        throw new CentralClientException(errorMsg);
                    }
                }
                errorMsg = logFormatter.formatLog("error: failed to pull the package: '" + packageSignature + "' from the remote repository '" + url + "'.");
                throw new CentralClientException(errorMsg);
            }
            catch (IOException e) {
                throw new CentralClientException(e.getMessage());
            }
        }
        finally {
            body.ifPresent((Consumer<ResponseBody>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, close(), (Lokhttp3/ResponseBody;)V)());
            try {
                this.closeClient(client);
            }
            catch (IOException var31_34) {}
        }
    }

    public String[] pullTool(String toolId, String version, Path balaCacheDirPath, String supportedPlatform, String ballerinaVersion, boolean isBuild) throws CentralClientException {
        String[] result = new String[]{};
        for (int retryCount = 0; retryCount <= this.maxRetries; ++retryCount) {
            try {
                result = this.pullToolInternal(toolId, version, balaCacheDirPath, supportedPlatform, ballerinaVersion, isBuild);
                break;
            }
            catch (CentralClientException centralClientException) {
                if (centralClientException.getMessage().contains(CONNECTION_RESET) && retryCount < this.maxRetries) {
                    if (!this.verboseEnabled) continue;
                    this.outStream.println("* Retrying to pull the tool: " + toolId + ":" + version + " due to: " + centralClientException.getMessage() + ". Retry attempt: " + (retryCount + 1));
                    this.outStream.println();
                    continue;
                }
                throw centralClientException;
            }
        }
        return result;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private String[] pullToolInternal(String toolId, String version, Path balaCacheDirPath, String supportedPlatform, String ballerinaVersion, boolean isBuild) throws CentralClientException {
        resourceUrl = "/tools/" + toolId;
        enableOutputStream = Boolean.parseBoolean(System.getProperty("enableOutputStream"));
        toolSignature = toolId;
        url = this.baseUrl + resourceUrl;
        if (null != version && !version.isEmpty()) {
            url = url + "/" + version;
            toolSignature = (String)toolSignature + ":" + version;
        }
        body = Optional.empty();
        client = this.getClient();
        try {
            block24: {
                logFormatter = new LogFormatter();
                if (isBuild) {
                    logFormatter = new BuildLogFormatter();
                }
                packagePullReq = this.getNewRequest(supportedPlatform, ballerinaVersion).get().url(url).addHeader("Content-Type", "application/json").build();
                this.logRequestInitVerbose(packagePullReq);
                toolPullReqCall = client.newCall(packagePullReq);
                packagePullResponse = toolPullReqCall.execute();
                this.logRequestConnectVerbose(packagePullReq, resourceUrl);
                body = Optional.ofNullable(packagePullResponse.body());
                pkgPullResBodyContent = null;
                if (body.isPresent()) {
                    pkgPullResBodyContent = ((ResponseBody)body.get()).string();
                }
                this.logResponseVerbose(packagePullResponse, pkgPullResBodyContent);
                if (packagePullResponse.code() != 200) ** GOTO lbl70
                org = Optional.empty();
                pkgName = Optional.empty();
                latestVersion = Optional.empty();
                balaUrl = Optional.empty();
                platform /* !! */  = Optional.empty();
                digest = "";
                if (body.isPresent() && (contentType = Optional.ofNullable(((ResponseBody)body.get()).contentType())).isPresent() && Utils.isApplicationJsonContentType(contentType.get().toString())) {
                    jsonContent = (JsonObject)new Gson().fromJson(pkgPullResBodyContent, JsonObject.class);
                    org = Optional.ofNullable(jsonContent.get("organization").getAsString());
                    pkgName = Optional.ofNullable(jsonContent.get("name").getAsString());
                    latestVersion = Optional.ofNullable(jsonContent.get("version").getAsString());
                    balaUrl = Optional.ofNullable(jsonContent.get("balaURL").getAsString());
                    platform /* !! */  = Optional.of(jsonContent.get("platform").getAsString()).or((Supplier<Optional>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$pullToolInternal$0(), ()Ljava/util/Optional;)());
                    digest = Optional.ofNullable(jsonContent.get("digest").getAsString()).orElse("");
                }
                if (!balaUrl.isPresent() || !org.isPresent() || !latestVersion.isPresent() || !pkgName.isPresent()) ** GOTO lbl68
                balaFileName = "attachment; filename=" + (String)org.get() + "-" + (String)pkgName.get() + "-" + (String)platform /* !! */ .get() + "-" + (String)latestVersion.get() + ".bala";
                downloadBalaRequest = this.getNewRequest(supportedPlatform, ballerinaVersion).get().url((String)balaUrl.get()).header("Accept-Encoding", "identity").addHeader("Content-Disposition", balaFileName).build();
                this.logRequestInitVerbose(downloadBalaRequest);
                downloadBalaRequestCall = client.newCall(downloadBalaRequest);
                balaDownloadResponse = downloadBalaRequestCall.execute();
                this.logRequestConnectVerbose(downloadBalaRequest, (String)balaUrl.get());
                this.logResponseVerbose(balaDownloadResponse, null);
                packagePathInBalaCache = balaCacheDirPath.resolve((String)org.get()).resolve((String)pkgName.get());
                if (balaDownloadResponse.code() == 200) {
                    isNightlyBuild = ballerinaVersion.contains("SNAPSHOT");
                    try {
                        Utils.createBalaInHomeRepo(balaDownloadResponse, packagePathInBalaCache, (String)org.get(), (String)pkgName.get(), isNightlyBuild, null, (String)balaUrl.get(), balaFileName, enableOutputStream != false ? this.outStream : null, logFormatter, digest);
                        var30_32 = new String[]{String.valueOf(true), (String)org.get(), (String)pkgName.get(), (String)latestVersion.get()};
                        return var30_32;
                    }
                    catch (PackageAlreadyExistsException ignore) {
                        var31_35 = new String[]{String.valueOf(false), (String)org.get(), (String)pkgName.get(), (String)latestVersion.get()};
                        body.ifPresent((Consumer<ResponseBody>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, close(), (Lokhttp3/ResponseBody;)V)());
                        try {
                            this.closeClient(client);
                        }
                        catch (IOException var32_36) {
                            // empty catch block
                        }
                        return var31_35;
                    }
                }
                errorMessage = logFormatter.formatLog("error: failed to pull the package: '" + (String)toolSignature + "'. BALA content download from '" + (String)balaUrl.get() + "' failed.");
                this.handleResponseErrors(balaDownloadResponse, errorMessage);
                break block24;
lbl68:
                // 1 sources

                errorMsg = logFormatter.formatLog("error: failed to pull the package: '" + (String)toolSignature + "' from the remote repository '" + url + "'. reason: bala file location is missing.");
                throw new CentralClientException(errorMsg);
            }
            if (packagePullResponse.code() == 401) {
                this.handleUnauthorizedResponse(body, pkgPullResBodyContent);
            }
            if (body.isPresent() && (contentType = Optional.ofNullable(((ResponseBody)body.get()).contentType())).isPresent() && Utils.isApplicationJsonContentType(contentType.get().toString())) {
                if (!(packagePullResponse.code() != 400 && packagePullResponse.code() != 404 || (error = (Error)new Gson().fromJson(pkgPullResBodyContent, Error.class)).getMessage() == null || "".equals(error.getMessage()))) {
                    throw new CentralClientException("error: " + error.getMessage());
                }
                if (!(packagePullResponse.code() != 500 && packagePullResponse.code() != 503 || (error = (Error)new Gson().fromJson(pkgPullResBodyContent, Error.class)).getMessage() == null || "".equals(error.getMessage()))) {
                    errorMsg = logFormatter.formatLog("error: failed to pull the package: '" + (String)toolSignature + "' from the remote repository '" + url + "'. reason: " + error.getMessage());
                    throw new CentralClientException(errorMsg);
                }
            }
            errorMsg = logFormatter.formatLog("error: failed to pull the package: '" + (String)toolSignature + "' from the remote repository '" + url + "'.");
            throw new CentralClientException(errorMsg);
            {
                catch (IOException e) {
                    throw new CentralClientException(e.getMessage());
                }
                catch (Throwable var33_37) {
                    throw var33_37;
                }
            }
        }
        finally {
            body.ifPresent((Consumer<ResponseBody>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, close(), (Lokhttp3/ResponseBody;)V)());
            try {
                this.closeClient(client);
            }
            catch (IOException var31_34) {}
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public PackageNameResolutionResponse resolvePackageNames(PackageNameResolutionRequest request, String supportedPlatform, String ballerinaVersion) throws CentralClientException {
        String url = this.baseUrl + "/packages/resolve-modules";
        Optional<Object> body = Optional.empty();
        OkHttpClient client = this.getClient();
        try {
            Optional<MediaType> contentType;
            RequestBody requestBody = RequestBody.create((MediaType)JSON, (String)new Gson().toJson((Object)request));
            Request resolutionReq = this.getNewRequest(supportedPlatform, ballerinaVersion).post(requestBody).url(url).addHeader("Accept-Encoding", "identity").addHeader("Accept", "application/json").build();
            this.logRequestInitVerbose(resolutionReq);
            Call resolutionReqCall = client.newCall(resolutionReq);
            Response packageResolutionResponse = resolutionReqCall.execute();
            this.logRequestConnectVerbose(resolutionReq, "/packages/resolve-modules");
            body = Optional.ofNullable(packageResolutionResponse.body());
            String resolvePackageNamesBody = null;
            if (body.isPresent()) {
                resolvePackageNamesBody = ((ResponseBody)body.get()).string();
            }
            this.logResponseVerbose(packageResolutionResponse, resolvePackageNamesBody);
            if (!body.isPresent() || !(contentType = Optional.ofNullable(((ResponseBody)body.get()).contentType())).isPresent() || !Utils.isApplicationJsonContentType(contentType.get().toString())) throw new ConnectionErrorException(ERR_PACKAGE_RESOLUTION);
            if (packageResolutionResponse.code() == 200) {
                PackageNameResolutionResponse packageNameResolutionResponse = (PackageNameResolutionResponse)new Gson().fromJson(resolvePackageNamesBody, PackageNameResolutionResponse.class);
                return packageNameResolutionResponse;
            }
            try {
                Error error;
                if (packageResolutionResponse.code() == 401) {
                    this.handleUnauthorizedResponse(contentType.get(), resolvePackageNamesBody);
                }
                if (packageResolutionResponse.code() == 400 && (error = (Error)new Gson().fromJson(resolvePackageNamesBody, Error.class)).getMessage() != null && !"".equals(error.getMessage())) {
                    throw new ConnectionErrorException(error.getMessage());
                }
                if (packageResolutionResponse.code() != 500 && packageResolutionResponse.code() != 503 || (error = (Error)new Gson().fromJson(resolvePackageNamesBody, Error.class)).getMessage() == null || "".equals(error.getMessage())) throw new ConnectionErrorException(ERR_PACKAGE_RESOLUTION);
                throw new ConnectionErrorException("error: while connecting to central:  reason:" + error.getMessage());
            }
            catch (IOException e) {
                throw new ConnectionErrorException("error: while connecting to central: . reason: " + e.getMessage());
            }
        }
        finally {
            body.ifPresent(ResponseBody::close);
            try {
                this.closeClient(client);
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public PackageResolutionResponse resolveDependencies(PackageResolutionRequest request, String supportedPlatform, String ballerinaVersion) throws CentralClientException {
        String url = this.baseUrl + "/packages/resolve-dependencies";
        Optional<Object> body = Optional.empty();
        OkHttpClient client = this.getClient();
        try {
            Optional<MediaType> contentType;
            RequestBody requestBody = RequestBody.create((MediaType)JSON, (String)new Gson().toJson((Object)request));
            Request packageResolutionReq = this.getNewRequest(supportedPlatform, ballerinaVersion).post(requestBody).url(url).addHeader("Accept-Encoding", "identity").addHeader("Accept", "application/json").build();
            this.logRequestInitVerbose(packageResolutionReq);
            Call packageResolutionReqCall = client.newCall(packageResolutionReq);
            Response packageResolutionResponse = packageResolutionReqCall.execute();
            this.logRequestConnectVerbose(packageResolutionReq, "/packages/resolve-dependencies");
            body = Optional.ofNullable(packageResolutionResponse.body());
            String packageResolutionResponseBody = null;
            if (body.isPresent()) {
                packageResolutionResponseBody = ((ResponseBody)body.get()).string();
            }
            this.logResponseVerbose(packageResolutionResponse, packageResolutionResponseBody);
            if (!body.isPresent() || !(contentType = Optional.ofNullable(((ResponseBody)body.get()).contentType())).isPresent() || !Utils.isApplicationJsonContentType(contentType.get().toString())) throw new ConnectionErrorException(ERR_PACKAGE_RESOLUTION);
            if (packageResolutionResponse.code() == 200) {
                PackageResolutionResponse packageResolutionResponse2 = (PackageResolutionResponse)new Gson().fromJson(packageResolutionResponseBody, PackageResolutionResponse.class);
                return packageResolutionResponse2;
            }
            try {
                Error error;
                if (packageResolutionResponse.code() == 401) {
                    this.handleUnauthorizedResponse(contentType.get(), packageResolutionResponseBody);
                }
                if (packageResolutionResponse.code() == 400 && (error = (Error)new Gson().fromJson(packageResolutionResponseBody, Error.class)).getMessage() != null && !"".equals(error.getMessage())) {
                    throw new ConnectionErrorException(error.getMessage());
                }
                if (packageResolutionResponse.code() != 500 && packageResolutionResponse.code() != 503 || (error = (Error)new Gson().fromJson(packageResolutionResponseBody, Error.class)).getMessage() == null || "".equals(error.getMessage())) throw new ConnectionErrorException(ERR_PACKAGE_RESOLUTION);
                throw new ConnectionErrorException("error: while connecting to central:  reason:" + error.getMessage());
            }
            catch (IOException e) {
                throw new ConnectionErrorException("error: while connecting to central: . reason: " + e.getMessage());
            }
        }
        finally {
            body.ifPresent(ResponseBody::close);
            try {
                this.closeClient(client);
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ToolResolutionCentralResponse resolveToolDependencies(ToolResolutionCentralRequest request, String supportedPlatform, String ballerinaVersion) throws CentralClientException {
        String url = this.baseUrl + "/tools/resolve-dependencies";
        Optional<Object> body = Optional.empty();
        OkHttpClient client = this.getClient();
        try {
            Optional<MediaType> contentType;
            RequestBody requestBody = RequestBody.create((MediaType)JSON, (String)new Gson().toJson((Object)request));
            Request toolResolutionReq = this.getNewRequest(supportedPlatform, ballerinaVersion).post(requestBody).url(url).addHeader("Accept-Encoding", "identity").addHeader("Accept", "application/json").build();
            this.logRequestInitVerbose(toolResolutionReq);
            Call toolResolutionReqCall = client.newCall(toolResolutionReq);
            Response toolResolutionResponse = toolResolutionReqCall.execute();
            this.logRequestConnectVerbose(toolResolutionReq, "/tools/resolve-dependencies");
            body = Optional.ofNullable(toolResolutionResponse.body());
            String toolResolutionResponseBody = null;
            if (body.isPresent()) {
                toolResolutionResponseBody = ((ResponseBody)body.get()).string();
            }
            this.logResponseVerbose(toolResolutionResponse, toolResolutionResponseBody);
            if (!body.isPresent() || !(contentType = Optional.ofNullable(((ResponseBody)body.get()).contentType())).isPresent() || !Utils.isApplicationJsonContentType(contentType.get().toString())) throw new ConnectionErrorException(ERR_PACKAGE_RESOLUTION);
            if (toolResolutionResponse.code() == 200) {
                ToolResolutionCentralResponse toolResolutionCentralResponse = (ToolResolutionCentralResponse)new Gson().fromJson(toolResolutionResponseBody, ToolResolutionCentralResponse.class);
                return toolResolutionCentralResponse;
            }
            try {
                Error error;
                if (toolResolutionResponse.code() == 401) {
                    this.handleUnauthorizedResponse(contentType.get(), toolResolutionResponseBody);
                }
                if (toolResolutionResponse.code() == 400 && (error = (Error)new Gson().fromJson(toolResolutionResponseBody, Error.class)).getMessage() != null && !"".equals(error.getMessage())) {
                    throw new ConnectionErrorException(error.getMessage());
                }
                if (toolResolutionResponse.code() != 500 && toolResolutionResponse.code() != 503 || (error = (Error)new Gson().fromJson(toolResolutionResponseBody, Error.class)).getMessage() == null || "".equals(error.getMessage())) throw new ConnectionErrorException(ERR_PACKAGE_RESOLUTION);
                throw new ConnectionErrorException("error: while connecting to central:  reason:" + error.getMessage());
            }
            catch (IOException e) {
                throw new ConnectionErrorException("error: while connecting to central: . reason: " + e.getMessage());
            }
        }
        finally {
            body.ifPresent(ResponseBody::close);
            try {
                this.closeClient(client);
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public PackageSearchResult searchPackage(String query, String supportedPlatform, String ballerinaVersion) throws CentralClientException {
        Optional<Object> body = Optional.empty();
        OkHttpClient client = this.getClient();
        try {
            Optional<MediaType> contentType;
            Request searchReq = this.getNewRequest(supportedPlatform, ballerinaVersion).get().url(this.baseUrl + "/packages/?q=" + query).build();
            this.logRequestInitVerbose(searchReq);
            Call httpRequestCall = client.newCall(searchReq);
            Response searchResponse = httpRequestCall.execute();
            this.logRequestConnectVerbose(searchReq, "/packages/?q=" + query);
            body = Optional.ofNullable(searchResponse.body());
            String searchResponseBody = null;
            if (body.isPresent()) {
                searchResponseBody = ((ResponseBody)body.get()).string();
            }
            this.logResponseVerbose(searchResponse, searchResponseBody);
            if (!body.isPresent() || !(contentType = Optional.ofNullable(((ResponseBody)body.get()).contentType())).isPresent() || !Utils.isApplicationJsonContentType(contentType.get().toString())) throw new CentralClientException("error: failed to search packages: '" + query + "'.");
            if (searchResponse.code() == 200) {
                PackageSearchResult packageSearchResult = (PackageSearchResult)new Gson().fromJson(searchResponseBody, PackageSearchResult.class);
                return packageSearchResult;
            }
            try {
                Error error;
                if (searchResponse.code() == 401) {
                    this.handleUnauthorizedResponse(contentType.get(), searchResponseBody);
                }
                if (searchResponse.code() == 400 && (error = (Error)new Gson().fromJson(searchResponseBody, Error.class)).getMessage() != null && !"".equals(error.getMessage())) {
                    throw new CentralClientException(error.getMessage());
                }
                if (searchResponse.code() != 500 && searchResponse.code() != 503 || (error = (Error)new Gson().fromJson(searchResponseBody, Error.class)).getMessage() == null || "".equals(error.getMessage())) throw new CentralClientException("error: failed to search packages: '" + query + "'.");
                throw new CentralClientException("error: failed to search packages: '" + query + "' reason:" + error.getMessage());
            }
            catch (IOException e) {
                throw new CentralClientException("error: failed to search packages: '" + query + "'. reason: " + e.getMessage());
            }
        }
        finally {
            body.ifPresent(ResponseBody::close);
            try {
                this.closeClient(client);
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ToolSearchResult searchTool(String keyword, String supportedPlatform, String ballerinaVersion) throws CentralClientException {
        Optional<Object> body = Optional.empty();
        OkHttpClient client = this.getClient();
        try {
            Optional<MediaType> contentType;
            Request searchReq = this.getNewRequest(supportedPlatform, ballerinaVersion).get().url(this.baseUrl + "/tools?q=" + keyword).build();
            this.logRequestInitVerbose(searchReq);
            Call httpRequestCall = client.newCall(searchReq);
            Response searchResponse = httpRequestCall.execute();
            this.logRequestConnectVerbose(searchReq, "/tools/?q=/" + keyword);
            body = Optional.ofNullable(searchResponse.body());
            String searchResponseBody = null;
            if (body.isPresent()) {
                searchResponseBody = ((ResponseBody)body.get()).string();
            }
            this.logResponseVerbose(searchResponse, searchResponseBody);
            if (!body.isPresent() || !(contentType = Optional.ofNullable(((ResponseBody)body.get()).contentType())).isPresent() || !Utils.isApplicationJsonContentType(contentType.get().toString())) throw new CentralClientException("error: failed to search packages: '" + keyword + "'.");
            if (searchResponse.code() == 200) {
                ToolSearchResult toolSearchResult = (ToolSearchResult)new Gson().fromJson(searchResponseBody, ToolSearchResult.class);
                return toolSearchResult;
            }
            try {
                Error error;
                if (searchResponse.code() == 401) {
                    this.handleUnauthorizedResponse(contentType.get(), searchResponseBody);
                }
                if (searchResponse.code() == 400 && (error = (Error)new Gson().fromJson(searchResponseBody, Error.class)).getMessage() != null && !"".equals(error.getMessage())) {
                    throw new CentralClientException(error.getMessage());
                }
                if (searchResponse.code() != 500 && searchResponse.code() != 503 || (error = (Error)new Gson().fromJson(searchResponseBody, Error.class)).getMessage() == null || "".equals(error.getMessage())) throw new CentralClientException("error: failed to search packages: '" + keyword + "'.");
                throw new CentralClientException("error: failed to search packages: '" + keyword + "' reason:" + error.getMessage());
            }
            catch (IOException e) {
                throw new CentralClientException("error: failed to search packages: '" + keyword + "'. reason: " + e.getMessage());
            }
        }
        finally {
            body.ifPresent(ResponseBody::close);
            try {
                this.closeClient(client);
            }
            catch (IOException iOException) {}
        }
    }

    public void deprecatePackage(String packageInfo, String deprecationMsg, String supportedPlatform, String ballerinaVersion, Boolean isUndo) throws CentralClientException {
        String packageValue;
        Package existingPackage = this.getPackage(packageInfo.split(SEPARATOR)[0], packageInfo.split(SEPARATOR)[1].split(":")[0], packageInfo.split(SEPARATOR)[1].split(":")[1], supportedPlatform, ballerinaVersion);
        String string = packageValue = packageInfo.endsWith(":*") ? packageInfo.substring(0, packageInfo.length() - 2) : packageInfo;
        if (isUndo.booleanValue() && !existingPackage.getDeprecated().booleanValue()) {
            this.outStream.println("package " + packageValue + " is not marked as deprecated in central");
            return;
        }
        Optional<Object> body = Optional.empty();
        OkHttpClient client = this.getClient();
        try {
            Optional<MediaType> contentType;
            RequestBody requestBody;
            String requestURL;
            if (isUndo.booleanValue()) {
                requestURL = this.baseUrl + "/packages/undeprecate/" + packageInfo.replace(":", SEPARATOR);
                requestBody = RequestBody.create((MediaType)JSON, (String)"{}");
            } else {
                requestBody = RequestBody.create((MediaType)JSON, (String)("{\"message\": \"" + deprecationMsg + "\"}"));
                requestURL = this.baseUrl + "/packages/deprecate/" + packageInfo.replace(":", SEPARATOR);
            }
            Request deprecationReq = this.getNewRequest(supportedPlatform, ballerinaVersion).put(requestBody).url(requestURL).addHeader("Accept-Encoding", "identity").addHeader("Accept", "application/json").build();
            this.logRequestInitVerbose(deprecationReq);
            Call httpRequestCall = client.newCall(deprecationReq);
            Response deprecationResponse = httpRequestCall.execute();
            this.logRequestConnectVerbose(deprecationReq, requestURL.replace(this.baseUrl, ""));
            body = Optional.ofNullable(deprecationResponse.body());
            String deprecationResponseBody = null;
            if (body.isPresent()) {
                deprecationResponseBody = ((ResponseBody)body.get()).string();
            }
            this.logResponseVerbose(deprecationResponse, deprecationResponseBody);
            if (body.isPresent() && (contentType = Optional.ofNullable(((ResponseBody)body.get()).contentType())).isPresent() && Utils.isApplicationJsonContentType(contentType.get().toString())) {
                Error error;
                if (deprecationResponse.code() == 200) {
                    Package packageResponse = (Package)new Gson().fromJson(deprecationResponseBody, Package.class);
                    if (packageResponse.getDeprecated().booleanValue()) {
                        if (existingPackage.getDeprecated().booleanValue()) {
                            this.outStream.println("deprecation message is successfully updated for the package " + packageValue + " in central");
                        } else {
                            this.outStream.println("package " + packageValue + " marked as deprecated in central successfully");
                        }
                    } else {
                        this.outStream.println("deprecation of the package " + packageValue + " is successfully undone in central");
                    }
                }
                if (deprecationResponse.code() == 401) {
                    this.handleUnauthorizedResponse(contentType.get(), deprecationResponseBody);
                }
                if (deprecationResponse.code() == 400 && (error = (Error)new Gson().fromJson(deprecationResponseBody, Error.class)).getMessage() != null && !"".equals(error.getMessage())) {
                    throw new CentralClientException(error.getMessage());
                }
                if (deprecationResponse.code() == 404 && (error = (Error)new Gson().fromJson(deprecationResponseBody, Error.class)).getMessage() != null && !"".equals(error.getMessage())) {
                    throw new CentralClientException(error.getMessage());
                }
                if (!(deprecationResponse.code() != 500 && deprecationResponse.code() != 503 || (error = (Error)new Gson().fromJson(deprecationResponseBody, Error.class)).getMessage() == null || "".equals(error.getMessage()))) {
                    String errorMsg = isUndo != false ? ERR_PACKAGE_UN_DEPRECATE : ERR_PACKAGE_DEPRECATE;
                    throw new CentralClientException(errorMsg + "'" + packageValue + "' reason:" + error.getMessage());
                }
            }
        }
        catch (IOException e) {
            String errorMsg = isUndo != false ? ERR_PACKAGE_UN_DEPRECATE : ERR_PACKAGE_DEPRECATE;
            throw new CentralClientException(errorMsg + "'" + packageValue + "'. reason: " + e.getMessage());
        }
        finally {
            body.ifPresent(ResponseBody::close);
            try {
                this.closeClient(client);
            }
            catch (IOException iOException) {}
        }
    }

    public JsonElement getCentralPackagesUsingGraphQL(String query, String supportedPlatform, String ballerinaVersion) throws CentralClientException {
        JsonObject jsonObject;
        Optional<ResponseBody> body = Optional.empty();
        OkHttpClient client = new OkHttpClient.Builder().followRedirects(false).connectTimeout((long)this.callTimeout, TimeUnit.SECONDS).readTimeout((long)this.readTimeout, TimeUnit.SECONDS).writeTimeout((long)this.writeTimeout, TimeUnit.SECONDS).callTimeout((long)this.callTimeout, TimeUnit.SECONDS).proxy(this.proxy).build();
        try {
            MediaType contentType;
            HttpUrl.Builder httpUrl = Objects.requireNonNull(HttpUrl.parse((String)this.baseUrl)).newBuilder();
            Request request = this.getNewRequest(supportedPlatform, ballerinaVersion).url(httpUrl.build()).post(RequestBody.create((MediaType)JSON_CONTENT_TYPE, (byte[])query.getBytes(StandardCharsets.UTF_8))).build();
            Call httpRequest = client.newCall(request);
            Response response = httpRequest.execute();
            ResponseBody responseBody = response.body();
            Optional<Object> optional = body = responseBody != null ? Optional.of(responseBody) : Optional.empty();
            if (body.isPresent() && (contentType = ((ResponseBody)body.get()).contentType()) != null && Utils.isApplicationJsonContentType(contentType.toString()) && response.code() == 200) {
                JsonElement jsonElement = new Gson().toJsonTree((Object)((ResponseBody)body.get()).string());
                return jsonElement;
            }
            this.handleResponseErrors(response, ERR_CANNOT_SEARCH);
            jsonObject = new JsonObject();
        }
        catch (IOException e) {
            throw new CentralClientException("error: failed to search packages: '. Reason: " + e.getMessage());
        }
        finally {
            body.ifPresent(ResponseBody::close);
            try {
                this.closeClient(client);
            }
            catch (IOException iOException) {}
        }
        return jsonObject;
    }

    public JsonElement getConnectors(Map<String, String> params, String supportedPlatform, String ballerinaVersion) throws CentralClientException {
        JsonArray jsonArray;
        Optional<Object> body = Optional.empty();
        OkHttpClient client = new OkHttpClient.Builder().followRedirects(false).connectTimeout((long)this.connectTimeout, TimeUnit.SECONDS).readTimeout((long)this.readTimeout, TimeUnit.SECONDS).writeTimeout((long)this.writeTimeout, TimeUnit.SECONDS).callTimeout((long)this.callTimeout, TimeUnit.SECONDS).proxy(this.proxy).build();
        try {
            Optional<MediaType> contentType;
            HttpUrl.Builder httpBuilder = Objects.requireNonNull(HttpUrl.parse((String)this.baseUrl)).newBuilder().addPathSegment(CONNECTORS);
            for (Map.Entry<String, String> param : params.entrySet()) {
                httpBuilder.addQueryParameter(param.getKey(), param.getValue());
            }
            Request searchReq = this.getNewRequest(supportedPlatform, ballerinaVersion).get().url(httpBuilder.build()).build();
            this.logRequestInitVerbose(searchReq);
            Call httpRequestCall = client.newCall(searchReq);
            Response searchResponse = httpRequestCall.execute();
            this.logRequestConnectVerbose(searchReq, "/connectors");
            body = Optional.ofNullable(searchResponse.body());
            String searchResponseBody = null;
            if (body.isPresent()) {
                searchResponseBody = ((ResponseBody)body.get()).string();
            }
            this.logResponseVerbose(searchResponse, searchResponseBody);
            if (body.isPresent() && (contentType = Optional.ofNullable(((ResponseBody)body.get()).contentType())).isPresent() && Utils.isApplicationJsonContentType(contentType.get().toString()) && searchResponse.code() == 200) {
                JsonElement jsonElement = new Gson().toJsonTree((Object)searchResponseBody);
                return jsonElement;
            }
            this.handleResponseErrors(searchResponse, ERR_CANNOT_GET_CONNECTOR);
            jsonArray = new JsonArray();
        }
        catch (IOException e) {
            throw new CentralClientException("error: failed to find connector: '. reason: " + e.getMessage());
        }
        finally {
            body.ifPresent(ResponseBody::close);
            try {
                this.closeClient(client);
            }
            catch (IOException iOException) {}
        }
        return jsonArray;
    }

    public JsonObject getConnector(String id, String supportedPlatform, String ballerinaVersion) throws CentralClientException {
        JsonObject jsonObject;
        Optional<Object> body = Optional.empty();
        OkHttpClient client = this.getClient();
        try {
            Optional<MediaType> contentType;
            Request searchReq = this.getNewRequest(supportedPlatform, ballerinaVersion).get().url(this.baseUrl + CONNECTOR_PATH_PREFIX + id).build();
            this.logRequestInitVerbose(searchReq);
            Call httpRequestCall = client.newCall(searchReq);
            Response searchResponse = httpRequestCall.execute();
            this.logRequestConnectVerbose(searchReq, CONNECTOR_PATH_PREFIX + id);
            body = Optional.ofNullable(searchResponse.body());
            String searchResponseBody = null;
            if (body.isPresent()) {
                searchResponseBody = ((ResponseBody)body.get()).string();
            }
            this.logResponseVerbose(searchResponse, searchResponseBody);
            if (body.isPresent() && (contentType = Optional.ofNullable(((ResponseBody)body.get()).contentType())).isPresent() && Utils.isApplicationJsonContentType(contentType.get().toString()) && searchResponse.code() == 200) {
                JsonObject jsonObject2 = (JsonObject)new Gson().fromJson(searchResponseBody, JsonObject.class);
                return jsonObject2;
            }
            this.handleResponseErrors(searchResponse, "error: failed to find connector:  id:" + id);
            jsonObject = new JsonObject();
        }
        catch (IOException e) {
            throw new CentralClientException("error: failed to find connector: '" + id + "'. reason: " + e.getMessage());
        }
        finally {
            body.ifPresent(ResponseBody::close);
            try {
                this.closeClient(client);
            }
            catch (IOException iOException) {}
        }
        return jsonObject;
    }

    public JsonObject getConnector(ConnectorInfo connector, String supportedPlatform, String ballerinaVersion) throws CentralClientException {
        JsonObject jsonObject;
        Optional<Object> body = Optional.empty();
        OkHttpClient client = this.getClient();
        try {
            Optional<MediaType> contentType;
            Request searchReq = this.getNewRequest(supportedPlatform, ballerinaVersion).get().url(this.baseUrl + CONNECTOR_PATH_PREFIX + connector.getOrgName() + SEPARATOR + connector.getPackageName() + SEPARATOR + connector.getVersion() + SEPARATOR + connector.getModuleName() + SEPARATOR + connector.getName()).build();
            this.logRequestInitVerbose(searchReq);
            Call httpRequestCall = client.newCall(searchReq);
            Response searchResponse = httpRequestCall.execute();
            this.logRequestConnectVerbose(searchReq, CONNECTOR_PATH_PREFIX + connector.getOrgName() + SEPARATOR + connector.getPackageName() + SEPARATOR + connector.getVersion() + SEPARATOR + connector.getModuleName() + SEPARATOR + connector.getName());
            body = Optional.ofNullable(searchResponse.body());
            String searchResponseBody = null;
            if (body.isPresent()) {
                searchResponseBody = ((ResponseBody)body.get()).string();
            }
            this.logResponseVerbose(searchResponse, searchResponseBody);
            if (body.isPresent() && (contentType = Optional.ofNullable(((ResponseBody)body.get()).contentType())).isPresent() && Utils.isApplicationJsonContentType(contentType.get().toString()) && searchResponse.code() == 200) {
                JsonObject jsonObject2 = (JsonObject)new Gson().fromJson(searchResponseBody, JsonObject.class);
                return jsonObject2;
            }
            this.handleResponseErrors(searchResponse, "error: failed to find connector:  " + connector.getPackageName());
            jsonObject = null;
        }
        catch (IOException e) {
            throw new CentralClientException("error: failed to find connector: '" + connector.getPackageName() + "'. reason: " + e.getMessage());
        }
        finally {
            body.ifPresent(ResponseBody::close);
            try {
                this.closeClient(client);
            }
            catch (IOException iOException) {}
        }
        return jsonObject;
    }

    protected OkHttpClient getClient() {
        OkHttpClient okHttpClient = new OkHttpClient.Builder().connectTimeout((long)this.connectTimeout, TimeUnit.SECONDS).readTimeout((long)this.readTimeout, TimeUnit.SECONDS).writeTimeout((long)this.writeTimeout, TimeUnit.SECONDS).callTimeout((long)this.callTimeout, TimeUnit.SECONDS).followRedirects(false).retryOnConnectionFailure(true).proxy(this.proxy).addInterceptor((Interceptor)new CustomRetryInterceptor(this.maxRetries)).build();
        if (!this.proxyUsername.isEmpty() && !this.proxyPassword.isEmpty()) {
            Authenticator proxyAuthenticator = (route, response) -> {
                if (response.request().header("Proxy-Authorization") != null) {
                    return null;
                }
                String credential = Credentials.basic((String)this.proxyUsername, (String)this.proxyPassword);
                return response.request().newBuilder().header("Proxy-Authorization", credential).build();
            };
            okHttpClient = okHttpClient.newBuilder().proxyAuthenticator(proxyAuthenticator).build();
        }
        return okHttpClient;
    }

    protected void handleResponseErrors(Response response, String msg) throws CentralClientException, IOException {
        Optional<ResponseBody> body = Optional.ofNullable(response.body());
        if (body.isPresent()) {
            Error error;
            String responseBody = body.get().string();
            MediaType contentType = body.get().contentType();
            if (!(response.code() != 400 && response.code() != 404 || (error = (Error)new Gson().fromJson(responseBody, Error.class)).getMessage() == null || "".equals(error.getMessage()))) {
                throw new CentralClientException(error.getMessage());
            }
            if (response.code() == 401) {
                this.handleUnauthorizedResponse(contentType, responseBody);
            }
            if (!(response.code() != 500 && response.code() != 503 && response.code() != 502 && response.code() != 504 || (error = (Error)new Gson().fromJson(responseBody, Error.class)).getMessage() == null || "".equals(error.getMessage()))) {
                throw new CentralClientException(msg + " reason:" + error.getMessage());
            }
        }
        throw new CentralClientException(msg);
    }

    protected void closeClient(OkHttpClient client) throws IOException {
        client.dispatcher().executorService().shutdown();
        client.connectionPool().evictAll();
        Optional<Cache> clientCache = Optional.ofNullable(client.cache());
        if (clientCache.isPresent()) {
            clientCache.get().close();
        }
    }

    protected Request.Builder getNewRequest(String supportedPlatform, String ballerinaVersion) {
        Request.Builder requestBuilder = new Request.Builder().addHeader("Ballerina-Platform", supportedPlatform).addHeader("User-Agent", ballerinaVersion).addHeader("Ballerina-Central-Telemetry-Disabled", String.valueOf(Utils.SET_TEST_MODE_ACTIVE));
        if (!this.accessToken.isEmpty()) {
            requestBuilder.addHeader("Authorization", Utils.getBearerToken(this.accessToken));
        }
        return requestBuilder;
    }

    public String accessToken() {
        return this.accessToken;
    }

    public void setAccessToken(String accessToken) {
        this.accessToken = accessToken;
    }

    public JsonElement getTriggers(Map<String, String> params, String supportedPlatform, String ballerinaVersion) throws CentralClientException {
        JsonArray jsonArray;
        Optional<Object> body = Optional.empty();
        OkHttpClient client = new OkHttpClient.Builder().followRedirects(false).connectTimeout((long)this.connectTimeout, TimeUnit.SECONDS).readTimeout((long)this.readTimeout, TimeUnit.SECONDS).writeTimeout((long)this.writeTimeout, TimeUnit.SECONDS).callTimeout((long)this.callTimeout, TimeUnit.SECONDS).proxy(this.proxy).build();
        try {
            Optional<MediaType> contentType;
            HttpUrl.Builder httpBuilder = Objects.requireNonNull(HttpUrl.parse((String)this.baseUrl)).newBuilder().addPathSegment(TRIGGERS);
            for (Map.Entry<String, String> param : params.entrySet()) {
                httpBuilder.addQueryParameter(param.getKey(), param.getValue());
            }
            Request searchReq = this.getNewRequest(supportedPlatform, ballerinaVersion).get().url(httpBuilder.build()).build();
            this.logRequestInitVerbose(searchReq);
            Call httpRequestCall = client.newCall(searchReq);
            Response searchResponse = httpRequestCall.execute();
            this.logRequestConnectVerbose(searchReq, "/triggers");
            body = Optional.ofNullable(searchResponse.body());
            String searchResponseBody = null;
            if (body.isPresent()) {
                searchResponseBody = ((ResponseBody)body.get()).string();
            }
            this.logResponseVerbose(searchResponse, searchResponseBody);
            if (body.isPresent() && (contentType = Optional.ofNullable(((ResponseBody)body.get()).contentType())).isPresent() && Utils.isApplicationJsonContentType(contentType.get().toString()) && searchResponse.code() == 200) {
                JsonElement jsonElement = new Gson().toJsonTree((Object)searchResponseBody);
                return jsonElement;
            }
            this.handleResponseErrors(searchResponse, ERR_CANNOT_GET_TRIGGERS);
            jsonArray = new JsonArray();
        }
        catch (IOException e) {
            throw new CentralClientException("error: failed to find triggers: '. reason: " + e.getMessage());
        }
        finally {
            body.ifPresent(ResponseBody::close);
            try {
                this.closeClient(client);
            }
            catch (IOException iOException) {}
        }
        return jsonArray;
    }

    public JsonObject getTrigger(String id, String supportedPlatform, String ballerinaVersion) throws CentralClientException {
        JsonObject jsonObject;
        Optional<Object> body = Optional.empty();
        OkHttpClient client = this.getClient();
        try {
            Optional<MediaType> contentType;
            Request searchReq = this.getNewRequest(supportedPlatform, ballerinaVersion).get().url(this.baseUrl + TRIGGER_PATH_PREFIX + id).build();
            this.logRequestInitVerbose(searchReq);
            Call httpRequestCall = client.newCall(searchReq);
            Response searchResponse = httpRequestCall.execute();
            this.logRequestConnectVerbose(searchReq, TRIGGER_PATH_PREFIX + id);
            body = Optional.ofNullable(searchResponse.body());
            String searchResponseBody = null;
            if (body.isPresent()) {
                searchResponseBody = ((ResponseBody)body.get()).string();
            }
            this.logResponseVerbose(searchResponse, searchResponseBody);
            if (body.isPresent() && (contentType = Optional.ofNullable(((ResponseBody)body.get()).contentType())).isPresent() && Utils.isApplicationJsonContentType(contentType.get().toString()) && searchResponse.code() == 200) {
                JsonObject jsonObject2 = (JsonObject)new Gson().fromJson(searchResponseBody, JsonObject.class);
                return jsonObject2;
            }
            this.handleResponseErrors(searchResponse, "error: failed to find the trigger:  id:" + id);
            jsonObject = new JsonObject();
        }
        catch (IOException e) {
            throw new CentralClientException("error: failed to find the trigger: '" + id + "'. reason: " + e.getMessage());
        }
        finally {
            body.ifPresent(ResponseBody::close);
            try {
                this.closeClient(client);
            }
            catch (IOException iOException) {}
        }
        return jsonObject;
    }

    private void handleUnauthorizedResponse(String org, Optional<ResponseBody> body, String responseBody) throws CentralClientException {
        if (body.isPresent()) {
            Optional<MediaType> contentType = Optional.ofNullable(body.get().contentType());
            if (contentType.isPresent() && Utils.isApplicationJsonContentType(contentType.get().toString())) {
                Error error = (Error)new Gson().fromJson(responseBody, Error.class);
                throw new CentralClientException("unauthorized access token for organization: '" + org + "'. check access token set in 'Settings.toml' file. reason: " + error.getMessage());
            }
            throw new CentralClientException("unauthorized access token for organization: '" + org + "'. check access token set in 'Settings.toml' file.");
        }
    }

    private void handleUnauthorizedResponse(Optional<ResponseBody> body, String responseBody) throws CentralClientException {
        if (body.isPresent()) {
            Optional<MediaType> contentType = Optional.ofNullable(body.get().contentType());
            if (contentType.isPresent() && Utils.isApplicationJsonContentType(contentType.get().toString())) {
                Error error = (Error)new Gson().fromJson(responseBody, Error.class);
                throw new CentralClientException("unauthorized access token. check access token set in 'Settings.toml' file. reason: " + error.getMessage());
            }
            throw new CentralClientException("unauthorized access token. check access token set in 'Settings.toml' file.");
        }
    }

    private void handleUnauthorizedResponse(MediaType mediaType, String responseBody) throws CentralClientException {
        Optional<MediaType> contentType = Optional.ofNullable(mediaType);
        StringBuilder message = new StringBuilder("unauthorized access token. check access token set in 'Settings.toml' file.");
        if (contentType.isPresent() && Utils.isApplicationJsonContentType(contentType.get().toString())) {
            Error error = (Error)new Gson().fromJson(responseBody, Error.class);
            message.append("reason: ").append(error.getMessage());
        }
        throw new CentralClientException(message.toString());
    }

    private void logResponseVerbose(Response response, String bodyContent) {
        if (this.verboseEnabled) {
            Optional<ResponseBody> body = Optional.ofNullable(response.body());
            this.outStream.println("< HTTP " + response.code() + " " + response.message());
            if (body.isPresent()) {
                for (String headerName : response.headers().names()) {
                    this.outStream.println("> " + headerName + ": " + response.header(headerName));
                }
                this.outStream.println("< ");
                if (bodyContent != null && !bodyContent.isEmpty()) {
                    this.outStream.println(bodyContent);
                }
                this.outStream.println("* Connection to host " + this.baseUrl + " left intact \n");
            }
        }
    }

    private void logRequestInitVerbose(Request request) {
        if (this.verboseEnabled) {
            this.outStream.println("* Trying " + String.valueOf(request.url()));
        }
    }

    private void logRequestConnectVerbose(Request request, String resourceUrl) {
        if (this.verboseEnabled) {
            this.outStream.println("* Connected to " + this.baseUrl);
            this.outStream.println("> " + request.method() + " " + resourceUrl + " HTTP");
            this.outStream.println("> Host: " + this.baseUrl);
            for (String headerName : request.headers().names()) {
                if (headerName.equals("Authorization")) {
                    this.outStream.println("> " + headerName + ": Bearer ************************************");
                    continue;
                }
                this.outStream.println("> " + headerName + ": " + request.header(headerName));
            }
            this.outStream.println(">");
        }
    }

    private static /* synthetic */ Optional lambda$pullToolInternal$0() {
        return Optional.of("any");
    }

    class CustomRetryInterceptor
    implements Interceptor {
        private final int maxRetries;

        CustomRetryInterceptor(int maxRetry) {
            this.maxRetries = maxRetry;
        }

        public Response intercept(Interceptor.Chain chain) throws IOException {
            int retryCount = 0;
            Request request = chain.request();
            Response response = null;
            while (retryCount <= this.maxRetries) {
                response = chain.proceed(request);
                if (response.code() < 500 || retryCount == this.maxRetries) {
                    return response;
                }
                ++retryCount;
                Optional<ResponseBody> body = Optional.ofNullable(response.body());
                String responseBodyString = null;
                if (body.isPresent()) {
                    responseBodyString = body.get().string();
                }
                this.logRetryVerbose(response, responseBodyString, request, retryCount);
                response.close();
            }
            return response;
        }

        private void logRetryVerbose(Response response, String bodyContent, Request request, int retryCount) {
            if (CentralAPIClient.this.verboseEnabled) {
                Optional<ResponseBody> body = Optional.ofNullable(response.body());
                CentralAPIClient.this.outStream.println("< HTTP " + response.code() + " " + response.message());
                if (body.isPresent()) {
                    for (String headerName : response.headers().names()) {
                        CentralAPIClient.this.outStream.println("> " + headerName + ": " + response.header(headerName));
                    }
                    CentralAPIClient.this.outStream.println("< ");
                    if (bodyContent != null && !bodyContent.isEmpty()) {
                        CentralAPIClient.this.outStream.println(bodyContent);
                    }
                    CentralAPIClient.this.outStream.println("* Connection to host " + CentralAPIClient.this.baseUrl + " left intact \n");
                }
                CentralAPIClient.this.outStream.println("* Retrying request to " + String.valueOf(request.url()) + " due to " + response.code() + " response code. Retry attempt: " + retryCount);
            }
        }
    }
}

