/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.maven.bala.client;

import java.io.PrintStream;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import me.tongfei.progressbar.ProgressBar;
import me.tongfei.progressbar.ProgressBarStyle;
import org.eclipse.aether.transfer.AbstractTransferListener;
import org.eclipse.aether.transfer.TransferEvent;
import org.eclipse.aether.transfer.TransferResource;

public class TransferListenerForClient
extends AbstractTransferListener {
    private static final String BALA_EXTENSION = "bala";
    private final PrintStream out;
    private final Map<TransferResource, Long> downloads = new ConcurrentHashMap<TransferResource, Long>();
    private final Map<String, ProgressBar> progressBars = new ConcurrentHashMap<String, ProgressBar>();
    private final Map<String, Long> progresses = new ConcurrentHashMap<String, Long>();

    public TransferListenerForClient() {
        this(System.out);
    }

    public TransferListenerForClient(PrintStream out) {
        this.out = out;
    }

    @Override
    public void transferProgressed(TransferEvent event) {
        TransferResource resource = event.getResource();
        if (resource.getFile().getName().contains(BALA_EXTENSION)) {
            this.downloads.put(resource, event.getTransferredBytes());
            for (Map.Entry<TransferResource, Long> entry : this.downloads.entrySet()) {
                String currentResource = entry.getKey().getResourceName();
                if (this.progressBars.get(currentResource) == null) {
                    String[] files = currentResource.split("/");
                    this.progressBars.put(currentResource, new ProgressBar(files[files.length - 1], this.getKB(entry.getKey().getContentLength()), 1000, this.out, ProgressBarStyle.ASCII, " KB", 1L));
                }
                long transferredLength = this.getKB(event.getTransferredBytes());
                Long previousStep = this.progresses.get(currentResource) == null ? 0L : this.progresses.get(currentResource);
                this.progressBars.get(currentResource).stepBy(transferredLength - previousStep);
                this.progresses.put(currentResource, transferredLength);
            }
        }
    }

    @Override
    public void transferSucceeded(TransferEvent event) {
        TransferResource resource = event.getResource();
        if (resource.getFile().getName().contains(BALA_EXTENSION)) {
            this.progressBars.get(resource.getResourceName()).close();
        }
    }

    private long getKB(long bytes) {
        return (bytes + 1023L) / 1024L;
    }
}

