/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.internal.impl.synccontext.named;

import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Deque;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.SyncContext;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.internal.impl.synccontext.named.NameMapper;
import org.eclipse.aether.internal.impl.synccontext.named.SessionAwareNamedLockFactory;
import org.eclipse.aether.metadata.Metadata;
import org.eclipse.aether.named.NamedLock;
import org.eclipse.aether.named.NamedLockFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class NamedLockFactoryAdapter {
    private final NameMapper nameMapper;
    private final NamedLockFactory namedLockFactory;
    private final long time;
    private final TimeUnit timeUnit;

    public NamedLockFactoryAdapter(NameMapper nameMapper, NamedLockFactory namedLockFactory, long time, TimeUnit timeUnit) {
        this.nameMapper = Objects.requireNonNull(nameMapper);
        this.namedLockFactory = Objects.requireNonNull(namedLockFactory);
        if (time < 0L) {
            throw new IllegalArgumentException("time cannot be negative");
        }
        this.time = time;
        this.timeUnit = Objects.requireNonNull(timeUnit);
    }

    public SyncContext newInstance(RepositorySystemSession session, boolean shared) {
        return new AdaptedLockSyncContext(session, shared, this.nameMapper, this.namedLockFactory, this.time, this.timeUnit);
    }

    public void shutdown() {
        this.namedLockFactory.shutdown();
    }

    private static class AdaptedLockSyncContext
    implements SyncContext {
        private static final Logger LOGGER = LoggerFactory.getLogger(AdaptedLockSyncContext.class);
        private final RepositorySystemSession session;
        private final boolean shared;
        private final NameMapper lockNaming;
        private final SessionAwareNamedLockFactory sessionAwareNamedLockFactory;
        private final NamedLockFactory namedLockFactory;
        private final long time;
        private final TimeUnit timeUnit;
        private final Deque<NamedLock> locks;

        private AdaptedLockSyncContext(RepositorySystemSession session, boolean shared, NameMapper lockNaming, NamedLockFactory namedLockFactory, long time, TimeUnit timeUnit) {
            this.session = session;
            this.shared = shared;
            this.lockNaming = lockNaming;
            this.sessionAwareNamedLockFactory = namedLockFactory instanceof SessionAwareNamedLockFactory ? (SessionAwareNamedLockFactory)namedLockFactory : null;
            this.namedLockFactory = namedLockFactory;
            this.time = time;
            this.timeUnit = timeUnit;
            this.locks = new ArrayDeque<NamedLock>();
        }

        @Override
        public void acquire(Collection<? extends Artifact> artifacts, Collection<? extends Metadata> metadatas) {
            Collection<String> keys = this.lockNaming.nameLocks(this.session, artifacts, metadatas);
            if (keys.isEmpty()) {
                return;
            }
            LOGGER.trace("Need {} {} lock(s) for {}", new Object[]{keys.size(), this.shared ? "read" : "write", keys});
            int acquiredLockCount = 0;
            for (String key : keys) {
                NamedLock namedLock = this.sessionAwareNamedLockFactory != null ? this.sessionAwareNamedLockFactory.getLock(this.session, key) : this.namedLockFactory.getLock(key);
                try {
                    LOGGER.trace("Acquiring {} lock for '{}'", (Object)(this.shared ? "read" : "write"), (Object)key);
                    boolean locked = this.shared ? namedLock.lockShared(this.time, this.timeUnit) : namedLock.lockExclusively(this.time, this.timeUnit);
                    if (!locked) {
                        LOGGER.trace("Failed to acquire {} lock for '{}'", (Object)(this.shared ? "read" : "write"), (Object)key);
                        namedLock.close();
                        throw new IllegalStateException("Could not acquire " + (this.shared ? "read" : "write") + " lock for '" + namedLock.name() + "'");
                    }
                    this.locks.push(namedLock);
                    ++acquiredLockCount;
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new RuntimeException(e);
                }
            }
            LOGGER.trace("Total locks acquired: {}", (Object)acquiredLockCount);
        }

        @Override
        public void close() {
            if (this.locks.isEmpty()) {
                return;
            }
            int released = 0;
            while (!this.locks.isEmpty()) {
                NamedLock namedLock = this.locks.pop();
                Throwable throwable = null;
                try {
                    LOGGER.trace("Releasing {} lock for '{}'", (Object)(this.shared ? "read" : "write"), (Object)namedLock.name());
                    namedLock.unlock();
                    ++released;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (namedLock == null) continue;
                    if (throwable != null) {
                        try {
                            namedLock.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    namedLock.close();
                }
            }
            LOGGER.trace("Total locks released: {}", (Object)released);
        }
    }
}

