/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.named.support;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.aether.named.NamedLockFactory;
import org.eclipse.aether.named.support.NamedLockSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class NamedLockFactorySupport
implements NamedLockFactory {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final ConcurrentMap<String, NamedLockHolder> locks = new ConcurrentHashMap<String, NamedLockHolder>();

    @Override
    public NamedLockSupport getLock(String name) {
        return this.locks.compute(name, (k, v) -> {
            if (v == null) {
                v = new NamedLockHolder(this.createLock((String)k));
            }
            ((NamedLockHolder)v).incRef();
            return v;
        }).namedLock;
    }

    @Override
    public void shutdown() {
    }

    public boolean closeLock(NamedLockSupport lock) {
        AtomicBoolean destroyed = new AtomicBoolean(false);
        this.locks.compute(lock.name(), (k, v) -> {
            if (v != null && ((NamedLockHolder)v).decRef() == 0) {
                this.destroyLock(((NamedLockHolder)v).namedLock);
                destroyed.set(true);
                return null;
            }
            return v;
        });
        return destroyed.get();
    }

    protected void finalize() throws Throwable {
        try {
            if (!this.locks.isEmpty()) {
                this.logger.warn("Lock leak, referenced locks still exist {}", this.locks);
            }
        }
        finally {
            super.finalize();
        }
    }

    protected abstract NamedLockSupport createLock(String var1);

    protected void destroyLock(NamedLockSupport lock) {
    }

    private static final class NamedLockHolder {
        private final NamedLockSupport namedLock;
        private final AtomicInteger referenceCount;

        private NamedLockHolder(NamedLockSupport namedLock) {
            this.namedLock = namedLock;
            this.referenceCount = new AtomicInteger(0);
        }

        private int incRef() {
            return this.referenceCount.incrementAndGet();
        }

        private int decRef() {
            return this.referenceCount.decrementAndGet();
        }

        public String toString() {
            return "[refCount=" + this.referenceCount.get() + ", lock=" + this.namedLock + "]";
        }
    }
}

